/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.ReportClassLoader;
import it.businesslogic.ireport.connection.JRDataSourceProviderConnection;
import it.businesslogic.ireport.connection.JRHibernateConnection;
import it.businesslogic.ireport.export.JRTxtExporter;
import it.businesslogic.ireport.export.JRTxtExporterParameter;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.logpane.LogTextArea;
import it.businesslogic.ireport.gui.prompt.Prompter;
import it.businesslogic.ireport.util.Misc;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRJdk13Compiler;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.fill.JRFileVirtualizer;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.view.JasperViewer;

public class IReportCompiler
implements Runnable,
JRExportProgressMonitor {
    public static final int CMD_COMPILE = 1;
    public static final int CMD_EXPORT = 2;
    public static final int CMD_COMPILE_SCRIPTLET = 4;
    public static final String OUTPUT_DIRECTORY = "OUTPUT_DIRECTORY";
    public static final String OUTPUT_FORMAT = "OUTPUT_FORMAT";
    public static final String USE_EMPTY_DATASOURCE = "USE_EMPTY_DATASOURCE";
    public static final String USE_CONNECTION = "USE_CONNECTION";
    public static final String CONNECTION = "CONNECTION";
    public static final String SCRIPTLET_OUTPUT_DIRECTORY = "SCRIPTLET_OUTPUT_DIRECTORY";
    public static final String COMPILER = "COMPILER";
    public static final String EMPTY_DATASOURCE_RECORDS = "EMPTY_DATASOURCE_RECORDS";
    private String constTabTitle = "";
    private JList threadList = null;
    static PrintStream myPrintStream = null;
    int filledpage = 0;
    private String status = "Staring";
    private IReportConnection iReportConnection;
    private int statusLevel = 0;
    private JReportFrame jrf;
    private MainFrame mainFrame;
    private int command = 0;
    private HashMap properties = new HashMap();
    private Thread thread;
    private LogTextArea logTextArea = null;
    private String javaFile = "";
    private static String outputBuffer = "";
    static /* synthetic */ Class class$net$sf$jasperreports$engine$design$JRJdtCompiler;

    public void stopThread() {
        this.command = 0;
        if (this.thread != null && this.thread.isAlive()) {
            try {
                this.thread.interrupt();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.removeThread();
        this.getLogTextArea().setTitle("Killed" + this.constTabTitle);
        this.getLogTextArea().setRemovable(true);
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block171: {
            block177: {
                block164: {
                    block163: {
                        block172: {
                            block165: {
                                block160: {
                                    if (this.threadList != null) {
                                        dlm = (DefaultListModel)this.threadList.getModel();
                                        dlm.addElement(this);
                                        this.threadList.updateUI();
                                    }
                                    f_report_title = new File(this.getJrf().getReport().getFilename());
                                    this.constTabTitle = " [" + f_report_title.getName() + "]";
                                    this.logTextArea = this.getMainFrame().getLogPane().createNewLog();
                                    this.logTextArea.setTitle(this.status + this.constTabTitle);
                                    backupJRClasspath = JRProperties.getProperty((String)"net.sf.jasperreports.compiler.classpath");
                                    backupSystemClasspath = System.getProperty("java.class.path");
                                    compilation_ok = true;
                                    start = System.currentTimeMillis();
                                    out = System.out;
                                    err = System.err;
                                    if (IReportCompiler.myPrintStream == null) {
                                        IReportCompiler.myPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));
                                    }
                                    if (out != IReportCompiler.myPrintStream) {
                                        System.setOut(IReportCompiler.myPrintStream);
                                    }
                                    if (err != IReportCompiler.myPrintStream) {
                                        System.setErr(IReportCompiler.myPrintStream);
                                    }
                                    IReportCompiler.outputBuffer = "";
                                    fileName = this.jrf.getReport().getFilename();
                                    srcFileName = this.jrf.getReport().getFilename();
                                    fileName = Misc.changeFileExtension(fileName, "jasper");
                                    f = new File(fileName);
                                    if (this.properties.get("OUTPUT_DIRECTORY") != null) {
                                        fileName = (String)this.properties.get("OUTPUT_DIRECTORY");
                                        if (!fileName.endsWith(File.separator)) {
                                            fileName = fileName + File.separator;
                                        }
                                        fileName = fileName + f.getName();
                                    }
                                    scriptletFileName = this.jrf.getReport().getFilename();
                                    srcScriptletFileName = this.jrf.getReport().getFilename();
                                    srcScriptletFileName = scriptletFileName = srcScriptletFileName.substring(0, scriptletFileName.length() - 1) + "Scriptlet.java";
                                    f2 = new File(scriptletFileName);
                                    if (this.properties.get("SCRIPTLET_OUTPUT_DIRECTORY") != null) {
                                        scriptletFileName = (String)this.properties.get("SCRIPTLET_OUTPUT_DIRECTORY") + File.separatorChar + f2.getName();
                                    }
                                    reportDirectory = new File(this.jrf.getReport().getFilename()).getParent();
                                    classpath = JRProperties.getProperty((String)"net.sf.jasperreports.compiler.classpath");
                                    if (classpath != null) {
                                        classpath = classpath + File.pathSeparator + reportDirectory;
                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)classpath);
                                    } else if (System.getProperty("java.class.path") != null) {
                                        classpath = System.getProperty("java.class.path");
                                        classpath = classpath + File.pathSeparator + reportDirectory;
                                        System.setProperty("java.class.path", classpath);
                                    }
                                    reportDirectory = reportDirectory.replace('\\', '/');
                                    if (!reportDirectory.endsWith("/")) {
                                        reportDirectory = reportDirectory + "/";
                                    }
                                    if (!reportDirectory.startsWith("/")) {
                                        reportDirectory = "/" + reportDirectory;
                                    }
                                    reportClassLoader = new ReportClassLoader();
                                    reportClassLoader.setRelodablePaths(reportDirectory);
                                    reportClassLoader.rescanLibDirectory();
                                    try {
                                        Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[]{new URL("file://" + reportDirectory)}, (ClassLoader)reportClassLoader));
                                    }
                                    catch (MalformedURLException mue) {
                                        mue.printStackTrace();
                                    }
                                    if ((this.command & 4) != 0) {
                                        this.status = "compiling scriptlet";
                                        this.updateThreadList();
                                        start = System.currentTimeMillis();
                                        oldCompileTemp = tempDirStr = JRProperties.getProperty((String)"net.sf.jasperreports.compiler.temp.dir");
                                        if (tempDirStr == null || tempDirStr.length() == 0 || this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                            tempDirStr = this.mainFrame.getTranslatedCompileDirectory();
                                        }
                                        tempDirFile = new File(tempDirStr);
                                        this.javaFile = srcScriptletFileName;
                                        this.javaFile = new File(tempDirFile, this.javaFile).getPath();
                                        this.javaFile = this.jrf.getReport().getScriptletFileName();
                                        if (Misc.getLastWriteTime(this.javaFile) > Misc.getLastWriteTime(Misc.changeFileExtension(this.javaFile, "class"))) {
                                            this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\">Compiling scriptlet source file... " + this.javaFile + "</font>", true);
                                            try {
                                                compiler = new JRJdk13Compiler();
                                                errors = compiler.compileClass(new File(this.javaFile), Misc.getClassPath());
                                                if (errors != null && errors.length() > 0) {
                                                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Errors compiling " + this.javaFile + "!</b></font>", true);
                                                    this.getLogTextArea().logOnConsole(errors);
                                                    compilation_ok = false;
                                                }
                                            }
                                            catch (Exception ex) {
                                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Error compiling the Scriptlet java source!</b></font>", true);
                                                sw = new StringWriter(0);
                                                ex.printStackTrace(new PrintWriter(sw));
                                                IReportCompiler.myPrintStream.flush();
                                                this.parseException(IReportCompiler.outputBuffer + sw.getBuffer() + "", null);
                                                compilation_ok = false;
                                            }
                                            catch (Throwable ext) {
                                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Error compiling the Scriptlet java source!</b></font>", true);
                                                sw = new StringWriter(0);
                                                ext.printStackTrace(new PrintWriter(sw));
                                                IReportCompiler.myPrintStream.flush();
                                                this.parseException(IReportCompiler.outputBuffer + sw.getBuffer() + "", null);
                                                compilation_ok = false;
                                            }
                                            finally {
                                                if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                                    // empty if block
                                                }
                                            }
                                            this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer);
                                            IReportCompiler.outputBuffer = "";
                                            this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>Compilation running time : " + (System.currentTimeMillis() - start) + "</b></font><hr>", true);
                                        }
                                    }
                                    if (!compilation_ok) {
                                        this.removeThread();
                                        return;
                                    }
                                    if ((this.command & 1) == 0) break block165;
                                    this.status = "compiling report";
                                    this.updateThreadList();
                                    if (this.mainFrame.getProperties().getProperty("KeepJavaFile", "true").equals("false")) {
                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.keep.java.file", (boolean)false);
                                    } else {
                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.keep.java.file", (boolean)true);
                                    }
                                    this.javaFile = this.jrf.getReport().getName() + ".java";
                                    oldCompileTemp = tempDirStr = JRProperties.getProperty((String)"net.sf.jasperreports.compiler.temp.dir");
                                    if (tempDirStr == null || tempDirStr.length() == 0 || this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                        tempDirStr = this.mainFrame.getTranslatedCompileDirectory();
                                    }
                                    tempDirFile = new File(tempDirStr);
                                    this.javaFile = new File(tempDirFile, this.javaFile).getPath();
                                    img_url_comp = this.getClass().getResource("/it/businesslogic/ireport/icons/comp1_mini.jpg");
                                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url_comp + "\"> &nbsp;Compiling to file... " + fileName + " -> " + this.javaFile + "</font>", true);
                                    old_jr_classpath = Misc.nvl(JRProperties.getProperty((String)"net.sf.jasperreports.compiler.classpath"), "");
                                    old_defaul_compiler = Misc.nvl(JRProperties.getProperty((String)"net.sf.jasperreports.compiler.class"), "");
                                    try {
                                        try {
                                            block167: {
                                                block168: {
                                                    block170: {
                                                        block169: {
                                                            block166: {
                                                                if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                                                    JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)tempDirStr);
                                                                }
                                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)(Misc.nvl(new File(fileName).getParent(), ".") + File.pathSeparator + Misc.getClassPath()));
                                                                compiler_name = "JasperReports default compiler";
                                                                compiler_code = this.mainFrame.getProperties().getProperty("DefaultCompiler");
                                                                if (this.getProperties().get("COMPILER") == null) break block166;
                                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)("" + this.getProperties().get("COMPILER")));
                                                                compiler_name = "Special language compiler (" + this.getProperties().get("COMPILER") + ")";
                                                                break block167;
                                                            }
                                                            if (compiler_code == null || compiler_code.equals("0") || compiler_code.equals("")) break block168;
                                                            if (!compiler_code.equals("1")) break block169;
                                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)"net.sf.jasperreports.engine.design.JRJdk13Compiler");
                                                            compiler_name = "Java Compiler";
                                                            break block167;
                                                        }
                                                        if (!compiler_code.equals("2")) break block170;
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)"net.sf.jasperreports.engine.design.JRJdtCompiler");
                                                        compiler_name = "JDT Compiler";
                                                        Thread.currentThread().setContextClassLoader(reportClassLoader);
                                                        cl = this.getClassLoader();
                                                        System.out.println(cl);
                                                        break block167;
                                                    }
                                                    if (compiler_code.equals("3")) {
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)"net.sf.jasperreports.engine.design.JRBshCompiler");
                                                        compiler_name = "BeanShell Compiler";
                                                        break block167;
                                                    } else if (compiler_code.equals("4")) {
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)"net.sf.jasperreports.engine.design.JRJikesCompiler");
                                                        compiler_name = "Jikes Compiler";
                                                    }
                                                    break block167;
                                                }
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)"");
                                                Thread.currentThread().setContextClassLoader(reportClassLoader);
                                                cl = this.getClassLoader();
                                                System.out.println(cl);
                                            }
                                            start = System.currentTimeMillis();
                                            JasperCompileManager.compileReportToFile((String)srcFileName, (String)fileName);
                                        }
                                        catch (JRException jrex) {
                                            compilation_ok = false;
                                            this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Errors compiling " + fileName + "!</b></font>", true);
                                            source = new Vector<String>();
                                            try {
                                                is = new BufferedReader(new FileReader(this.javaFile));
                                                while (true) {
                                                    if ((line = is.readLine()) == null) {
                                                        is.close();
                                                        break;
                                                    }
                                                    source.addElement(line);
                                                }
                                            }
                                            catch (Exception ioex) {
                                                // empty catch block
                                            }
                                            sw = new StringWriter(0);
                                            jrex.printStackTrace(new PrintWriter(sw));
                                            System.out.println("\n\n\n");
                                            IReportCompiler.myPrintStream.flush();
                                            this.parseException(IReportCompiler.outputBuffer + sw.getBuffer() + "", source);
                                            var29_46 = null;
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)old_jr_classpath);
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)old_defaul_compiler);
                                            if (!this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) break block160;
                                            if (oldCompileTemp != null) {
                                                System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)oldCompileTemp);
                                            } else {
                                                System.setProperty("jasper.reports.compile.temp", "");
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)"");
                                            }
                                            javaSrcFile = new File(this.javaFile);
                                            if (javaSrcFile.exists() && this.mainFrame.getProperties().getProperty("KeepJavaFile", "true").equals("false")) {
                                                javaSrcFile.delete();
                                            }
                                            break block160;
                                        }
                                        catch (Exception ex) {
                                            this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Error compiling the report java source!</b></font>", true);
                                            sw = new StringWriter(0);
                                            ex.printStackTrace(new PrintWriter(sw));
                                            IReportCompiler.myPrintStream.flush();
                                            this.parseException(IReportCompiler.outputBuffer + sw.getBuffer() + "", null);
                                            compilation_ok = false;
                                            var29_47 = null;
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)old_jr_classpath);
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)old_defaul_compiler);
                                            if (!this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) break block160;
                                            if (oldCompileTemp != null) {
                                                System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)oldCompileTemp);
                                            } else {
                                                System.setProperty("jasper.reports.compile.temp", "");
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)"");
                                            }
                                            javaSrcFile = new File(this.javaFile);
                                            if (javaSrcFile.exists() && this.mainFrame.getProperties().getProperty("KeepJavaFile", "true").equals("false")) {
                                                javaSrcFile.delete();
                                            }
                                            break block160;
                                        }
                                        catch (Throwable ext) {
                                            this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Error compiling the report java source!</b></font>", true);
                                            sw = new StringWriter(0);
                                            ext.printStackTrace(new PrintWriter(sw));
                                            IReportCompiler.myPrintStream.flush();
                                            this.parseException(IReportCompiler.outputBuffer + sw.getBuffer() + "", null);
                                            compilation_ok = false;
                                            var29_48 = null;
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)old_jr_classpath);
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)old_defaul_compiler);
                                            if (!this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) break block160;
                                            if (oldCompileTemp != null) {
                                                System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)oldCompileTemp);
                                            } else {
                                                System.setProperty("jasper.reports.compile.temp", "");
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)"");
                                            }
                                            javaSrcFile = new File(this.javaFile);
                                            if (javaSrcFile.exists() && this.mainFrame.getProperties().getProperty("KeepJavaFile", "true").equals("false")) {
                                                javaSrcFile.delete();
                                            }
                                            break block160;
                                        }
                                        var29_45 = null;
                                    }
                                    catch (Throwable var28_57) {
                                        var29_49 = null;
                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)old_jr_classpath);
                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)old_defaul_compiler);
                                        if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles() == false) throw var28_57;
                                        if (oldCompileTemp != null) {
                                            System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)oldCompileTemp);
                                        } else {
                                            System.setProperty("jasper.reports.compile.temp", "");
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)"");
                                        }
                                        javaSrcFile = new File(this.javaFile);
                                        if (javaSrcFile.exists() == false) throw var28_57;
                                        if (this.mainFrame.getProperties().getProperty("KeepJavaFile", "true").equals("false") == false) throw var28_57;
                                        javaSrcFile.delete();
                                        throw var28_57;
                                    }
                                    JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)old_jr_classpath);
                                    JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)old_defaul_compiler);
                                    if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                        if (oldCompileTemp != null) {
                                            System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)oldCompileTemp);
                                        } else {
                                            System.setProperty("jasper.reports.compile.temp", "");
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)"");
                                        }
                                        javaSrcFile = new File(this.javaFile);
                                        if (javaSrcFile.exists() && this.mainFrame.getProperties().getProperty("KeepJavaFile", "true").equals("false")) {
                                            javaSrcFile.delete();
                                        }
                                    }
                                }
                                this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer);
                                IReportCompiler.outputBuffer = "";
                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>Compilation running time : " + (System.currentTimeMillis() - start) + "</b></font><hr>", true);
                            }
                            if (!compilation_ok) {
                                this.removeThread();
                                return;
                            }
                            if ((this.command & 2) == 0) break block171;
                            this.status = "generating report";
                            this.updateThreadList();
                            print = null;
                            img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/rundb1_mini.jpg");
                            this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;Filling report... </font>", true);
                            this.statusLevel = 5;
                            hm = Prompter.promptForParameters(this.getJrf().getReport());
                            hm.put("REPORT_LOCALE", Misc.getLocaleFromString(this.mainFrame.getProperties().getProperty("reportLocale")));
                            img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/world.png");
                            this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;Locale: <b>" + Misc.getLocaleFromString(this.mainFrame.getProperties().getProperty("reportLocale")).getDisplayName() + "</b></font>", true);
                            reportMaxCount = 0;
                            try {
                                reportMaxCount = Integer.parseInt(this.mainFrame.getProperties().getProperty("maxRecords", "0"));
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            if (reportMaxCount > 0) {
                                img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/file-info.png");
                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;Max number of records: <b>" + reportMaxCount + "</b></font>", true);
                                hm.put("REPORT_MAX_COUNT", new Integer(reportMaxCount));
                            }
                            if (MainFrame.getMainInstance().isIgnorePagination()) {
                                hm.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
                                img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/file-info.png");
                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;Ignoring pagination</font>", true);
                            }
                            if (MainFrame.getMainInstance().isUseReportVirtualizer()) {
                                try {
                                    virtualizer = new JRFileVirtualizer(Integer.parseInt(this.mainFrame.getProperties().getProperty("ReportVirtualizerSize", "100")), this.mainFrame.getProperties().getProperty("ReportVirtualizerDirectory", this.mainFrame.getTranslatedCompileDirectory()));
                                    img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/file-info.png");
                                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;Using report virtualizer... Size: " + Integer.parseInt(this.mainFrame.getProperties().getProperty("ReportVirtualizerSize", "100000")) + " Cache directory: " + this.mainFrame.getProperties().getProperty("ReportVirtualizerDirectory", this.mainFrame.getTranslatedCompileDirectory()) + "</font>", true);
                                    hm.put("REPORT_VIRTUALIZER", virtualizer);
                                }
                                catch (Throwable ex) {
                                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#660000\">WARNING: Report virtualizer not available.</font>", true);
                                }
                            }
                            start = System.currentTimeMillis();
                            if (this.properties.get("USE_EMPTY_DATASOURCE") == null || !this.properties.get("USE_EMPTY_DATASOURCE").equals("true")) break block172;
                            try {
                                records = 1;
                                try {
                                    records = (Integer)this.properties.get("EMPTY_DATASOURCE_RECORDS");
                                }
                                catch (Exception ex) {
                                    records = 1;
                                }
                                print = JasperFillManager.fillReport((String)fileName, (Map)hm, (JRDataSource)new JREmptyDataSource(records));
                            }
                            catch (Exception ex) {
                                this.getLogTextArea().logOnConsole("Error filling print...\n");
                                ex.printStackTrace();
                                this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer);
                                IReportCompiler.outputBuffer = "";
                            }
                            break block163;
                        }
                        if (this.properties.get("USE_CONNECTION") == null || !this.properties.get("USE_CONNECTION").equals("true")) break block163;
                        connection = (IReportConnection)this.properties.get("CONNECTION");
                        try {
                            block176: {
                                block161: {
                                    block174: {
                                        block175: {
                                            block173: {
                                                if (!connection.isJDBCConnection()) break block173;
                                                print = JasperFillManager.fillReport((String)fileName, (Map)hm, (Connection)connection.getConnection());
                                                ** GOTO lbl491
                                            }
                                            ds = null;
                                            if (!(connection instanceof JRDataSourceProviderConnection)) break block174;
                                            jasper_report_obj = JasperManager.loadReport((String)fileName);
                                            ds = ((JRDataSourceProviderConnection)connection).getJRDataSource(jasper_report_obj);
                                            if (ds != null) break block175;
                                            var35_60 = null;
                                            if (connection == null) return;
                                            ** GOTO lbl484
                                        }
                                        print = JasperFillManager.fillReport((JasperReport)jasper_report_obj, (Map)hm, (JRDataSource)ds);
                                        try {
                                            ((JRDataSourceProviderConnection)connection).disposeDataSource();
                                        }
                                        catch (Exception ex) {
                                            System.out.println("Error closing datasource: " + ex.getMessage());
                                        }
                                        ** GOTO lbl491
                                    }
                                    if (!(connection instanceof JRHibernateConnection)) break block176;
                                    session = null;
                                    transaction = null;
                                    System.out.println("Hibernate session opened");
                                    try {
                                        session = ((JRHibernateConnection)connection).createSession();
                                        transaction = session.beginTransaction();
                                        hm.put("HIBERNATE_SESSION", session);
                                        print = JasperFillManager.fillReport((String)fileName, (Map)hm);
                                        var32_70 = null;
                                        if (transaction == null) break block161;
                                    }
                                    catch (Throwable var31_74) {
                                        var32_71 = null;
                                        if (transaction != null) {
                                            try {
                                                transaction.rollback();
                                            }
                                            catch (Exception ex) {
                                                // empty catch block
                                            }
                                        }
                                        if (session == null) throw var31_74;
                                        try {
                                            session.close();
                                            System.out.println("Hibernate session closed");
                                            throw var31_74;
                                        }
                                        catch (Exception ex) {
                                            // empty catch block
                                        }
                                        throw var31_74;
                                    }
                                    ** try [egrp 16[TRYBLOCK] [24 : 3333->3343)] { 
lbl428:
                                    // 1 sources

                                    transaction.rollback();
                                    break block161;
lbl430:
                                    // 1 sources

                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                }
                                if (session != null) {
                                    try {}
                                    catch (Exception ex) {}
                                    session.close();
                                    System.out.println("Hibernate session closed");
                                }
                                ** GOTO lbl491
                            }
                            ds = connection.getJRDataSource();
                            print = JasperFillManager.fillReport((String)fileName, (Map)hm, (JRDataSource)ds);
                            ** GOTO lbl491
                        }
                        catch (Exception ex) {
                            this.getLogTextArea().logOnConsole("Error filling print...\n");
                            ex.printStackTrace();
                            this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer);
                            IReportCompiler.outputBuffer = "";
                            var35_62 = null;
                            if (connection != null && connection instanceof JRDataSourceProviderConnection) {
                                try {
                                    ((JRDataSourceProviderConnection)connection).disposeDataSource();
                                }
                                catch (Exception ex) {
                                    System.out.println("Error closing datasource: " + ex.getMessage());
                                }
                            }
                            break block163;
                        }
                        catch (Throwable ext) {
                            this.getLogTextArea().logOnConsole("Error filling print...\n");
                            ext.printStackTrace();
                            this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer);
                            IReportCompiler.outputBuffer = "";
                            var35_63 = null;
                            if (connection != null && connection instanceof JRDataSourceProviderConnection) {
                                ** try [egrp 18[TRYBLOCK] [35 : 3498->3509)] { 
lbl468:
                                // 1 sources

                                ((JRDataSourceProviderConnection)connection).disposeDataSource();
lbl470:
                                // 1 sources

                                catch (Exception ex) {
                                    System.out.println("Error closing datasource: " + ex.getMessage());
                                }
                            }
                            break block163;
                        }
                        {
                            catch (Throwable var34_75) {
                                var35_64 = null;
                                if (connection == null) throw var34_75;
                                if (connection instanceof JRDataSourceProviderConnection == false) throw var34_75;
                                ** try [egrp 18[TRYBLOCK] [35 : 3498->3509)] { 
lbl479:
                                // 1 sources

                                ((JRDataSourceProviderConnection)connection).disposeDataSource();
                                throw var34_75;
lbl481:
                                // 1 sources

                                catch (Exception ex) {
                                    System.out.println("Error closing datasource: " + ex.getMessage());
                                }
                                throw var34_75;
                            }
lbl484:
                            // 1 sources

                            if (connection instanceof JRDataSourceProviderConnection == false) return;
                            ** try [egrp 18[TRYBLOCK] [35 : 3498->3509)] { 
lbl486:
                            // 1 sources

                            ((JRDataSourceProviderConnection)connection).disposeDataSource();
                            return;
lbl488:
                            // 1 sources

                            catch (Exception ex) {
                                System.out.println("Error closing datasource: " + ex.getMessage());
                            }
                            return;
lbl491:
                            // 6 sources

                            var35_61 = null;
                            if (connection == null || !(connection instanceof JRDataSourceProviderConnection)) break block163;
                            ** try [egrp 18[TRYBLOCK] [35 : 3498->3509)] { 
lbl494:
                            // 1 sources

                            ((JRDataSourceProviderConnection)connection).disposeDataSource();
lbl496:
                            // 1 sources

                            catch (Exception ex) {}
                            System.out.println("Error closing datasource: " + ex.getMessage());
                        }
                    }
                    jrv = null;
                    exporter /* !! */  = null;
                    this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer);
                    IReportCompiler.outputBuffer = "";
                    if (print == null) break block177;
                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>Report fill running time : " + (System.currentTimeMillis() - start) + "</b> (pages generated: " + print.getPages().size() + ")</font><hr>", true);
                    this.status = "exporting report";
                    this.updateThreadList();
                    start = System.currentTimeMillis();
                    format = Misc.nvl(this.properties.get("OUTPUT_FORMAT"), "pdf");
                    viewer_program = "";
                    this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer);
                    IReportCompiler.outputBuffer = "";
                    exportingMessage = "";
                    try {
                        if (format.equalsIgnoreCase("pdf")) {
                            exporter /* !! */  = new JRPdfExporter();
                            if (this.getMainFrame().getProperties().getProperty("PDF_IS_ENCRYPTED") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRPdfExporterParameter.IS_ENCRYPTED, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("PDF_IS_ENCRYPTED")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("PDF_IS_128_BIT_KEY") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRPdfExporterParameter.IS_128_BIT_KEY, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("PDF_IS_128_BIT_KEY")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("PDF_USER_PASSWORD") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRPdfExporterParameter.USER_PASSWORD, (Object)this.getMainFrame().getProperties().getProperty("PDF_USER_PASSWORD"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("PDF_OWNER_PASSWORD") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRPdfExporterParameter.OWNER_PASSWORD, (Object)this.getMainFrame().getProperties().getProperty("PDF_OWNER_PASSWORD"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("PDF_PERMISSIONS") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRPdfExporterParameter.PERMISSIONS, (Object)new Integer(this.getMainFrame().getProperties().getProperty("PDF_PERMISSIONS")));
                            }
                            fileName = Misc.changeFileExtension(fileName, "pdf");
                            exportingMessage = "Exporting pdf to file (using iText)... " + fileName + "";
                            viewer_program = this.mainFrame.getProperties().getProperty("ExternalPDFViewer");
                        } else if (format.equalsIgnoreCase("csv")) {
                            exporter /* !! */  = new JRCsvExporter();
                            if (this.getMainFrame().getProperties().getProperty("CSV_FIELD_DELIMITER") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)this.getMainFrame().getProperties().getProperty("CSV_FIELD_DELIMITER"));
                            }
                            fileName = Misc.changeFileExtension(fileName, "csv");
                            exportingMessage = "Exporting CSV to file... " + fileName + "";
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalCSVViewer"), "");
                        } else if (format.equalsIgnoreCase("html")) {
                            exporter /* !! */  = new JRHtmlExporter();
                            if (this.getMainFrame().getProperties().getProperty("HTML_IMAGES_DIR_NAME") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_DIR_NAME, (Object)this.getMainFrame().getProperties().getProperty("HTML_IMAGES_DIR_NAME"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_IS_OUTPUT_IMAGES_TO_DIR") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("HTML_IS_OUTPUT_IMAGES_TO_DIR")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_IMAGES_URI") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)this.getMainFrame().getProperties().getProperty("HTML_IMAGES_URI"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_HTML_HEADER") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_HEADER, (Object)this.getMainFrame().getProperties().getProperty("HTML_HTML_HEADER"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_BETWEEN_PAGES_HTML") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.BETWEEN_PAGES_HTML, (Object)this.getMainFrame().getProperties().getProperty("HTML_BETWEEN_PAGES_HTML"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_HTML_FOOTER") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_FOOTER, (Object)this.getMainFrame().getProperties().getProperty("HTML_HTML_FOOTER"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("HTML_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_IS_WHITE_PAGE_BACKGROUND") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("HTML_IS_WHITE_PAGE_BACKGROUND")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_IS_USING_IMAGES_TO_ALIGN") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("HTML_IS_USING_IMAGES_TO_ALIGN")));
                            }
                            fileName = Misc.changeFileExtension(fileName, "html");
                            exportingMessage = "Exporting HTML to file... " + fileName + "";
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalHTMLViewer"), "");
                        } else if (format.equalsIgnoreCase("xls")) {
                            exporter /* !! */  = new JRXlsExporter();
                            if (this.getMainFrame().getProperties().getProperty("XLS_IS_ONE_PAGE_PER_SHEET") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_ONE_PAGE_PER_SHEET")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("XLS_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("XLS_IS_WHITE_PAGE_BACKGROUND") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_WHITE_PAGE_BACKGROUND")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("XLS_IS_AUTO_DETECT_CELL_TYPE") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRXlsExporterParameter.IS_AUTO_DETECT_CELL_TYPE, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_AUTO_DETECT_CELL_TYPE")));
                            }
                            fileName = Misc.changeFileExtension(fileName, "xls");
                            exportingMessage = "Exporting xls to file (using POI)... " + fileName + "";
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalXLSViewer"), "");
                        } else if (format.equalsIgnoreCase("xls2")) {
                            exporter /* !! */  = new JExcelApiExporter();
                            if (this.getMainFrame().getProperties().getProperty("XLS2_IS_FONT_SIZE_FIX_ENABLED") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS2_IS_FONT_SIZE_FIX_ENABLED")));
                            }
                            fileName = Misc.changeFileExtension(fileName, "xls");
                            exportingMessage = "Exporting xls to file (using JExcelApi)... " + fileName + "";
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalXLSViewer"), "");
                        } else if (format.equalsIgnoreCase("java2D")) {
                            exporter /* !! */  = new JRGraphics2DExporter();
                            exportingMessage = "Exporting to Java2D ";
                            viewer_program = null;
                        } else if (format.equalsIgnoreCase("jrviewer")) {
                            exportingMessage = "Viewing with JasperReports Viewer";
                            exporter /* !! */  = null;
                            viewer_program = null;
                        } else if (format.equalsIgnoreCase("txt")) {
                            exporter /* !! */  = new JRTxtExporter();
                            if (this.getMainFrame().getProperties().getProperty("TXT_PAGE_ROWS") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTxtExporterParameter.PAGE_ROWS, (Object)this.getMainFrame().getProperties().getProperty("TXT_PAGE_ROWS"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("TXT_PAGE_COLUMNS") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTxtExporterParameter.PAGE_COLUMNS, (Object)this.getMainFrame().getProperties().getProperty("TXT_PAGE_COLUMNS"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("TXT_ADD_FORM_FEED") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTxtExporterParameter.ADD_FORM_FEED, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("TXT_ADD_FORM_FEED")));
                            }
                            fileName = Misc.changeFileExtension(fileName, "txt");
                            exportingMessage = "Exporting txt (iReport) to file... " + fileName + "\n";
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalTXTViewer"), "");
                        } else if (format.equalsIgnoreCase("txtjr")) {
                            exporter /* !! */  = new JRTextExporter();
                            if (this.getMainFrame().getProperties().getProperty("JRTXT_PAGE_WIDTH") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_WIDTH, (Object)new Integer(this.getMainFrame().getProperties().getProperty("JRTXT_PAGE_WIDTH")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("JRTXT_PAGE_HEIGHT") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_HEIGHT, (Object)new Integer(this.getMainFrame().getProperties().getProperty("JRTXT_PAGE_HEIGHT")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("JRTXT_CHARACTER_WIDTH") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)new Integer(this.getMainFrame().getProperties().getProperty("JRTXT_CHARACTER_WIDTH")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("JRTXT_CHARACTER_HEIGHT") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, (Object)new Integer(this.getMainFrame().getProperties().getProperty("JRTXT_CHARACTER_HEIGHT")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("JRTXT_BETWEEN_PAGES_TEXT") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTextExporterParameter.BETWEEN_PAGES_TEXT, (Object)this.getMainFrame().getProperties().getProperty("JRTXT_BETWEEN_PAGES_TEXT"));
                            }
                            fileName = Misc.changeFileExtension(fileName, "txt");
                            exportingMessage = "Exporting txt (jasperReports) to file... " + fileName + "";
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalTXTViewer"), "");
                        } else if (format.equalsIgnoreCase("rtf")) {
                            exporter /* !! */  = new JRRtfExporter();
                            fileName = Misc.changeFileExtension(fileName, "rtf");
                            exportingMessage = "Exporting RTF to file... " + fileName + "";
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalRTFViewer"), "");
                        }
                        img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/printer_mini.png");
                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + exportingMessage + "</font>", true);
                        if (exporter /* !! */  != null) {
                            exporter /* !! */ .setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)fileName);
                            exporter /* !! */ .setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                            exporter /* !! */ .setParameter(JRExporterParameter.PROGRESS_MONITOR, (Object)this);
                            exporter /* !! */ .exportReport();
                            this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer);
                            IReportCompiler.outputBuffer = "";
                            break block164;
                        }
                        if (format.equalsIgnoreCase("jrviewer")) {
                            jasperViewer = new JasperViewer(print, false);
                            jasperViewer.setTitle("iReport JasperViewer");
                            jasperViewer.setVisible(true);
                        }
                    }
                    catch (Throwable ex2) {
                        this.getLogTextArea().logOnConsole("Error exporting print...\n");
                        ex2.printStackTrace();
                        this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer);
                        IReportCompiler.outputBuffer = "";
                    }
                }
                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>Export running time : " + (System.currentTimeMillis() - start) + "</b></font><hr>", true);
                rt = Runtime.getRuntime();
                if (viewer_program == null || viewer_program.equals("")) {
                    if (!format.equalsIgnoreCase("jrviewer")) {
                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\">No external viewer specified for this type of print. Set it in the options frame!</font>", true);
                    }
                    break block171;
                } else {
                    try {
                        execute_string = viewer_program + " " + fileName + "";
                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\">Executing: " + execute_string + "</font>", true);
                        rt.exec(execute_string);
                    }
                    catch (Exception ex) {
                        this.getLogTextArea().logOnConsole("Error viewing report...\n");
                        ex.printStackTrace();
                        this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer + "\n");
                        IReportCompiler.outputBuffer = "";
                    }
                }
                break block171;
            }
            this.getLogTextArea().logOnConsole("Print not filled. Try to use an EmptyDataSource...!\n");
        }
        this.removeThread();
        if (backupJRClasspath != null) {
            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)backupJRClasspath);
        } else {
            JRProperties.restoreProperties();
        }
        if (backupSystemClasspath != null) {
            System.setProperty("java.class.path", backupSystemClasspath);
        } else {
            System.getProperties().remove("java.class.path");
        }
        System.gc();
    }

    public void removeThread() {
        if (this.threadList != null) {
            DefaultListModel dlm = (DefaultListModel)this.threadList.getModel();
            dlm.removeElement(this);
            this.threadList.updateUI();
            this.getLogTextArea().setTitle("Finished" + this.constTabTitle);
            this.getLogTextArea().setRemovable(true);
        }
    }

    public int getCommand() {
        return this.command;
    }

    public void setCommand(int command) {
        this.command = command;
    }

    public IReportConnection getIReportConnection() {
        return this.iReportConnection;
    }

    public void setIReportConnection(IReportConnection iReportConnection) {
        this.iReportConnection = iReportConnection;
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap properties) {
        this.properties = properties;
    }

    public String toString() {
        return this.status;
    }

    public void start() {
        this.thread = new Thread(this);
        try {
            String reportDirectory = new File(this.jrf.getReport().getFilename()).getParent();
            String classpath = JRProperties.getProperty((String)"net.sf.jasperreports.compiler.classpath");
            if (classpath != null) {
                classpath = classpath + File.pathSeparator + reportDirectory;
                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)classpath);
            } else if (System.getProperty("java.class.path") != null) {
                classpath = System.getProperty("java.class.path");
                classpath = classpath + File.pathSeparator + reportDirectory;
                System.setProperty("java.class.path", classpath);
            }
            reportDirectory = reportDirectory.replace('\\', '/');
            if (!reportDirectory.endsWith("/")) {
                reportDirectory = reportDirectory + "/";
            }
            if (!reportDirectory.startsWith("/")) {
                reportDirectory = "/" + reportDirectory;
            }
            this.thread.setContextClassLoader(new URLClassLoader(new URL[]{new URL("file://" + reportDirectory)}));
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        this.thread.start();
    }

    public void parseException(String exception, Vector sourceLines) {
        String outString = "";
        StringTokenizer st = new StringTokenizer(exception, "\n");
        while (st.hasMoreElements()) {
            String line = st.nextToken();
            if (line.startsWith(this.javaFile)) {
                String lineCode;
                outString = outString + Misc.toHTML(line + "\n");
                String lineNumber = line.substring(this.javaFile.length() + 1);
                int ln = Integer.parseInt(lineNumber = lineNumber.substring(0, lineNumber.indexOf(58)));
                if (ln >= 3) {
                    ln -= 3;
                }
                String reference = "";
                if (sourceLines.size() >= ln && (lineCode = (String)sourceLines.elementAt(ln)).indexOf("            case") == 0 && lineCode.indexOf(" : // ") > 0) {
                    reference = lineCode.substring(lineCode.indexOf(" : // ") + 6).trim();
                }
                if (!st.hasMoreElements()) continue;
                try {
                    String error_line = st.nextToken();
                    if (error_line.startsWith("found")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("required")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("symbol")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("location")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    String html = "";
                    for (int i = 0; i < error_line.length() && error_line.charAt(i) == ' '; ++i) {
                        html = html + "&nbsp;";
                    }
                    error_line = error_line.trim();
                    html = html + "<a href=\"http://error:" + this.jrf.getWindowID() + "/" + reference + "\">" + Misc.toHTML(error_line) + "</a>";
                    outString = outString + html;
                }
                catch (Exception ex) {
                    outString = outString + Misc.toHTML("Error parsing\n!");
                }
                continue;
            }
            if (line.startsWith("Warning :") && line.indexOf("y=") > 0 && line.indexOf("height=") > 0 && line.indexOf("band-height=") > 0) {
                outString = outString + "<a href=\"http://warning:" + this.jrf.getWindowID() + "\">" + Misc.toHTML(line) + "</a>";
                continue;
            }
            outString = outString + Misc.toHTML(line + "\n");
        }
        this.getLogTextArea().logOnConsole(outString, true);
        outputBuffer = "";
    }

    public JComponent searchButton(JComponent root, String text) {
        if (root instanceof JButton && ((JButton)root).getText() != null && ((JButton)root).getText().equals(text)) {
            return root;
        }
        for (int i = 0; i < root.getComponentCount(); ++i) {
            if (!(root.getComponent(i) instanceof JComponent)) continue;
            this.getLogTextArea().logOnConsole("" + (JComponent)root.getComponent(i) + "\n");
            JComponent res = this.searchButton((JComponent)root.getComponent(i), text);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public void afterPageExport() {
        ++this.filledpage;
        if (this.command == 0) {
            // empty if block
        }
    }

    public JList getThreadList() {
        return this.threadList;
    }

    public void setThreadList(JList threadList) {
        this.threadList = threadList;
    }

    public void updateThreadList() {
        this.getLogTextArea().setTitle(this.status + this.constTabTitle);
        try {
            if (this.threadList != null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        IReportCompiler.this.threadList.updateUI();
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                Class.forName((class$net$sf$jasperreports$engine$design$JRJdtCompiler == null ? (class$net$sf$jasperreports$engine$design$JRJdtCompiler = IReportCompiler.class$("net.sf.jasperreports.engine.design.JRJdtCompiler")) : class$net$sf$jasperreports$engine$design$JRJdtCompiler).getName(), true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                classLoader = null;
            }
        }
        if (classLoader == null) {
            // empty if block
        }
        return classLoader;
    }

    public LogTextArea getLogTextArea() {
        return this.logTextArea;
    }

    public void setLogTextArea(LogTextArea logTextArea) {
        this.logTextArea = logTextArea;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        public void write(byte[] b) throws IOException {
            String aString = new String(b);
            outputBuffer = outputBuffer + aString;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len);
            outputBuffer = outputBuffer + aString;
        }
    }
}

