/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.library.objects;

import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.library.CustomExpression;
import it.businesslogic.ireport.gui.library.LibraryTreeCellRenderer;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.tokenmarker.JavaTokenMarker;

public class TotalObjectDialog
extends JDialog {
    int dialogResult = 0;
    DefaultMutableTreeNode fieldsNode = null;
    DefaultMutableTreeNode variablesNode = null;
    DefaultMutableTreeNode parametersNode = null;
    private JReportFrame jrf = null;
    private Object selectedObject = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabelTitle;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRTextExpressionArea jRTextExpressionAreaDefaultExpression;
    private JScrollPane jScrollPane1;
    private JTree jTree1;

    public TotalObjectDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(400, 450);
        this.setModal(true);
        SyntaxDocument sd = new SyntaxDocument();
        sd.setTokenMarker(new JavaTokenMarker());
        this.jRTextExpressionAreaDefaultExpression.setDocument(sd);
        this.jTree1.setCellRenderer(new LibraryTreeCellRenderer());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Libs");
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        this.jTree1.setModel(dtm);
        this.jTree1.setDragEnabled(true);
        this.jTree1.setRootVisible(false);
        this.jTree1.expandPath(new TreePath(root));
        this.fieldsNode = new DefaultMutableTreeNode(I18n.getString("gui.library.fields", "Fields"), true);
        root.add(this.fieldsNode);
        this.variablesNode = new DefaultMutableTreeNode(I18n.getString("gui.library.variables", "Variables"), true);
        root.add(this.variablesNode);
        this.parametersNode = new DefaultMutableTreeNode(I18n.getString("gui.library.parameters", "Parameters"), true);
        root.add(this.parametersNode);
        root.add(new DefaultMutableTreeNode(new CustomExpression(I18n.getString("gui.library.customexpression", "Custom expression")), true));
        this.jLabelTitle.setText(I18n.getString("gui.library.totalobject.title", "Select object to sum"));
        this.dialogResult = 2;
        Misc.centerFrame(this);
    }

    private void initComponents() {
        this.jLabelTitle = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jRTextExpressionAreaDefaultExpression = new JRTextExpressionArea();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jLabelTitle.setFont(new Font("Dialog", 0, 12));
        this.jLabelTitle.setText("Select object to sum");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabelTitle, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(81, 180));
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                TotalObjectDialog.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jRTextExpressionAreaDefaultExpression.setBorder(new EtchedBorder());
        this.jRTextExpressionAreaDefaultExpression.setElectricScroll(0);
        this.jRTextExpressionAreaDefaultExpression.setMinimumSize(new Dimension(0, 60));
        this.jRTextExpressionAreaDefaultExpression.setPreferredSize(new Dimension(310, 60));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jRTextExpressionAreaDefaultExpression, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(10, 30));
        this.jPanel1.setPreferredSize(new Dimension(10, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TotalObjectDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButtonOK, new GridBagConstraints());
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TotalObjectDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dialogResult = 2;
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.selectedObject == null) {
            JOptionPane.showMessageDialog(this, I18n.getString("gui.library.totalobject.selectanobject", "Select an object to sum first"));
            return;
        }
        this.dialogResult = 0;
        this.setVisible(false);
        this.dispose();
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        this.selectedObject = null;
        if (this.jTree1.getLastSelectedPathComponent() != null) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.jTree1.getLastSelectedPathComponent();
            Object obj = dmtn.getUserObject();
            if (!dmtn.isLeaf()) {
                return;
            }
            if (obj instanceof CustomExpression) {
                this.jRTextExpressionAreaDefaultExpression.setEditable(true);
                this.jRTextExpressionAreaDefaultExpression.setBackground(Color.WHITE);
                this.jRTextExpressionAreaDefaultExpression.setOpaque(true);
            } else {
                if (obj instanceof JRParameter) {
                    this.jRTextExpressionAreaDefaultExpression.setText("$P{" + obj + "}");
                }
                if (obj instanceof JRVariable) {
                    this.jRTextExpressionAreaDefaultExpression.setText("$V{" + obj + "}");
                }
                if (obj instanceof JRField) {
                    this.jRTextExpressionAreaDefaultExpression.setText("$F{" + obj + "}");
                }
                this.jRTextExpressionAreaDefaultExpression.setEditable(false);
                this.jRTextExpressionAreaDefaultExpression.setBackground(Color.GRAY);
                this.jRTextExpressionAreaDefaultExpression.setOpaque(true);
            }
            this.selectedObject = obj;
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TotalObjectDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
        this.jRTextExpressionAreaDefaultExpression.getTokenMarker().setKeywordLookup(jrf.getReport().getKeywordLookup());
        this.fieldsNode.removeAllChildren();
        this.parametersNode.removeAllChildren();
        this.variablesNode.removeAllChildren();
        if (jrf == null) {
            this.jTree1.updateUI();
            return;
        }
        Enumeration e = jrf.getReport().getFields().elements();
        while (e.hasMoreElements()) {
            this.fieldsNode.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        e = jrf.getReport().getParameters().elements();
        while (e.hasMoreElements()) {
            this.parametersNode.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        e = jrf.getReport().getVariables().elements();
        while (e.hasMoreElements()) {
            this.variablesNode.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        this.jTree1.updateUI();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public Object getSelectedObject() {
        return this.selectedObject;
    }

    public void setSelectedObject(Object selectedObject) {
        this.selectedObject = selectedObject;
    }
}

