/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.style;

import it.businesslogic.ireport.ConditionedStyle;
import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.ExpressionEditor;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener;
import it.businesslogic.ireport.gui.event.StyleChangedEvent;
import it.businesslogic.ireport.gui.sheet.CategorySheetPanel;
import it.businesslogic.ireport.gui.sheet.ComboBoxSheetProperty;
import it.businesslogic.ireport.gui.sheet.FontSheetProperty;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.gui.style.JPanelStyleSample;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StyleDialog
extends JDialog
implements SheetPropertyValueChangedListener {
    private Style style = null;
    private Style masterStyle = null;
    private Style editingStyle = null;
    private boolean init = false;
    JPanelStyleSample panelSample = new JPanelStyleSample();
    private CategorySheetPanel sheetPanel = null;
    private IReportFont ireportFont = null;
    private Report currentReport = null;
    private JButton jButtonAddCondition;
    private JButton jButtonCancel;
    private JButton jButtonDownCondition;
    private JButton jButtonModifyCondition;
    private JButton jButtonOK;
    private JButton jButtonRemoveCondition;
    private JButton jButtonUpCondition;
    private JList jConditionsList;
    private JLabel jLabelSample;
    private JLabel jLabelStyleConditions;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelConditions;
    private JPanel jPanelProperties;
    private JPanel jPanelSample;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private int dialogResult;

    public StyleDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public StyleDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.style = new Style();
        this.setMasterStyle(this.style);
        this.pack();
        Misc.centerFrame(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, -1, -1, -1);
        this.sheetPanel = new CategorySheetPanel();
        this.sheetPanel.addSheetPropertyValueChangedListener(this);
        this.jPanelProperties.add((Component)this.sheetPanel, gridBagConstraints);
        SheetProperty customizerClassProperty = new SheetProperty("name", "Style name", 0);
        this.sheetPanel.addSheetProperty("Style", customizerClassProperty);
        SheetProperty isDefaultProperty = new SheetProperty("isDefault", "Default style", 4);
        this.sheetPanel.addSheetProperty("Style", isDefaultProperty);
        SheetProperty modeProperty = new SheetProperty("mode", "Mode", 2);
        modeProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Opaque", "Opaque"), new Tag("Transparent", "Transparent")});
        this.sheetPanel.addSheetProperty("Common", modeProperty);
        SheetProperty forecolorProperty = new SheetProperty("forecolor", "Forecolor", 3);
        forecolorProperty.setValue(null);
        this.sheetPanel.addSheetProperty("Common", forecolorProperty);
        SheetProperty backcolorProperty = new SheetProperty("backcolor", "Backcolor", 3);
        backcolorProperty.setValue(null);
        this.sheetPanel.addSheetProperty("Common", backcolorProperty);
        ComboBoxSheetProperty styleProperty = new ComboBoxSheetProperty("style", "Parent style");
        this.sheetPanel.addSheetProperty("Style", styleProperty);
        SheetProperty penProperty = new SheetProperty("pen", "Pen", 2);
        penProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Thin", "Thin"), new Tag("1Point", "1Point"), new Tag("2Point", "2Point"), new Tag("4Point", "4Point"), new Tag("Dotted", "Dotted")});
        this.sheetPanel.addSheetProperty("Common", penProperty);
        SheetProperty fillProperty = new SheetProperty("fill", "Fill", 2);
        fillProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Solid", "Solid")});
        this.sheetPanel.addSheetProperty("Common", fillProperty);
        SheetProperty radiusProperty = new SheetProperty("radius", "Radius", 6);
        this.sheetPanel.addSheetProperty("Graphics", radiusProperty);
        SheetProperty scaleImageProperty = new SheetProperty("scaleImage", "Scale image", 2);
        scaleImageProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Clip", "Clip"), new Tag("FillFrame", "FillFrame"), new Tag("RetainShape", "RetainShape")});
        this.sheetPanel.addSheetProperty("Graphics", scaleImageProperty);
        SheetProperty hAlignProperty = new SheetProperty("hAlign", "Horizontal align", 2);
        hAlignProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Left", "Left"), new Tag("Center", "Center"), new Tag("Right", "Right"), new Tag("Justified", "Justified")});
        this.sheetPanel.addSheetProperty("Graphics", hAlignProperty);
        SheetProperty vAlignProperty = new SheetProperty("vAlign", "Vertical align", 2);
        vAlignProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Top", "Top"), new Tag("Middle", "Middle"), new Tag("Bottom", "Bottom")});
        this.sheetPanel.addSheetProperty("Graphics", vAlignProperty);
        SheetProperty borderProperty = new SheetProperty("border", "Border", 2);
        borderProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Thin", "Thin"), new Tag("1Point", "1Point"), new Tag("2Point", "2Point"), new Tag("4Point", "4Point"), new Tag("Dotted", "Dotted")});
        this.sheetPanel.addSheetProperty("Border and padding", borderProperty);
        SheetProperty borderColorProperty = new SheetProperty("borderColor", "Border color", 3);
        this.sheetPanel.addSheetProperty("Border and padding", borderColorProperty);
        SheetProperty paddingProperty = new SheetProperty("padding", "Padding", 6);
        this.sheetPanel.addSheetProperty("Border and padding", paddingProperty);
        SheetProperty topBorderProperty = new SheetProperty("topBorder", "Top border", 2);
        topBorderProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Thin", "Thin"), new Tag("1Point", "1Point"), new Tag("2Point", "2Point"), new Tag("4Point", "4Point"), new Tag("Dotted", "Dotted")});
        this.sheetPanel.addSheetProperty("Border and padding", topBorderProperty);
        SheetProperty topBorderColorProperty = new SheetProperty("topBorderColor", "Top border color", 3);
        this.sheetPanel.addSheetProperty("Border and padding", topBorderColorProperty);
        SheetProperty topPaddingProperty = new SheetProperty("topPadding", "Top padding", 6);
        this.sheetPanel.addSheetProperty("Border and padding", topPaddingProperty);
        SheetProperty leftBorderProperty = new SheetProperty("leftBorder", "Left border", 2);
        leftBorderProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Thin", "Thin"), new Tag("1Point", "1Point"), new Tag("2Point", "2Point"), new Tag("4Point", "4Point"), new Tag("Dotted", "Dotted")});
        this.sheetPanel.addSheetProperty("Border and padding", leftBorderProperty);
        SheetProperty leftBorderColorProperty = new SheetProperty("leftBorderColor", "Left border color", 3);
        this.sheetPanel.addSheetProperty("Border and padding", leftBorderColorProperty);
        SheetProperty leftPaddingProperty = new SheetProperty("leftPadding", "Left padding", 6);
        this.sheetPanel.addSheetProperty("Border and padding", leftPaddingProperty);
        SheetProperty bottomBorderProperty = new SheetProperty("bottomBorder", "Bottom border", 2);
        bottomBorderProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Thin", "Thin"), new Tag("1Point", "1Point"), new Tag("2Point", "2Point"), new Tag("4Point", "4Point"), new Tag("Dotted", "Dotted")});
        this.sheetPanel.addSheetProperty("Border and padding", bottomBorderProperty);
        SheetProperty bottomBorderColorProperty = new SheetProperty("bottomBorderColor", "Bottom border color", 3);
        this.sheetPanel.addSheetProperty("Border and padding", bottomBorderColorProperty);
        SheetProperty bottomPaddingProperty = new SheetProperty("bottomPadding", "Bottom padding", 6);
        this.sheetPanel.addSheetProperty("Border and padding", bottomPaddingProperty);
        SheetProperty rightBorderProperty = new SheetProperty("rightBorder", "Right border", 2);
        rightBorderProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Thin", "Thin"), new Tag("1Point", "1Point"), new Tag("2Point", "2Point"), new Tag("4Point", "4Point"), new Tag("Dotted", "Dotted")});
        this.sheetPanel.addSheetProperty("Border and padding", rightBorderProperty);
        SheetProperty rightBorderColorProperty = new SheetProperty("rightBorderColor", "Right border color", 3);
        this.sheetPanel.addSheetProperty("Border and padding", rightBorderColorProperty);
        SheetProperty rightPaddingProperty = new SheetProperty("rightPadding", "Right padding", 6);
        this.sheetPanel.addSheetProperty("Border and padding", rightPaddingProperty);
        SheetProperty rotationProperty = new SheetProperty("rotation", "Rotation", 2);
        rotationProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("None", "None"), new Tag("Left", "Left"), new Tag("Right", "Right")});
        this.sheetPanel.addSheetProperty("Text properties", rotationProperty);
        SheetProperty patternProperty = new SheetProperty("pattern", "Pattern", 0);
        this.sheetPanel.addSheetProperty("Text properties", patternProperty);
        SheetProperty isBlankWhenNullProperty = new SheetProperty("isBlankWhenNull", "Is Blank when Null", 4);
        this.sheetPanel.addSheetProperty("Text properties", isBlankWhenNullProperty);
        FontSheetProperty theFontSpacingProperty = new FontSheetProperty("style.font", "Font");
        theFontSpacingProperty.setFontMode(3);
        this.sheetPanel.addSheetProperty("Text properties", theFontSpacingProperty);
        SheetProperty lineSpacingProperty = new SheetProperty("lineSpacing", "Line spacing", 2);
        lineSpacingProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Single", "Single"), new Tag("1_1_2", "1_1_2"), new Tag("Double", "Double")});
        this.sheetPanel.addSheetProperty("Text properties", lineSpacingProperty);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.jPanelSample.add((Component)this.panelSample, gridBagConstraints);
        SheetProperty isStyledTextProperty = new SheetProperty("isStyledText", "Is Styled Text", 4);
        this.sheetPanel.addSheetProperty("Text properties", isStyledTextProperty);
        this.sheetPanel.recreateSheet();
        this.sheetPanel.collapseCategory("Border and padding");
        this.updateStyleValues();
        this.jConditionsList.setModel(new DefaultListModel());
        this.jConditionsList.setSelectionMode(0);
        ((DefaultListModel)this.jConditionsList.getModel()).addElement("Default");
        this.jConditionsList.setSelectedIndex(0);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanelProperties = new JPanel();
        this.jPanelConditions = new JPanel();
        this.jLabelStyleConditions = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jConditionsList = new JList();
        this.jPanel2 = new JPanel();
        this.jButtonAddCondition = new JButton();
        this.jButtonModifyCondition = new JButton();
        this.jButtonRemoveCondition = new JButton();
        this.jButtonUpCondition = new JButton();
        this.jButtonDownCondition = new JButton();
        this.jLabelSample = new JLabel();
        this.jPanelSample = new JPanel();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify Style");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                StyleDialog.this.closeDialog(evt);
            }
        });
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanelProperties.setLayout(new GridBagLayout());
        this.jPanelProperties.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelProperties.setMinimumSize(new Dimension(100, 4));
        this.jPanelProperties.setPreferredSize(new Dimension(320, 470));
        this.jSplitPane1.setLeftComponent(this.jPanelProperties);
        this.jPanelConditions.setLayout(new GridBagLayout());
        this.jPanelConditions.setMinimumSize(new Dimension(100, 10));
        this.jPanelConditions.setPreferredSize(new Dimension(200, 10));
        this.jLabelStyleConditions.setText("Style conditions");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanelConditions.add((Component)this.jLabelStyleConditions, gridBagConstraints);
        this.jConditionsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                StyleDialog.this.jConditionsListValueChanged(evt);
            }
        });
        this.jConditionsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StyleDialog.this.jConditionsListMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jConditionsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelConditions.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jButtonAddCondition.setText("Add");
        this.jButtonAddCondition.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonAddCondition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonAddConditionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonAddCondition, gridBagConstraints);
        this.jButtonModifyCondition.setText("Modify");
        this.jButtonModifyCondition.setEnabled(false);
        this.jButtonModifyCondition.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonModifyCondition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonModifyConditionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonModifyCondition, gridBagConstraints);
        this.jButtonRemoveCondition.setText("Remove");
        this.jButtonRemoveCondition.setEnabled(false);
        this.jButtonRemoveCondition.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonRemoveCondition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonRemoveConditionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonRemoveCondition, gridBagConstraints);
        this.jButtonUpCondition.setText("up");
        this.jButtonUpCondition.setEnabled(false);
        this.jButtonUpCondition.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonUpCondition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonUpConditionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonUpCondition, gridBagConstraints);
        this.jButtonDownCondition.setText("Down");
        this.jButtonDownCondition.setEnabled(false);
        this.jButtonDownCondition.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonDownCondition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonDownConditionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonDownCondition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelConditions.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabelSample.setText("Sample");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelConditions.add((Component)this.jLabelSample, gridBagConstraints);
        this.jPanelSample.setLayout(new GridBagLayout());
        this.jPanelSample.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelSample.setMinimumSize(new Dimension(100, 80));
        this.jPanelSample.setPreferredSize(new Dimension(14, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelConditions.add((Component)this.jPanelSample, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanelConditions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jSplitPane1, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonDownConditionActionPerformed(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jConditionsList.getModel();
        this.setInit(true);
        int i = this.jConditionsList.getSelectedIndex();
        Object cs = this.jConditionsList.getSelectedValue();
        dlm.removeElementAt(i);
        dlm.insertElementAt(cs, i + 1);
        this.jConditionsList.setSelectedIndex(i + 1);
        this.jButtonUpCondition.setEnabled(true);
        if (i == dlm.size() - 2) {
            this.jButtonDownCondition.setEnabled(false);
        }
        this.setInit(false);
    }

    private void jButtonUpConditionActionPerformed(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jConditionsList.getModel();
        this.setInit(true);
        int i = this.jConditionsList.getSelectedIndex();
        Object cs = this.jConditionsList.getSelectedValue();
        dlm.removeElementAt(i);
        dlm.insertElementAt(cs, i - 1);
        this.jConditionsList.setSelectedIndex(i - 1);
        if (i == 2) {
            this.jButtonUpCondition.setEnabled(false);
        }
        this.jButtonDownCondition.setEnabled(true);
        this.setInit(false);
    }

    private void jButtonRemoveConditionActionPerformed(ActionEvent evt) {
        if (this.jConditionsList.getSelectedIndex() == 0) {
            return;
        }
        int i = this.jConditionsList.getSelectedIndex();
        this.jConditionsList.setSelectedIndex(i - 1);
        ((DefaultListModel)this.jConditionsList.getModel()).remove(i);
    }

    private void jButtonModifyConditionActionPerformed(ActionEvent evt) {
        String exp;
        if (this.jConditionsList.getSelectedIndex() == 0) {
            return;
        }
        ConditionedStyle s = (ConditionedStyle)this.jConditionsList.getSelectedValue();
        String expression = s.getCondition();
        ExpressionEditor ed = new ExpressionEditor();
        if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
            Report report = MainFrame.getMainInstance().getActiveReportFrame().getReport();
            ed.setSubDataset(report);
            Vector v = report.getElements();
            for (int i = 0; i < v.size(); ++i) {
                ReportElement re = (ReportElement)v.elementAt(i);
                if (!(re instanceof CrosstabReportElement)) continue;
                ed.addCrosstabReportElement((CrosstabReportElement)re);
            }
        } else {
            ed.setSubDataset(new SubDataset());
        }
        ed.setExpression(expression);
        ed.setVisible(true);
        if (ed.getDialogResult() == 0 && (exp = ed.getExpression()).trim().length() > 0) {
            s.setCondition(exp.trim());
            this.jConditionsList.updateUI();
        }
    }

    private void jConditionsListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                this.jButtonModifyConditionActionPerformed(null);
            }
        }
    }

    private void jButtonAddConditionActionPerformed(ActionEvent evt) {
        String exp;
        ExpressionEditor ed = new ExpressionEditor();
        if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
            Report report = MainFrame.getMainInstance().getActiveReportFrame().getReport();
            ed.setSubDataset(report);
            Vector v = report.getElements();
            for (int i = 0; i < v.size(); ++i) {
                ReportElement re = (ReportElement)v.elementAt(i);
                if (!(re instanceof CrosstabReportElement)) continue;
                ed.addCrosstabReportElement((CrosstabReportElement)re);
            }
        } else {
            ed.setSubDataset(new SubDataset());
        }
        ed.setVisible(true);
        if (ed.getDialogResult() == 0 && (exp = ed.getExpression()).trim().length() > 0) {
            this.saveCurrentStyle();
            ConditionedStyle s = new ConditionedStyle(this.getMasterStyle());
            s.setConditionedStyles(new Vector());
            s.setCondition(exp.trim());
            DefaultListModel dlm = (DefaultListModel)this.jConditionsList.getModel();
            dlm.addElement(s);
            this.jConditionsList.setSelectedValue(s, true);
        }
    }

    private void jConditionsListValueChanged(ListSelectionEvent evt) {
        if (this.isInit()) {
            return;
        }
        this.saveCurrentStyle();
        if (this.jConditionsList.getSelectedIndex() == 0) {
            this.jButtonModifyCondition.setEnabled(false);
            this.jButtonRemoveCondition.setEnabled(false);
            this.jButtonUpCondition.setEnabled(false);
            this.jButtonDownCondition.setEnabled(false);
            this.setStyle(this.getMasterStyle(), false);
        } else {
            this.jButtonModifyCondition.setEnabled(true);
            this.jButtonRemoveCondition.setEnabled(true);
            this.jButtonUpCondition.setEnabled(this.jConditionsList.getSelectedIndex() > 1);
            this.jButtonDownCondition.setEnabled(this.jConditionsList.getSelectedIndex() < ((DefaultListModel)this.jConditionsList.getModel()).size() - 1);
            this.setStyle((Style)this.jConditionsList.getSelectedValue(), true);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.saveCurrentStyle();
        String newName = this.getMasterStyle().getAttributeString("name", "");
        if (newName.trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Please insert a valid name for the style!", "Invalid name!", 2);
            this.jConditionsList.setSelectedIndex(0);
            return;
        }
        Enumeration e = MainFrame.getMainInstance().getActiveReportFrame().getReport().getStyles().elements();
        while (e.hasMoreElements()) {
            Style st = (Style)e.nextElement();
            if (!st.getAttributeString("name", "").equals(newName) || st == this.getEditingStyle()) continue;
            JOptionPane.showMessageDialog(this, "The name \"" + newName + "\" is already in use!\nPlease change it.", "Invalid name!", 2);
            return;
        }
        DefaultListModel dlm = (DefaultListModel)this.jConditionsList.getModel();
        Vector conditionedStyles = new Vector();
        for (int k = 1; k < dlm.size(); ++k) {
            conditionedStyles.add(dlm.getElementAt(k));
        }
        this.getMasterStyle().setConditionedStyles(conditionedStyles);
        String oldName = "";
        boolean newStyle = false;
        if (this.getEditingStyle() == null) {
            newStyle = true;
            this.setEditingStyle(this.getMasterStyle());
            MainFrame.getMainInstance().getActiveReportFrame().getReport().getStyles().add(this.getMasterStyle());
        } else {
            oldName = this.getEditingStyle().getAttributeString("name", "");
            this.getEditingStyle().copyStyleFrom(this.getMasterStyle());
        }
        MainFrame.getMainInstance().getActiveReportFrame().getReport().fireStyleChangedListenerStyleChanged(new StyleChangedEvent(MainFrame.getMainInstance().getActiveReportFrame().getReport(), newStyle ? 0 : 1, this.getEditingStyle(), this.getEditingStyle()));
        this.style = this.getEditingStyle();
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRParameterDialog((Frame)new JFrame(), true).show();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public CategorySheetPanel getSheetPanel() {
        return this.sheetPanel;
    }

    public void setSheetPanel(CategorySheetPanel sheetPanel) {
        this.sheetPanel = sheetPanel;
    }

    public void sheetPropertyValueChanged(SheetPropertyValueChangedEvent evt) {
        if (evt.getPropertyName() != null && evt.getPropertyName().equals("style.font")) {
            this.setIreportFont((IReportFont)evt.getNewValue());
        }
        if (!this.isInit() && this.panelSample != null && this.panelSample.getStyle() != null) {
            Vector properties = this.sheetPanel.getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                SheetProperty sp = (SheetProperty)properties.get(i);
                if (sp.getValue() == null) continue;
                this.panelSample.getStyle().getAttributes().put(sp.getKeyName(), sp.getValue());
            }
            this.panelSample.repaint();
        }
    }

    public Style getStyle() {
        return this.style;
    }

    public void updateStyleValues() {
        this.setInit(true);
        this.sheetPanel.setPropertyValue("name", this.getStyle().getAttribute("name"));
        this.sheetPanel.setPropertyValue("backcolor", this.getStyle().getAttribute("backcolor"));
        this.sheetPanel.setPropertyValue("borderColor", this.getStyle().getAttribute("borderColor"));
        this.sheetPanel.setPropertyValue("border", this.getStyle().getAttribute("border"));
        this.sheetPanel.setPropertyValue("bottomBorderColor", this.getStyle().getAttribute("bottomBorderColor"));
        this.sheetPanel.setPropertyValue("bottomBorder", this.getStyle().getAttribute("bottomBorder"));
        this.sheetPanel.setPropertyValue("bottomPadding", this.getStyle().getAttribute("bottomPadding"));
        this.sheetPanel.setPropertyValue("fill", this.getStyle().getAttribute("fill"));
        this.sheetPanel.setPropertyValue("forecolor", this.getStyle().getAttribute("forecolor"));
        this.sheetPanel.setPropertyValue("hAlign", this.getStyle().getAttribute("hAlign"));
        this.sheetPanel.setPropertyValue("isBlankWhenNull", this.getStyle().getAttribute("isBlankWhenNull"));
        this.sheetPanel.setPropertyValue("isDefault", this.getStyle().getAttribute("isDefault"));
        this.sheetPanel.setPropertyValue("leftBorderColor", this.getStyle().getAttribute("leftBorderColor"));
        this.sheetPanel.setPropertyValue("leftBorder", this.getStyle().getAttribute("leftBorder"));
        this.sheetPanel.setPropertyValue("leftPadding", this.getStyle().getAttribute("leftPadding"));
        this.sheetPanel.setPropertyValue("lineSpacing", this.getStyle().getAttribute("lineSpacing"));
        this.sheetPanel.setPropertyValue("mode", this.getStyle().getAttribute("mode"));
        this.sheetPanel.setPropertyValue("padding", this.getStyle().getAttribute("padding"));
        this.sheetPanel.setPropertyValue("pattern", this.getStyle().getAttribute("pattern"));
        this.sheetPanel.setPropertyValue("pen", this.getStyle().getAttribute("pen"));
        this.sheetPanel.setPropertyValue("radius", this.getStyle().getAttribute("radius"));
        this.sheetPanel.setPropertyValue("rightBorderColor", this.getStyle().getAttribute("rightBorderColor"));
        this.sheetPanel.setPropertyValue("rightBorder", this.getStyle().getAttribute("rightBorder"));
        this.sheetPanel.setPropertyValue("rightPadding", this.getStyle().getAttribute("rightPadding"));
        this.sheetPanel.setPropertyValue("rotation", this.getStyle().getAttribute("rotation"));
        this.sheetPanel.setPropertyValue("scaleImage", this.getStyle().getAttribute("scaleImage"));
        this.sheetPanel.setPropertyValue("style", this.getStyle().getAttribute("style"));
        this.sheetPanel.setPropertyValue("isStyledText", this.getStyle().getAttribute("isStyledText"));
        this.sheetPanel.setPropertyValue("style.font", this.getIreportFont());
        this.sheetPanel.setPropertyValue("topBorderColor", this.getStyle().getAttribute("topBorderColor"));
        this.sheetPanel.setPropertyValue("topBorder", this.getStyle().getAttribute("topBorder"));
        this.sheetPanel.setPropertyValue("topPadding", this.getStyle().getAttribute("topPadding"));
        this.sheetPanel.setPropertyValue("vAlign", this.getStyle().getAttribute("vAlign"));
        this.setInit(false);
    }

    public void setStyle(Style myStyle) {
        this.setMasterStyle(new Style(myStyle));
        if (myStyle.getAttributeBoolean("isDefault", false)) {
            this.getMasterStyle().getAttributes().put("isDefault", new Boolean(true));
        }
        this.setStyle(this.getMasterStyle(), false);
        this.setEditingStyle(myStyle);
        this.setInit(true);
        ((DefaultListModel)this.jConditionsList.getModel()).removeAllElements();
        ((DefaultListModel)this.jConditionsList.getModel()).addElement("Default");
        for (int i = 0; i < this.getMasterStyle().getConditionedStyles().size(); ++i) {
            ((DefaultListModel)this.jConditionsList.getModel()).addElement(this.getMasterStyle().getConditionedStyles().elementAt(i));
        }
        this.jConditionsList.setSelectedIndex(0);
        this.setInit(false);
    }

    private void setStyle(Style myStyle, boolean conditionalStyle) {
        this.style = myStyle;
        ((SheetProperty)this.sheetPanel.getSheetProperty("name")).setReadOnly(conditionalStyle);
        ((SheetProperty)this.sheetPanel.getSheetProperty("isDefault")).setReadOnly(conditionalStyle);
        ((SheetProperty)this.sheetPanel.getSheetProperty("style")).setReadOnly(conditionalStyle);
        if (MainFrame.getMainInstance().getActiveReportFrame() != null && this.currentReport != MainFrame.getMainInstance().getActiveReportFrame().getReport()) {
            this.currentReport = MainFrame.getMainInstance().getActiveReportFrame().getReport();
            Enumeration enum_styles = this.currentReport.getStyles().elements();
            Vector<Style> tags = new Vector<Style>();
            while (enum_styles.hasMoreElements()) {
                Style s = (Style)enum_styles.nextElement();
                if (s == myStyle) continue;
                tags.add(s);
            }
            ComboBoxSheetProperty sp = (ComboBoxSheetProperty)this.getSheetPanel().getSheetProperty("style");
            sp.updateValues(tags, true);
        }
        this.setIreportFont(new IReportFont());
        this.getIreportFont().setBold(myStyle.getAttributeBoolean("isBold", false));
        this.getIreportFont().setFontName(myStyle.getAttributeString("fontName", this.getIreportFont().getFontName()));
        System.out.println("Setting font: '" + myStyle.getAttribute("fontSize") + "' " + myStyle.getAttributeInteger("fontSize", this.getIreportFont().getFontSize()));
        this.getIreportFont().setFontSize(myStyle.getAttributeInteger("fontSize", this.getIreportFont().getFontSize()));
        this.getIreportFont().setItalic(myStyle.getAttributeBoolean("isItalic", false));
        this.getIreportFont().setPdfEmbedded(myStyle.getAttributeBoolean("isPdfEmbedded", false));
        this.getIreportFont().setPdfEncoding(myStyle.getAttributeString("pdfEncoding", this.getIreportFont().getPdfEncoding()));
        this.getIreportFont().setStrikeTrought(myStyle.getAttributeBoolean("isStrikeThrough", false));
        this.getIreportFont().setPDFFontName(myStyle.getAttributeString("pdfFontName", this.getIreportFont().getPDFFontName()));
        this.getIreportFont().setUnderline(myStyle.getAttributeBoolean("isUnderline", false));
        this.updateStyleValues();
        this.panelSample.setStyle(myStyle);
    }

    public IReportFont getIreportFont() {
        return this.ireportFont;
    }

    public void setIreportFont(IReportFont ireportFont) {
        this.ireportFont = ireportFont;
    }

    private Style getMasterStyle() {
        return this.masterStyle;
    }

    private void setMasterStyle(Style masterStyle) {
        this.masterStyle = masterStyle;
    }

    private void saveCurrentStyle() {
        Vector properties = this.sheetPanel.getProperties();
        if (this.getStyle() instanceof ConditionedStyle) {
            String condition = ((ConditionedStyle)this.getStyle()).getCondition();
            this.getStyle().getAttributes().clear();
            ((ConditionedStyle)this.getStyle()).setCondition(condition);
        } else {
            this.getStyle().getAttributes().clear();
        }
        for (int i = 0; i < properties.size(); ++i) {
            SheetProperty sp = (SheetProperty)properties.get(i);
            if (sp.getValue() == null) continue;
            this.getStyle().getAttributes().put(sp.getKeyName(), sp.getValue());
        }
        HashMap hashMap = this.getStyle().getAttributes();
        this.getStyle();
        if (hashMap.get("style") != null) {
            HashMap hashMap2 = this.getStyle().getAttributes();
            this.getStyle();
            if (!(hashMap2.get("style") instanceof Style)) {
                StringBuffer stringBuffer = new StringBuffer().append("");
                HashMap hashMap3 = this.getStyle().getAttributes();
                this.getStyle();
                String sname = stringBuffer.append(hashMap3.get("style")).toString();
                for (int j = 0; j < this.currentReport.getStyles().size(); ++j) {
                    Style sparent = (Style)this.currentReport.getStyles().elementAt(j);
                    if (!sparent.getName().equals(sname)) continue;
                    HashMap hashMap4 = this.getStyle().getAttributes();
                    this.getStyle();
                    hashMap4.put("style", sparent);
                }
            }
        }
        Style style = this.getStyle();
        this.getStyle();
        if (style.getAttributeBoolean("isDefault", false)) {
            Enumeration enum_s = MainFrame.getMainInstance().getActiveReportFrame().getReport().getStyles().elements();
            while (enum_s.hasMoreElements()) {
                Style tmp_s = (Style)enum_s.nextElement();
                if (tmp_s == this.getStyle()) continue;
                HashMap hashMap5 = tmp_s.getAttributes();
                this.getStyle();
                hashMap5.remove("isDefault");
            }
        }
        if (this.ireportFont != null) {
            this.getStyle().getAttributes().put("fontName", this.ireportFont.getFontName());
            this.getStyle().getAttributes().put("fontSize", new Integer(this.ireportFont.getFontSize()));
            this.getStyle().getAttributes().put("isBold", new Boolean(this.ireportFont.isBold()));
            this.getStyle().getAttributes().put("isItalic", new Boolean(this.ireportFont.isItalic()));
            this.getStyle().getAttributes().put("isUnderline", new Boolean(this.ireportFont.isUnderline()));
            this.getStyle().getAttributes().put("isStrikeThrough", new Boolean(this.ireportFont.isStrikeTrought()));
            this.getStyle().getAttributes().put("isPdfEmbedded", new Boolean(this.ireportFont.isPdfEmbedded()));
            this.getStyle().getAttributes().put("pdfFontName", this.ireportFont.getPDFFontName());
        }
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public Style getEditingStyle() {
        return this.editingStyle;
    }

    public void setEditingStyle(Style editingStyle) {
        this.editingStyle = editingStyle;
    }
}

