/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.wizard;

import it.businesslogic.ireport.gui.wizard.GenericWizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class BaseWizardPanel
extends JPanel {
    private int currentStep = -1;
    private GenericWizard genericWizard = null;
    private int dialogResult = -1;
    private JButton jButtonCancel;
    private JButton jButtonFinish;
    private JButton jButtonNext;
    private JButton jButtonPrev;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JLabel jLabelStep1;
    private JLabel jLabelStepDescription;
    private JPanel jPanel2;
    private JPanel jPanelContent;
    private JPanel jPanelContentButtons;
    private JPanel jPanelLabels;
    private JPanel jPanelStepContainer;
    private JPanel jPanelSteps;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;

    public BaseWizardPanel() {
        this.initComponents();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public GenericWizard getGenericWizard() {
        return this.genericWizard;
    }

    public void setGenericWizard(GenericWizard genericWizard) {
        this.genericWizard = genericWizard;
        genericWizard.initWizard();
        this.setCurrentStep(-1);
        this.dialogResult = -1;
        String[] stepsNames = genericWizard.getStepsNames();
        this.jPanelLabels.removeAll();
        for (int i = 0; i < stepsNames.length; ++i) {
            JLabel jLabelStep = new JLabel();
            jLabelStep.setFont(new Font(jLabelStep.getFont().getName(), 0, jLabelStep.getFont().getSize()));
            jLabelStep.setText(stepsNames[i]);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 8, 0, 0);
            this.jPanelLabels.add((Component)jLabelStep, gridBagConstraints);
        }
        this.goNext();
    }

    public void goNext() {
        if (this.getGenericWizard().nextStep(this.getCurrentStep() + 1)) {
            this.setCurrentStep(this.getCurrentStep() + 1);
            this.setCurrentStepLabel(this.getGenericWizard().getStepDescription(this.getCurrentStep()));
            this.jPanelStepContainer.removeAll();
            this.jPanelStepContainer.add((Component)this.getGenericWizard().getStepPanel(this.getCurrentStep()), "Center");
            this.jPanelStepContainer.updateUI();
            this.updateButtons();
        }
    }

    public void goStep(int x) {
        this.setCurrentStep(x);
        this.setCurrentStepLabel(this.getGenericWizard().getStepDescription(this.getCurrentStep()));
        this.jPanelStepContainer.removeAll();
        this.jPanelStepContainer.add((Component)this.getGenericWizard().getStepPanel(this.getCurrentStep()), "Center");
        this.jPanelStepContainer.updateUI();
        this.updateButtons();
    }

    public void goPrevious() {
        if (this.getCurrentStep() > 0 && this.getGenericWizard().previousStep(this.getCurrentStep() - 1)) {
            this.setCurrentStep(this.getCurrentStep() - 1);
            this.setCurrentStepLabel(this.getGenericWizard().getStepDescription(this.getCurrentStep()));
            this.jPanelStepContainer.removeAll();
            this.jPanelStepContainer.add((Component)this.getGenericWizard().getStepPanel(this.getCurrentStep()), "Center");
            this.jPanelStepContainer.updateUI();
            this.updateButtons();
        }
    }

    public void updateButtons() {
        this.getJButtonFinish().setEnabled(this.getGenericWizard().canFinish(this.getCurrentStep()));
        this.getJButtonPrev().setEnabled(this.getGenericWizard().canPrevious(this.getCurrentStep()));
        this.getJButtonNext().setEnabled(this.getGenericWizard().canNext(this.getCurrentStep()));
    }

    private void setCurrentStepLabel(String label) {
        this.jLabelStepDescription.setText(label);
        for (int i = 0; i < this.jPanelLabels.getComponentCount(); ++i) {
            if (!(this.jPanelLabels.getComponent(i) instanceof JLabel)) continue;
            JLabel jLabel = (JLabel)this.jPanelLabels.getComponent(i);
            jLabel.setFont(new Font(jLabel.getFont().getName(), i == this.getCurrentStep() ? 1 : 0, jLabel.getFont().getSize()));
            jLabel.updateUI();
        }
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
    }

    public JButton getJButtonCancel() {
        return this.jButtonCancel;
    }

    public void setJButtonCancel(JButton jButtonCancel) {
        this.jButtonCancel = jButtonCancel;
    }

    public JButton getJButtonFinish() {
        return this.jButtonFinish;
    }

    public void setJButtonFinish(JButton jButtonFinish) {
        this.jButtonFinish = jButtonFinish;
    }

    public JButton getJButtonNext() {
        return this.jButtonNext;
    }

    public void setJButtonNext(JButton jButtonNext) {
        this.jButtonNext = jButtonNext;
    }

    public JButton getJButtonPrev() {
        return this.jButtonPrev;
    }

    public void setJButtonPrev(JButton jButtonPrev) {
        this.jButtonPrev = jButtonPrev;
    }

    private void initComponents() {
        this.jPanelSteps = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jPanelLabels = new JPanel();
        this.jLabelStep1 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jPanelContent = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabelStepDescription = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.jPanelStepContainer = new JPanel();
        this.jSeparator3 = new JSeparator();
        this.jPanelContentButtons = new JPanel();
        this.jButtonPrev = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonFinish = new JButton();
        this.jButtonCancel = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanelSteps.setLayout(new GridBagLayout());
        this.jPanelSteps.setBackground(new Color(207, 217, 231));
        this.jPanelSteps.setPreferredSize(new Dimension(150, 280));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Steps");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.jPanelSteps.add((Component)this.jLabel1, gridBagConstraints);
        this.jSeparator2.setBackground(new Color(204, 204, 255));
        this.jSeparator2.setForeground(new Color(0, 0, 0));
        this.jSeparator2.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        this.jSeparator2.setMinimumSize(new Dimension(2, 2));
        this.jSeparator2.setPreferredSize(new Dimension(1, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanelSteps.add((Component)this.jSeparator2, gridBagConstraints);
        this.jPanelLabels.setLayout(new GridBagLayout());
        this.jPanelLabels.setOpaque(false);
        this.jLabelStep1.setFont(new Font("Tahoma", 1, 11));
        this.jLabelStep1.setText("1. SubDataset selection");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanelLabels.add((Component)this.jLabelStep1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        this.jPanelSteps.add((Component)this.jPanelLabels, gridBagConstraints);
        this.jLabel7.setBackground(new Color(207, 217, 231));
        this.jLabel7.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/wizard.jpg")));
        this.jLabel7.setVerticalAlignment(1);
        this.jLabel7.setOpaque(true);
        this.jLabel7.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 20;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelSteps.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanelSteps, gridBagConstraints);
        this.jPanelContent.setLayout(new GridBagLayout());
        this.jPanelContent.setMinimumSize(new Dimension(40, 40));
        this.jPanelContent.setPreferredSize(new Dimension(380, 40));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(380, 40));
        this.jPanel2.setPreferredSize(new Dimension(380, 40));
        this.jLabelStepDescription.setFont(new Font("Tahoma", 1, 11));
        this.jLabelStepDescription.setText("Step description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 8, 0, 0);
        this.jPanel2.add((Component)this.jLabelStepDescription, gridBagConstraints);
        this.jSeparator4.setBackground(new Color(204, 204, 255));
        this.jSeparator4.setForeground(new Color(0, 0, 0));
        this.jSeparator4.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        this.jSeparator4.setMinimumSize(new Dimension(2, 2));
        this.jSeparator4.setPreferredSize(new Dimension(1, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jSeparator4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelContent.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanelStepContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanelContent.add((Component)this.jPanelStepContainer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanelContent, gridBagConstraints);
        this.jSeparator3.setBackground(new Color(204, 204, 255));
        this.jSeparator3.setForeground(new Color(0, 0, 0));
        this.jSeparator3.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        this.jSeparator3.setMinimumSize(new Dimension(2, 2));
        this.jSeparator3.setPreferredSize(new Dimension(1, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jSeparator3, gridBagConstraints);
        this.jPanelContentButtons.setLayout(new GridBagLayout());
        this.jButtonPrev.setText("< Prev");
        this.jButtonPrev.setEnabled(false);
        this.jButtonPrev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BaseWizardPanel.this.jButtonPrevActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 2, 8, 2);
        this.jPanelContentButtons.add((Component)this.jButtonPrev, gridBagConstraints);
        this.jButtonNext.setText("Next >");
        this.jButtonNext.setEnabled(false);
        this.jButtonNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BaseWizardPanel.this.jButtonNextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 2, 8, 2);
        this.jPanelContentButtons.add((Component)this.jButtonNext, gridBagConstraints);
        this.jButtonFinish.setText("Finish");
        this.jButtonFinish.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BaseWizardPanel.this.jButtonFinishActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 2, 8, 2);
        this.jPanelContentButtons.add((Component)this.jButtonFinish, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BaseWizardPanel.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 2, 8, 4);
        this.jPanelContentButtons.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanelContentButtons, gridBagConstraints);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setDialogResult(-1);
        this.getGenericWizard().finish(-1);
    }

    private void jButtonFinishActionPerformed(ActionEvent evt) {
        this.setDialogResult(0);
        this.getGenericWizard().finish(this.getCurrentStep());
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        this.goNext();
    }

    private void jButtonPrevActionPerformed(ActionEvent evt) {
        this.goPrevious();
    }
}

