/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.TonicUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuBarUI;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class MenuBarUI
extends BasicMenuBarUI {
    protected JMenuBar menuBar = null;
    protected ContainerListener containerListener;
    protected ChangeListener changeListener;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent x) {
        return new MenuBarUI();
    }

    public void installUI(JComponent c) {
        this.menuBar = (JMenuBar)c;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        if (this.menuBar.getLayout() == null || this.menuBar.getLayout() instanceof UIResource) {
            if (TonicUtils.isLeftToRight(this.menuBar)) {
                this.menuBar.setLayout(new DefaultMenuLayout(this.menuBar, 0));
            } else {
                this.menuBar.setLayout(new RightToLeftMenuLayout());
            }
        }
        this.menuBar.setOpaque(true);
        LookAndFeel.installBorder(this.menuBar, "MenuBar.border");
        LookAndFeel.installColorsAndFont(this.menuBar, "MenuBar.background", "MenuBar.foreground", "MenuBar.font");
    }

    protected void installListeners() {
        this.containerListener = this.createContainerListener();
        this.changeListener = this.createChangeListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        int i = 0;
        while (i < this.menuBar.getMenuCount()) {
            JMenu menu = this.menuBar.getMenu(i);
            if (menu != null) {
                menu.getModel().addChangeListener(this.changeListener);
            }
            ++i;
        }
        this.menuBar.addContainerListener(this.containerListener);
        this.menuBar.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getMyInputMap(2);
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, inputMap);
        ActionMap actionMap = this.getMyActionMap();
        SwingUtilities.replaceUIActionMap(this.menuBar, actionMap);
    }

    public InputMap getMyInputMap(int condition) {
        Object[] bindings;
        if (condition == 2 && (bindings = (Object[])UIManager.get("MenuBar.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.menuBar, bindings);
        }
        return null;
    }

    ActionMap getMyActionMap() {
        ActionMap map = (ActionMap)UIManager.get("MenuBar.actionMap");
        if (map == null && (map = this.createMyActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("MenuBar.actionMap", map);
        }
        return map;
    }

    ActionMap createMyActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("takeFocus", new TakeFocus());
        return map;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.menuBar = null;
    }

    protected void uninstallDefaults() {
        if (this.menuBar != null) {
            LookAndFeel.uninstallBorder(this.menuBar);
        }
    }

    protected void uninstallListeners() {
        this.menuBar.removeContainerListener(this.containerListener);
        this.menuBar.removePropertyChangeListener(this.propertyChangeListener);
        int i = 0;
        while (i < this.menuBar.getMenuCount()) {
            JMenu menu = this.menuBar.getMenu(i);
            if (menu != null) {
                menu.getModel().removeChangeListener(this.changeListener);
            }
            ++i;
        }
        this.containerListener = null;
        this.changeListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, null);
        SwingUtilities.replaceUIActionMap(this.menuBar, null);
    }

    protected ContainerListener createContainerListener() {
        return new ContainerHandler();
    }

    protected ChangeListener createChangeListener() {
        return new ChangeHandler();
    }

    private PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    private class ChangeHandler
    implements ChangeListener {
        ChangeHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            int i = 0;
            int c = MenuBarUI.this.menuBar.getMenuCount();
            while (i < c) {
                JMenu menu = MenuBarUI.this.menuBar.getMenu(i);
                if (menu != null && menu.isSelected()) {
                    MenuBarUI.this.menuBar.getSelectionModel().setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("componentOrientation") && MenuBarUI.this.menuBar.getLayout() instanceof UIResource) {
                if (TonicUtils.isLeftToRight(MenuBarUI.this.menuBar)) {
                    MenuBarUI.this.menuBar.setLayout(new DefaultMenuLayout(MenuBarUI.this.menuBar, 0));
                } else {
                    MenuBarUI.this.menuBar.setLayout(new RightToLeftMenuLayout());
                }
            }
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        ContainerHandler() {
        }

        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            if (c instanceof JMenu) {
                ((JMenu)c).getModel().addChangeListener(MenuBarUI.this.changeListener);
            }
        }

        public void componentRemoved(ContainerEvent e) {
            Component c = e.getChild();
            if (c instanceof JMenu) {
                ((JMenu)c).getModel().removeChangeListener(MenuBarUI.this.changeListener);
            }
        }
    }

    private static class TakeFocus
    extends AbstractAction {
        TakeFocus() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuBar menuBar = (JMenuBar)e.getSource();
            MenuSelectionManager defaultManager = MenuSelectionManager.defaultManager();
            JMenu menu = menuBar.getMenu(0);
            if (menu != null) {
                MenuElement[] me = new MenuElement[]{menuBar, menu, menu.getPopupMenu()};
                defaultManager.setSelectedPath(me);
            }
        }
    }

    private static class RightToLeftMenuLayout
    extends FlowLayout
    implements UIResource {
        RightToLeftMenuLayout() {
            super(3, 0, 0);
        }
    }
}

