/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.DrawRoutines;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class TinyProgressBarBorder
extends AbstractBorder
implements UIResource {
    protected static final Insets INSETS_YQ = new Insets(3, 3, 3, 3);
    protected static final Insets INSETS_99 = new Insets(2, 2, 2, 2);

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyBorder(c, g, x, y, w, h);
                break;
            }
            case 1: {
                this.drawWinBorder(c, g, x, y, w, h);
                break;
            }
            case 2: {
                this.drawXpBorder(c, g, x, y, w, h);
            }
        }
    }

    private void drawTinyBorder(Component c, Graphics g, int x, int y, int w, int h) {
    }

    private void drawWinBorder(Component c, Graphics g, int x, int y, int w, int h) {
        g.setColor(Theme.progressDarkColor[Theme.style].getColor());
        g.drawLine(x, y, x + w - 1, y);
        g.drawLine(x, 1, x, y + h - 1);
        g.setColor(Theme.progressLightColor[Theme.style].getColor());
        g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
        g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
    }

    private void drawXpBorder(Component c, Graphics g, int x, int y, int w, int h) {
        DrawRoutines.drawProgressBarBorder(g, Theme.progressBorderColor[Theme.style].getColor(), x, y, w, h);
        DrawRoutines.drawProgressBarBorder(g, Theme.progressDarkColor[Theme.style].getColor(), x + 1, y + 1, w - 2, h - 2);
        g.setColor(Theme.progressLightColor[Theme.style].getColor());
        g.drawLine((x += 2) + 1, y += 2, x + (w -= 4) - 2, y);
        g.drawLine(x, y + 1, x, y + (h -= 4) - 2);
        g.setColor(Theme.progressTrackColor[Theme.style].getColor());
        g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
        g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
    }

    public Insets getBorderInsets(Component c) {
        if (Theme.derivedStyle[Theme.style] == 2) {
            return INSETS_YQ;
        }
        return INSETS_99;
    }
}

