/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.ResultSetIterator;

public class ResultSetDynaClass
implements DynaClass {
    protected DynaProperty[] properties = null;
    protected HashMap propertiesMap = new HashMap();
    protected ResultSet resultSet = null;
    static /* synthetic */ Class class$java$lang$Object;

    public ResultSetDynaClass(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new NullPointerException();
        }
        this.resultSet = resultSet;
        this.introspect();
    }

    public String getName() {
        return this.getClass().getName();
    }

    public DynaProperty getDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return (DynaProperty)this.propertiesMap.get(name);
    }

    public DynaProperty[] getDynaProperties() {
        return this.properties;
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        throw new UnsupportedOperationException("newInstance() not supported");
    }

    public Iterator iterator() {
        return new ResultSetIterator(this);
    }

    ResultSet getResultSet() {
        return this.resultSet;
    }

    protected void introspect() throws SQLException {
        ArrayList<DynaProperty> list = new ArrayList<DynaProperty>();
        ResultSetMetaData metadata = this.resultSet.getMetaData();
        int n = metadata.getColumnCount();
        int i = 1;
        while (i <= n) {
            DynaProperty dynaProperty = this.createDynaProperty(metadata, i);
            if (dynaProperty != null) {
                list.add(dynaProperty);
            }
            ++i;
        }
        this.properties = list.toArray(new DynaProperty[list.size()]);
        int i2 = 0;
        while (i2 < this.properties.length) {
            this.propertiesMap.put(this.properties[i2].getName(), this.properties[i2]);
            ++i2;
        }
    }

    protected DynaProperty createDynaProperty(ResultSetMetaData metadata, int i) throws SQLException {
        Class clazz;
        String name = metadata.getColumnName(i).toLowerCase();
        String className = null;
        try {
            className = metadata.getColumnClassName(i);
        }
        catch (SQLException e) {
            // empty catch block
        }
        Class clazz2 = clazz = class$java$lang$Object == null ? (class$java$lang$Object = ResultSetDynaClass.class$("java.lang.Object")) : class$java$lang$Object;
        if (className != null) {
            clazz = this.loadClass(className);
        }
        return new DynaProperty(name, clazz);
    }

    protected Class loadClass(String className) throws SQLException {
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (Exception e) {
            throw new SQLException("Cannot load column class '" + className + "': " + e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

