/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.chart.CategorySeriesDialog;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class TimePeriodSeriesDialog
extends JDialog {
    private String seriesExpression = "";
    private String startDateExpression = "";
    private String endDateExpression = "";
    private String valueExpression = "";
    private String labelExpression = "";
    private int dialogResult = 2;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabelEndDateExpression;
    private JLabel jLabelLabelExpression;
    private JLabel jLabelSeriesExpression;
    private JLabel jLabelStartDateExpression;
    private JLabel jLabelValueExpression;
    private JPanel jPanel1;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JRTextExpressionArea jRTextExpressionEndDate;
    private JRTextExpressionArea jRTextExpressionLabel;
    private JRTextExpressionArea jRTextExpressionSeries;
    private JRTextExpressionArea jRTextExpressionStartDate;
    private JRTextExpressionArea jRTextExpressionValue;

    public TimePeriodSeriesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        this.setSize(500, 500);
        Misc.centerFrame(this);
    }

    public void setSubDataset(SubDataset sds) {
        this.jRTextExpressionEndDate.setSubDataset(sds);
        this.jRTextExpressionLabel.setSubDataset(sds);
        this.jRTextExpressionSeries.setSubDataset(sds);
        this.jRTextExpressionStartDate.setSubDataset(sds);
        this.jRTextExpressionValue.setSubDataset(sds);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabelSeriesExpression = new JLabel();
        this.jLabelStartDateExpression = new JLabel();
        this.jLabelEndDateExpression = new JLabel();
        this.jLabelValueExpression = new JLabel();
        this.jLabelLabelExpression = new JLabel();
        this.jRTextExpressionSeries = new JRTextExpressionArea();
        this.jRTextExpressionStartDate = new JRTextExpressionArea();
        this.jRTextExpressionEndDate = new JRTextExpressionArea();
        this.jRTextExpressionValue = new JRTextExpressionArea();
        this.jRTextExpressionLabel = new JRTextExpressionArea();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("Time period series");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelSeriesExpression.setText("Series expression (required)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabelSeriesExpression, gridBagConstraints);
        this.jLabelStartDateExpression.setText("Start date expression (required)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelStartDateExpression, gridBagConstraints);
        this.jLabelEndDateExpression.setText("Start date expression (required)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelEndDateExpression, gridBagConstraints);
        this.jLabelValueExpression.setText("Value expression (required)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelValueExpression, gridBagConstraints);
        this.jLabelLabelExpression.setText("Label expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelLabelExpression, gridBagConstraints);
        this.jRTextExpressionSeries.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionSeries.setElectricScroll(0);
        this.jRTextExpressionSeries.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionSeries.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionSeries, gridBagConstraints);
        this.jRTextExpressionStartDate.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionStartDate.setElectricScroll(0);
        this.jRTextExpressionStartDate.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionStartDate.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionStartDate, gridBagConstraints);
        this.jRTextExpressionEndDate.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionEndDate.setElectricScroll(0);
        this.jRTextExpressionEndDate.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionEndDate.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionEndDate, gridBagConstraints);
        this.jRTextExpressionValue.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionValue.setElectricScroll(0);
        this.jRTextExpressionValue.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionValue.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionValue, gridBagConstraints);
        this.jRTextExpressionLabel.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionLabel.setElectricScroll(0);
        this.jRTextExpressionLabel.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionLabel.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jPanel7, gridBagConstraints);
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimePeriodSeriesDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimePeriodSeriesDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel6.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel6, gridBagConstraints);
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.seriesExpression = this.jRTextExpressionSeries.getText();
        this.setStartDateExpression(this.jRTextExpressionStartDate.getText());
        this.setEndDateExpression(this.jRTextExpressionEndDate.getText());
        this.valueExpression = this.jRTextExpressionValue.getText();
        this.labelExpression = this.jRTextExpressionLabel.getText();
        MessageFormat formatter = new MessageFormat(I18n.getString("gui.notvalidexp", "{0} cannot be blank!"));
        if (this.seriesExpression.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, formatter.format(new Object[]{I18n.getString("charts.seriesExpression", "Series expression")}), "Invalid expression", 0);
            return;
        }
        if (this.getStartDateExpression().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, formatter.format(new Object[]{I18n.getString("charts.startDateExpression", "Start date expression")}), "Invalid expression", 0);
            return;
        }
        if (this.getEndDateExpression().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, formatter.format(new Object[]{I18n.getString("charts.endDateExpression", "End date expression")}), "Invalid expression", 0);
            return;
        }
        if (this.valueExpression.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, formatter.format(new Object[]{I18n.getString("charts.valueExpression", "Value expression")}), "Invalid expression", 0);
            return;
        }
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new CategorySeriesDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public String getSeriesExpression() {
        return this.seriesExpression;
    }

    public void setSeriesExpression(String seriesExpression) {
        this.seriesExpression = seriesExpression;
        this.jRTextExpressionSeries.setText(seriesExpression);
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
        this.jRTextExpressionValue.setText(valueExpression);
    }

    public String getLabelExpression() {
        return this.labelExpression;
    }

    public void setLabelExpression(String labelExpression) {
        this.labelExpression = labelExpression;
        this.jRTextExpressionLabel.setText(labelExpression);
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
        this.jButtonOK.setText(I18n.getString("ok", "Ok"));
        this.jButtonCancel.setText(I18n.getString("cancel", "Cancel"));
        this.jLabelStartDateExpression.setText(I18n.getString("charts.startDateExpression", "Start date expression"));
        this.jLabelEndDateExpression.setText(I18n.getString("charts.endDateExpression", "End date expression"));
        this.jLabelSeriesExpression.setText(I18n.getString("charts.seriesExpression", "Series expression"));
        this.jLabelValueExpression.setText(I18n.getString("charts.valueExpression", "Value expression"));
        this.jLabelLabelExpression.setText(I18n.getString("charts.labelExpression", "Label expression"));
        this.setTitle(I18n.getString("gui.ChartPropertiesDialog.title", "Chart properties"));
        this.getRootPane().updateUI();
    }

    public String getStartDateExpression() {
        return this.startDateExpression;
    }

    public void setStartDateExpression(String startDateExpression) {
        this.startDateExpression = startDateExpression;
        this.jRTextExpressionStartDate.setText(startDateExpression);
    }

    public String getEndDateExpression() {
        return this.endDateExpression;
    }

    public void setEndDateExpression(String endDateExpression) {
        this.endDateExpression = endDateExpression;
        this.jRTextExpressionEndDate.setText(endDateExpression);
    }
}

