/*
 * JBoxButtonPopup.java
 *
 * All rights reserved.
 * Copyright (C) 2005 JasperSoft Corporation
 *
 * JasperSoft Corporation
 * 303 Second Street, Suite 450 North
 * San Francisco, CA 94107
 * http://www.jaspersoft.com
 *
 *
 * Created on May 18, 2006, 12:00 PM
 *
 */

package it.businesslogic.ireport.gui.box;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

/**
 *
 * @author gtoffoli
 */
public class JBoxButtonPopup extends JPopupMenu {
    
    private Component parent;
    private Component component;
    private boolean installedTopListener = false;
    
    /** Creates a new instance of JBoxButtonPopup */
    public JBoxButtonPopup(Component parent, Component c) {
        super();
        this.setParentComponent(parent);
        this.setComponent(c);
        super.add(getComponent());

    }
    
     public void show()
    {
        if (!installedTopListener)
        {
              Container rootContainer = (Container)SwingUtilities.getRootPane(getParentComponent());
              rootContainer.addComponentListener(new ComponentListener() {
                  public void componentHidden(ComponentEvent e) {
                      setVisible(false);
                  }
                  public void componentMoved(ComponentEvent e) {
                      setVisible(false);
                  }
                  public void componentResized(ComponentEvent e) {
                      setVisible(false);
                  }
                  public void componentShown(ComponentEvent e) {
                      setVisible(false);
                  }
              } );

        }
        super.setPopupSize(getComponent().getPreferredSize());
        // location specified is relative to comboBox
        super.show(getParentComponent(), 0, getParentComponent().getHeight());
    }

    public Component getParentComponent() {
        return parent;
    }

    public void setParentComponent(Component parent) {
        this.parent = parent;
    }

    public Component getComponent() {
        return component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

}
