/*
 * FormatCommandSameWidthMax.java
 *
 * Created on 9 mei 2005, 21:36
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TransformationType;

import java.awt.Point;
import java.util.Enumeration;

/**
 *
 */
public class FormatCommandSameWidthMax extends FormatCommand {
    {
        operationType = OperationType.SAME_WIDTH_MAX;
    }
    
    int width;
    
    
    public void preparation() {
        width = 0;
        ReportElement re = null;
        Enumeration enum2 = this.getSelectedElements().elements();
        while (enum2.hasMoreElements()) {
            re = (ReportElement)enum2.nextElement();
            if ( width <= re.getWidth()) {
                width = re.getWidth();
            }
        }
    }
    
    public void modify() {
        re.trasform(new Point(width - re.getWidth(),0), TransformationType.TRANSFORMATION_RESIZE_SE);
    }
    
}
