/*
 * TimeZoneWrapper.java
 *
 * All rights reserved.
 * Copyright (C) 2005 JasperSoft Corporation
 *
 * JasperSoft Corporation
 * 303 Second Street, Suite 450 North
 * San Francisco, CA 94107
 * http://www.jaspersoft.com
 *
 *
 * Created on June 16, 2006, 12:26 PM
 *
 */

package it.businesslogic.ireport.gui.locale;
import it.businesslogic.ireport.util.I18n;
import java.util.TimeZone;

/**
 *
 * @author gtoffoli
 */
public class TimeZoneWrapper {
    
    private TimeZone timeZone = null;
    
    /** Creates a new instance of TimeZoneWrapper */
    public TimeZoneWrapper(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }
    
    public String toString()
    {
        if (timeZone != null)
        {
            return timeZone.getID()  + " (" + timeZone.getDisplayName(I18n.getCurrentLocale()) + ")";
        }
        return "Null time zone";
    }
    
}
