/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.Member;
import mondrian.olap.QueryPart;
import mondrian.olap.Syntax;
import mondrian.olap.type.Type;

public abstract class ExpBase
extends QueryPart
implements Exp {
    static Exp[] cloneArray(Exp[] a) {
        Exp[] a2 = new Exp[a.length];
        for (int i = 0; i < a.length; ++i) {
            a2[i] = (Exp)a[i].clone();
        }
        return a2;
    }

    protected ExpBase() {
    }

    public abstract Object clone();

    public final boolean isElement() {
        int category = this.getCategory();
        return category == 6 || category == 3 || category == 4 || category == 2;
    }

    public final boolean isEmptySet() {
        if (this instanceof FunCall) {
            FunCall f = (FunCall)this;
            return f.getSyntax() == Syntax.Braces && f.getArgCount() == 0;
        }
        return false;
    }

    public final Member[] isConstantTuple() {
        if (this instanceof Member) {
            return new Member[]{(Member)((Object)this)};
        }
        if (!(this instanceof FunCall)) {
            return null;
        }
        FunCall f = (FunCall)this;
        if (!f.isCallToTuple()) {
            return null;
        }
        int len = f.getArgCount();
        for (int i = 0; i < len; ++i) {
            if (f.getArg(i) instanceof Member) continue;
            return null;
        }
        Member[] members = new Member[len];
        System.arraycopy(f.getArgs(), 0, members, 0, len);
        return members;
    }

    public int addAtPosition(Exp e, int iPosition) {
        return 1;
    }

    public Object evaluate(Evaluator evaluator) {
        throw new Error("unsupported");
    }

    public Object evaluateScalar(Evaluator evaluator) {
        Object o = this.evaluate(evaluator);
        if (o instanceof Member) {
            evaluator = evaluator.push((Member)o);
            return evaluator.evaluateCurrent();
        }
        if (o instanceof Member[]) {
            evaluator = evaluator.push((Member[])o);
            return evaluator.evaluateCurrent();
        }
        return o;
    }

    public static void unparseList(PrintWriter pw, Exp[] exps, String start, String mid, String end) {
        pw.print(start);
        for (int i = 0; i < exps.length; ++i) {
            if (i > 0) {
                pw.print(mid);
            }
            exps[i].unparse(pw);
        }
        pw.print(end);
    }

    public static int[] getTypes(Exp[] exps) {
        int[] types = new int[exps.length];
        for (int i = 0; i < exps.length; ++i) {
            types[i] = exps[i].getCategory();
        }
        return types;
    }

    public boolean dependsOn(Dimension dimension) {
        Type type = this.getTypeX();
        return !type.usesDimension(dimension);
    }

    public int getType() {
        return this.getCategory();
    }
}

