/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.olap.Category;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Literal;
import mondrian.olap.Parameter;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.type.DecimalType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;

public class ParameterFunDef
extends FunDefBase {
    public final String parameterName;
    private final Hierarchy hierarchy;
    public final Exp exp;
    public final String parameterDescription;

    ParameterFunDef(FunDef funDef, String parameterName, Hierarchy hierarchy, int returnType, Exp exp, String description) {
        super(funDef.getName(), funDef.getSignature(), funDef.getDescription(), funDef.getSyntax(), returnType, funDef.getParameterTypes());
        ParameterFunDef.assertPrecondition(this.getName().equals("Parameter") || this.getName().equals("ParamRef"));
        this.parameterName = parameterName;
        this.hierarchy = hierarchy;
        this.exp = exp;
        this.parameterDescription = description;
    }

    public Exp validateCall(Validator validator, FunCall call) {
        Parameter param = validator.createOrLookupParam(call);
        return validator.validate(param);
    }

    public Type getResultType(Validator validator, Exp[] args) {
        switch (this.returnType) {
            case 9: {
                return new StringType();
            }
            case 7: {
                return new NumericType();
            }
            case 15: {
                return new DecimalType(Integer.MAX_VALUE, 0);
            }
            case 6: {
                return new MemberType(this.hierarchy, null, null);
            }
        }
        throw Category.instance.badValue(this.returnType);
    }

    private static boolean isConstantHierarchy(Exp typeArg) {
        FunCall currentMemberCall;
        FunCall hierarchyCall;
        if (typeArg instanceof Hierarchy) {
            return true;
        }
        if (typeArg instanceof Dimension) {
            return true;
        }
        return typeArg instanceof FunCall && (hierarchyCall = (FunCall)typeArg).getFunName().equals("Hierarchy") && hierarchyCall.getArgCount() > 0 && hierarchyCall.getArg(0) instanceof FunCall && (currentMemberCall = (FunCall)hierarchyCall.getArg(0)).getFunName().equals("CurrentMember") && currentMemberCall.getArgCount() > 0 && currentMemberCall.getArg(0) instanceof Dimension;
    }

    public static class ParamRefResolver
    extends MultiResolver {
        public ParamRefResolver() {
            super("ParamRef", "ParamRef(<Name>)", "Returns the current value of this parameter. If it is null, returns the default value.", new String[]{"fv#"});
        }

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            if (!(args[0] instanceof Literal) || args[0].getCategory() != 9) {
                throw ParamRefResolver.newEvalException(dummyFunDef, "Parameter name must be a string constant");
            }
            String parameterName = (String)((Literal)args[0]).getValue();
            return new ParameterFunDef(dummyFunDef, parameterName, null, 0, null, null);
        }
    }

    public static class ParameterResolver
    extends MultiResolver {
        private static final String[] SIGNATURES = new String[]{"fS#yS#", "fS#yS", "fn#yn#", "fn#yn", "fm#hm#", "fm#hm"};

        public ParameterResolver() {
            super("Parameter", "Parameter(<Name>, <Type>, <DefaultValue>, <Description>)", "Returns default value of parameter.", SIGNATURES);
        }

        public String[] getReservedWords() {
            return new String[]{"NUMERIC", "STRING"};
        }

        /*
         * WARNING - void declaration
         */
        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            void var5_5;
            Hierarchy expHierarchy;
            void var6_6;
            if (!(args[0] instanceof Literal) || args[0].getCategory() != 9) {
                throw ParameterResolver.newEvalException(dummyFunDef, "Parameter name must be a string constant");
            }
            String parameterName = (String)((Literal)args[0]).getValue();
            Exp typeArg = args[1];
            switch (typeArg.getCategory()) {
                case 2: 
                case 3: {
                    Hierarchy hierarchy = typeArg.getTypeX().getHierarchy();
                    if (hierarchy == null || !ParameterFunDef.isConstantHierarchy(typeArg)) {
                        throw ParameterResolver.newEvalException(dummyFunDef, "Invalid hierarchy for parameter '" + parameterName + "'");
                    }
                    int type = 6;
                    break;
                }
                case 11: {
                    int type;
                    Hierarchy hierarchy = null;
                    String s = (String)((Literal)typeArg).getValue();
                    if (s.equalsIgnoreCase("NUMERIC")) {
                        type = 7;
                        break;
                    }
                    if (s.equalsIgnoreCase("STRING")) {
                        type = 9;
                        break;
                    }
                }
                default: {
                    throw ParameterResolver.newEvalException(dummyFunDef, "Invalid type for parameter '" + parameterName + "'; expecting NUMERIC, STRING or a hierarchy");
                }
            }
            Exp exp = args[2];
            if (exp.getCategory() != var6_6) {
                String typeName = Category.instance.getName((int)var6_6).toUpperCase();
                throw ParameterResolver.newEvalException(dummyFunDef, "Default value of parameter '" + parameterName + "' is inconsistent with its type, " + typeName);
            }
            if (var6_6 == 6 && (expHierarchy = exp.getTypeX().getHierarchy()) != var5_5) {
                throw ParameterResolver.newEvalException(dummyFunDef, "Default value of parameter '" + parameterName + "' must belong to the hierarchy " + var5_5);
            }
            String parameterDescription = null;
            if (args.length > 3) {
                if (args[3] instanceof Literal && args[3].getCategory() == 9) {
                    parameterDescription = (String)((Literal)args[3]).getValue();
                } else {
                    throw ParameterResolver.newEvalException(dummyFunDef, "Description of parameter '" + parameterName + "' must be a string constant");
                }
            }
            return new ParameterFunDef(dummyFunDef, parameterName, (Hierarchy)var5_5, (int)var6_6, exp, parameterDescription);
        }
    }
}

