/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class JSQLTablesPane
extends JDesktopPane {
    boolean repainting = false;
    private Graphics2D offscreen = null;
    private BufferedImage offscreenImage = null;

    public JSQLTablesPane() {
        Dimension offscreenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.offscreenImage = new BufferedImage(offscreenDimension.width, offscreenDimension.height, 7);
        this.offscreen = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(this.offscreenImage);
        this.offscreen.setBackground(this.getBackground());
        this.offscreen.setColor(Color.BLACK);
        this.setDoubleBuffered(false);
    }

    public void paint(Graphics g) {
        if (this.repainting) {
            return;
        }
        this.repainting = true;
        if (this.offscreen == null) {
            return;
        }
        this.offscreen.clearRect(0, 0, this.getWidth(), this.getHeight());
        JInternalFrame[] frames = this.getAllFrames();
        this.offscreen.drawLine(frames[0].getLocation().x + frames[0].getWidth() / 2, frames[0].getLocation().y + frames[0].getHeight() / 2, frames[1].getLocation().x + frames[1].getWidth() / 2, frames[1].getLocation().y + frames[1].getHeight() / 2);
        super.paintChildren(this.offscreen);
        g.drawImage(this.offscreenImage, 0, 0, this);
        this.repainting = false;
    }

    public void repaint() {
        this.paint(this.getGraphics());
    }
}

