/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.plugin.locale;

import it.businesslogic.ireport.plugin.locale.ProgressBarCellRenderer;
import it.businesslogic.ireport.plugin.locale.TranslationStatusDetailDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LocaleAdapter;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TranslationStatusDialog
extends JDialog {
    private JButton jButtonDetails;
    private JButton jButtonOk;
    private JScrollPane jScrollPane1;
    private JTable jTableLanguages;

    public TranslationStatusDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        TableColumnModel tcm = this.jTableLanguages.getColumnModel();
        TableColumn tc = tcm.getColumn(1);
        tc.setCellRenderer(new ProgressBarCellRenderer());
        DefaultListSelectionModel dsm = new DefaultListSelectionModel();
        dsm.setSelectionMode(0);
        dsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TranslationStatusDialog.this.jButtonDetails.setEnabled(TranslationStatusDialog.this.jTableLanguages.getSelectedRow() >= 0);
            }
        });
        this.jTableLanguages.setSelectionModel(dsm);
        this.updateStatus();
        this.pack();
        Misc.centerFrame(this);
    }

    public void updateStatus() {
        List listOfLanguages = I18n.getListOfAvailLanguages();
        DefaultTableModel dtm = (DefaultTableModel)this.jTableLanguages.getModel();
        Properties props_default = new Properties();
        try {
            props_default.load(this.getClass().getResourceAsStream("/it/businesslogic/ireport/locale/Ireport.properties"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < listOfLanguages.size(); ++i) {
            Locale lang = (Locale)listOfLanguages.get(i);
            LocaleAdapter adapter = new LocaleAdapter(lang);
            String language = lang.getLanguage();
            String country = lang.getCountry();
            String variant = lang.getVariant();
            String language_name = language.length() > 0 ? "_" + language : "";
            language_name = language_name + (country.length() > 0 ? "_" + country : "");
            language_name = language_name + (variant.length() > 0 ? "_" + variant : "");
            language_name = "Ireport" + language_name + ".properties";
            int percentage_language = this.getLanguageCompletation(props_default, language_name);
            dtm.addRow(new Object[]{adapter, new Integer(percentage_language), language_name});
        }
    }

    public int getLanguageCompletation(Properties defaultTranslations, String language) {
        Properties props2 = new Properties();
        try {
            props2.load(this.getClass().getResourceAsStream("/it/businesslogic/ireport/locale/" + language));
        }
        catch (Exception ex) {
            // empty catch block
        }
        double size = 0.0;
        Iterator<Object> namesIterator = defaultTranslations.keySet().iterator();
        size = defaultTranslations.size();
        double translated = 0.0;
        while (namesIterator.hasNext()) {
            String name = "" + namesIterator.next();
            if (name.equals("defaultFont")) {
                size -= 1.0;
                continue;
            }
            if (props2.getProperty(name) == null) continue;
            translated += 1.0;
        }
        if (translated == 0.0) {
            return 0;
        }
        return (int)(translated / size * 100.0);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableLanguages = new JTable();
        this.jButtonOk = new JButton();
        this.jButtonDetails = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jTableLanguages.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableLanguages.setGridColor(new Color(204, 204, 204));
        this.jTableLanguages.setShowVerticalLines(false);
        this.jTableLanguages.setTableHeader(null);
        this.jTableLanguages.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TranslationStatusDialog.this.jTableLanguagesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableLanguages);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonOk.setText("Close");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranslationStatusDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonDetails.setText("Details...");
        this.jButtonDetails.setEnabled(false);
        this.jButtonDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranslationStatusDialog.this.jButtonDetailsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jButtonDetails, gridBagConstraints);
        this.pack();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jTableLanguagesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                this.jButtonDetailsActionPerformed(null);
            }
        }
    }

    private void jButtonDetailsActionPerformed(ActionEvent evt) {
        if (this.jTableLanguages.getSelectedRow() < 0) {
            return;
        }
        int row = this.jTableLanguages.getSelectedRow();
        LocaleAdapter adapter = (LocaleAdapter)this.jTableLanguages.getValueAt(this.jTableLanguages.getSelectedRow(), 0);
        TranslationStatusDetailDialog tsdd = new TranslationStatusDetailDialog((Dialog)this, true);
        Properties props_default = new Properties();
        try {
            props_default.load(this.getClass().getResourceAsStream("/it/businesslogic/ireport/locale/Ireport.properties"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (props_default != null) {
            tsdd.setLanguage("" + this.jTableLanguages.getValueAt(this.jTableLanguages.getSelectedRow(), 2), props_default);
            tsdd.setVisible(true);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TranslationStatusDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }
}

