/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.custom.SQLQueryCollectionReturn;
import org.hibernate.loader.custom.SQLQueryJoinReturn;
import org.hibernate.loader.custom.SQLQueryReturn;
import org.hibernate.loader.custom.SQLQueryRootReturn;
import org.hibernate.loader.custom.SQLQueryScalarReturn;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.SQLLoadable;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class SQLQueryReturnProcessor {
    private SQLQueryReturn[] queryReturns;
    private SQLQueryScalarReturn[] scalarQueryReturns;
    private final List aliases = new ArrayList();
    private final List persisters = new ArrayList();
    private final List propertyResults = new ArrayList();
    private final List aliasModes = new ArrayList();
    private final List lockModes = new ArrayList();
    private final Map alias2Persister = new HashMap();
    private final Map alias2Return = new HashMap();
    private final Map alias2OwnerAlias = new HashMap();
    private final List scalarTypes = new ArrayList();
    private final List scalarColumnAliases = new ArrayList();
    private final SessionFactoryImplementor factory;
    private List collectionOwnerAliases = new ArrayList();
    private List collectionAliases = new ArrayList();
    private List collectionPersisters = new ArrayList();
    private boolean isCollectionInitializer = false;

    private SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    private SQLLoadable getSQLLoadable(String entityName) throws MappingException {
        EntityPersister persister = this.getFactory().getEntityPersister(entityName);
        if (!(persister instanceof SQLLoadable)) {
            throw new MappingException("class persister is not SQLLoadable: " + entityName);
        }
        return (SQLLoadable)persister;
    }

    public SQLQueryReturnProcessor(SQLQueryReturn[] queryReturns, SQLQueryScalarReturn[] scalarQueryReturns, SessionFactoryImplementor factory) {
        this.queryReturns = queryReturns;
        this.scalarQueryReturns = scalarQueryReturns;
        this.factory = factory;
    }

    public void process() {
        int i;
        for (i = 0; i < this.queryReturns.length; ++i) {
            this.alias2Return.put(this.queryReturns[i].getAlias(), this.queryReturns[i]);
            if (this.queryReturns[i] instanceof SQLQueryJoinReturn) {
                SQLQueryJoinReturn roleReturn = (SQLQueryJoinReturn)this.queryReturns[i];
                this.alias2OwnerAlias.put(roleReturn.getAlias(), roleReturn.getOwnerAlias());
                continue;
            }
            if (!(this.queryReturns[i] instanceof SQLQueryCollectionReturn)) continue;
            this.isCollectionInitializer = true;
        }
        for (i = 0; i < this.queryReturns.length; ++i) {
            this.processReturn(this.queryReturns[i]);
        }
        if (this.scalarQueryReturns != null) {
            for (i = 0; i < this.scalarQueryReturns.length; ++i) {
                this.processScalarReturn(this.scalarQueryReturns[i]);
            }
        }
    }

    private void processReturn(SQLQueryReturn rtn) {
        if (rtn instanceof SQLQueryRootReturn) {
            this.processRootReturn((SQLQueryRootReturn)rtn);
        } else if (rtn instanceof SQLQueryCollectionReturn) {
            this.processCollectionReturn((SQLQueryCollectionReturn)rtn);
        } else {
            this.processRoleReturn((SQLQueryJoinReturn)rtn);
        }
    }

    private void processScalarReturn(SQLQueryScalarReturn typeReturn) {
        this.scalarColumnAliases.add(typeReturn.getColumnAlias());
        this.scalarTypes.add(typeReturn.getType());
    }

    private void processRootReturn(SQLQueryRootReturn rootReturn) {
        if (this.alias2Persister.containsKey(rootReturn.getAlias())) {
            return;
        }
        SQLLoadable persister = this.getSQLLoadable(rootReturn.getReturnEntityName());
        this.aliases.add(rootReturn.getAlias());
        this.addPersister(rootReturn.useGeneratedAliases(), rootReturn.getPropertyResultsMap(), persister);
        this.alias2Persister.put(rootReturn.getAlias(), persister);
        this.lockModes.add(rootReturn.getLockMode());
    }

    private void addPersister(boolean useGeneratedAliases, Map propertyResult, SQLLoadable persister) {
        this.persisters.add(persister);
        this.propertyResults.add(propertyResult);
        this.aliasModes.add(useGeneratedAliases);
    }

    private void addCollection(String role, String alias, Map propertyResults, LockMode lockMode) {
        QueryableCollection collectionPersister = (QueryableCollection)this.getFactory().getCollectionPersister(role);
        this.collectionPersisters.add(collectionPersister);
        this.collectionAliases.add(alias);
        if (collectionPersister.isOneToMany()) {
            SQLLoadable persister = (SQLLoadable)collectionPersister.getElementPersister();
            this.aliases.add(alias);
            this.addPersister(true, propertyResults, persister);
            this.lockModes.add(lockMode);
            this.alias2Persister.put(alias, persister);
        }
    }

    private void processCollectionReturn(SQLQueryCollectionReturn collectionReturn) {
        this.collectionOwnerAliases.add(null);
        String role = collectionReturn.getOwnerEntityName() + '.' + collectionReturn.getOwnerProperty();
        this.addCollection(role, collectionReturn.getAlias(), collectionReturn.getPropertyResultsMap(), collectionReturn.getLockMode());
    }

    private void processRoleReturn(SQLQueryJoinReturn roleReturn) {
        SQLLoadable ownerPersister;
        Type returnType;
        String alias = roleReturn.getAlias();
        if (this.alias2Persister.containsKey(alias) || this.collectionAliases.contains(alias)) {
            return;
        }
        String ownerAlias = roleReturn.getOwnerAlias();
        if (!this.alias2Return.containsKey(ownerAlias)) {
            throw new HibernateException("Owner alias [" + ownerAlias + "] is unknown for alias [" + alias + "]");
        }
        if (!this.alias2Persister.containsKey(ownerAlias)) {
            SQLQueryReturn ownerReturn = (SQLQueryReturn)this.alias2Return.get(ownerAlias);
            this.processReturn(ownerReturn);
        }
        if ((returnType = (ownerPersister = (SQLLoadable)this.alias2Persister.get(ownerAlias)).getPropertyType(roleReturn.getOwnerProperty())).isCollectionType()) {
            String role = ownerPersister.getEntityName() + '.' + roleReturn.getOwnerProperty();
            this.addCollection(role, alias, roleReturn.getPropertyResultsMap(), roleReturn.getLockMode());
            this.collectionOwnerAliases.add(ownerAlias);
        } else if (returnType.isEntityType()) {
            EntityType eType = (EntityType)returnType;
            String returnEntityName = eType.getAssociatedEntityName();
            SQLLoadable persister = this.getSQLLoadable(returnEntityName);
            this.aliases.add(alias);
            this.addPersister(true, roleReturn.getPropertyResultsMap(), persister);
            this.lockModes.add(roleReturn.getLockMode());
            this.alias2Persister.put(alias, persister);
        }
    }

    public List getCollectionAliases() {
        return this.collectionAliases;
    }

    public List getCollectionOwnerAliases() {
        return this.collectionOwnerAliases;
    }

    public List getCollectionPersisters() {
        return this.collectionPersisters;
    }

    public Map getAlias2Persister() {
        return this.alias2Persister;
    }

    public List getAliases() {
        return this.aliases;
    }

    public boolean isCollectionInitializer() {
        return this.isCollectionInitializer;
    }

    public List getLockModes() {
        return this.lockModes;
    }

    public List getPersisters() {
        return this.persisters;
    }

    public Map getAlias2OwnerAlias() {
        return this.alias2OwnerAlias;
    }

    public List getScalarTypes() {
        return this.scalarTypes;
    }

    public List getScalarColumnAliases() {
        return this.scalarColumnAliases;
    }

    public List getPropertyResults() {
        return this.propertyResults;
    }

    public Map getAlias2Return() {
        return this.alias2Return;
    }

    public List getAliasModes() {
        return this.aliasModes;
    }
}

