/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.prompt;

import com.michaelbaranov.microba.calendar.DatePicker;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class JDateTimePicker
extends JPanel
implements LanguageChangedListener {
    private Locale locale = null;
    private DatePicker datePicker = null;
    private JLabel jLabelH;
    private JLabel jLabelMin;
    private JLabel jLabelSec;
    private JPanel jPanel1;
    private JSpinner jSpinnerH;
    private JSpinner jSpinnerM;
    private JSpinner jSpinnerS;

    public JDateTimePicker() {
        this.initComponents();
        this.jSpinnerH.setModel(new SpinnerNumberModel(0, 0, 23, 1));
        this.jSpinnerM.setModel(new SpinnerNumberModel(0, 0, 59, 1));
        this.jSpinnerS.setModel(new SpinnerNumberModel(0, 0, 59, 1));
        this.datePicker = new DatePicker();
        this.jPanel1.add((Component)this.datePicker, "Center");
        this.setLocale(I18n.getCurrentLocale());
        this.setDate(new Date());
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.datePicker.setLocale(locale);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setDate(Date d) {
        if (d == null) {
            return;
        }
        GregorianCalendar gc = null;
        gc = this.getLocale() != null ? new GregorianCalendar(this.getLocale()) : new GregorianCalendar();
        gc.setTime(d);
        this.jSpinnerH.setValue(new Integer(gc.get(11)));
        this.jSpinnerM.setValue(new Integer(gc.get(12)));
        this.jSpinnerS.setValue(new Integer(gc.get(13)));
        try {
            this.datePicker.setDate(d);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Date getDate() {
        if (this.datePicker.getDate() == null) {
            return null;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(this.datePicker.getDate());
        gc.set(11, ((SpinnerNumberModel)this.jSpinnerH.getModel()).getNumber().intValue());
        gc.set(12, ((SpinnerNumberModel)this.jSpinnerM.getModel()).getNumber().intValue());
        gc.set(12, ((SpinnerNumberModel)this.jSpinnerS.getModel()).getNumber().intValue());
        return gc.getTime();
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void applyI18n() {
        this.jLabelH.setText(I18n.getString("time_picker", "Time"));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabelH = new JLabel();
        this.jSpinnerH = new JSpinner();
        this.jLabelMin = new JLabel();
        this.jSpinnerM = new JSpinner();
        this.jLabelSec = new JLabel();
        this.jSpinnerS = new JSpinner();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabelH.setText("Time");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.jLabelH, gridBagConstraints);
        this.jSpinnerH.setMinimumSize(new Dimension(35, 18));
        this.jSpinnerH.setPreferredSize(new Dimension(35, 18));
        this.add((Component)this.jSpinnerH, new GridBagConstraints());
        this.jLabelMin.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.jLabelMin, gridBagConstraints);
        this.jSpinnerM.setMinimumSize(new Dimension(35, 18));
        this.jSpinnerM.setPreferredSize(new Dimension(35, 18));
        this.add((Component)this.jSpinnerM, new GridBagConstraints());
        this.jLabelSec.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.jLabelSec, gridBagConstraints);
        this.jSpinnerS.setMinimumSize(new Dimension(35, 18));
        this.jSpinnerS.setPreferredSize(new Dimension(35, 18));
        this.add((Component)this.jSpinnerS, new GridBagConstraints());
    }
}

