/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.wizard;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.IReportTemplate;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.StaticTextReportElement;
import it.businesslogic.ireport.SubReportElement;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.TransformationType;
import it.businesslogic.ireport.connection.JDBCConnection;
import it.businesslogic.ireport.connection.JRCSVDataSourceConnection;
import it.businesslogic.ireport.connection.JRDataSourceProviderConnection;
import it.businesslogic.ireport.connection.JRHibernateConnection;
import it.businesslogic.ireport.connection.JavaBeanDataSourceConnection;
import it.businesslogic.ireport.connection.NullConnection;
import it.businesslogic.ireport.gui.ConnectionDialog;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.WizardDialog;
import it.businesslogic.ireport.gui.wizard.BaseWizardPanel;
import it.businesslogic.ireport.gui.wizard.GenericWizard;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SubreportWizardNewReport
extends JPanel
implements GenericWizard,
Runnable {
    private String reportFileName = null;
    private SubReportElement subReportElement = null;
    private BaseWizardPanel wizardPanel = null;
    private JDialog wizardDialog = null;
    Vector templates = null;
    private Thread t = null;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButtonLoadQuery;
    private JButton jButtonNewConnection;
    private JButton jButtonSaveQuery;
    private JComboBox jComboBoxConnection;
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel2e;
    private JLabel jLabel3;
    private JLabel jLabelImage;
    private JList jList1;
    private JList jList2;
    private JList jList3;
    private JPanel jPanel0;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel41;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel61;
    private JPanel jPanel7;
    private JPanel jPanelButtons;
    private JRTextExpressionArea jRSQLExpressionArea1;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton5;
    private JRadioButton jRadioButtonColumnarLayout;
    private JRadioButton jRadioButtonTabularLayout;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTextField jTextFieldBean;
    private JTextField jTextFieldReportFileName;

    public SubreportWizardNewReport() {
        this.initComponents();
        this.jRSQLExpressionArea1.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                if (SubreportWizardNewReport.this.wizardPanel != null) {
                    SubreportWizardNewReport.this.wizardPanel.updateButtons();
                }
            }

            public void insertUpdate(DocumentEvent e) {
                if (SubreportWizardNewReport.this.wizardPanel != null) {
                    SubreportWizardNewReport.this.wizardPanel.updateButtons();
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (SubreportWizardNewReport.this.wizardPanel != null) {
                    SubreportWizardNewReport.this.wizardPanel.updateButtons();
                }
            }
        });
        this.jTextFieldBean.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                if (SubreportWizardNewReport.this.wizardPanel != null) {
                    SubreportWizardNewReport.this.wizardPanel.updateButtons();
                }
            }

            public void insertUpdate(DocumentEvent e) {
                if (SubreportWizardNewReport.this.wizardPanel != null) {
                    SubreportWizardNewReport.this.wizardPanel.updateButtons();
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (SubreportWizardNewReport.this.wizardPanel != null) {
                    SubreportWizardNewReport.this.wizardPanel.updateButtons();
                }
            }
        });
        this.jTextFieldReportFileName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                if (SubreportWizardNewReport.this.wizardPanel != null) {
                    SubreportWizardNewReport.this.wizardPanel.updateButtons();
                }
                SubreportWizardNewReport.this.updateExpressionLabels();
            }

            public void insertUpdate(DocumentEvent e) {
                if (SubreportWizardNewReport.this.wizardPanel != null) {
                    SubreportWizardNewReport.this.wizardPanel.updateButtons();
                }
                SubreportWizardNewReport.this.updateExpressionLabels();
            }

            public void removeUpdate(DocumentEvent e) {
                if (SubreportWizardNewReport.this.wizardPanel != null) {
                    SubreportWizardNewReport.this.wizardPanel.updateButtons();
                }
                SubreportWizardNewReport.this.updateExpressionLabels();
            }
        });
        Vector values = new Vector();
        Report report = MainFrame.getMainInstance().getActiveReportFrame().getReport();
        values.addAll(report.getFields());
        values.addAll(report.getVariables());
        values.addAll(report.getParameters());
        this.jList1.setModel(new DefaultListModel());
        this.jList2.setModel(new DefaultListModel());
        this.jList3.setModel(new DefaultListModel());
        this.updateTemplatesList();
        String fileName = report.getFilename();
        File f = new File(fileName);
        String baseFileName = f.getName();
        String pathFile = f.getParent();
        if (pathFile.length() > 0 && !pathFile.endsWith(File.separator)) {
            pathFile = pathFile + File.separator;
        }
        if (baseFileName.indexOf(".") > 0) {
            baseFileName = baseFileName.substring(0, baseFileName.lastIndexOf("."));
        }
        File f2 = null;
        int i = 0;
        while ((f2 = new File(pathFile, fileName = baseFileName + "_subreport" + i + ".jrxml")).exists()) {
            ++i;
        }
        this.jTextFieldReportFileName.setText(f2.getName());
    }

    private void initComponents() {
        this.jPanel0 = new JPanel();
        this.jPanel61 = new JPanel();
        this.jLabel12 = new JLabel();
        this.jComboBoxConnection = new JComboBox();
        this.jButtonNewConnection = new JButton();
        this.jLabel2 = new JLabel();
        this.jPanel41 = new JPanel();
        this.jRSQLExpressionArea1 = new JRTextExpressionArea();
        this.jTextFieldBean = new JTextField();
        this.jPanel5 = new JPanel();
        this.jButtonLoadQuery = new JButton();
        this.jButtonSaveQuery = new JButton();
        this.jPanel6 = new JPanel();
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.jPanelButtons = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jPanel2 = new JPanel();
        this.jRadioButtonColumnarLayout = new JRadioButton();
        this.jRadioButtonTabularLayout = new JRadioButton();
        this.jPanel7 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jList3 = new JList();
        this.jPanel4 = new JPanel();
        this.jLabelImage = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jTextFieldReportFileName = new JTextField();
        this.jRadioButton4 = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jRadioButton5 = new JRadioButton();
        this.jLabel2e = new JLabel();
        this.jButton5 = new JButton();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel0.setLayout(new GridBagLayout());
        this.jPanel0.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SubreportWizardNewReport.this.jPanel0PropertyChange(evt);
            }
        });
        this.jPanel61.setMinimumSize(new Dimension(10, 30));
        this.jPanel61.setPreferredSize(new Dimension(10, 30));
        this.jPanel0.add((Component)this.jPanel61, new GridBagConstraints());
        this.jLabel12.setText("Connection / Datasource");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 2, 0);
        this.jPanel0.add((Component)this.jLabel12, gridBagConstraints);
        this.jComboBoxConnection.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxConnection.setMinimumSize(new Dimension(51, 22));
        this.jComboBoxConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizardNewReport.this.jComboBoxConnectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.jPanel0.add((Component)this.jComboBoxConnection, gridBagConstraints);
        this.jButtonNewConnection.setText("New");
        this.jButtonNewConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizardNewReport.this.jButtonNewConnectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 20);
        this.jPanel0.add((Component)this.jButtonNewConnection, gridBagConstraints);
        this.jLabel2.setText("Query");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(30, 20, 2, 0);
        this.jPanel0.add((Component)this.jLabel2, gridBagConstraints);
        this.jPanel41.setLayout(new GridBagLayout());
        this.jPanel41.setMinimumSize(new Dimension(391, 120));
        this.jPanel41.setPreferredSize(new Dimension(391, 120));
        this.jRSQLExpressionArea1.setBorder(BorderFactory.createEtchedBorder());
        this.jRSQLExpressionArea1.setElectricScroll(0);
        this.jRSQLExpressionArea1.setMinimumSize(new Dimension(300, 100));
        this.jRSQLExpressionArea1.setPreferredSize(new Dimension(300, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel41.add((Component)this.jRSQLExpressionArea1, gridBagConstraints);
        this.jTextFieldBean.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizardNewReport.this.jTextFieldBeanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel41.add((Component)this.jTextFieldBean, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jButtonLoadQuery.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/folder_database.png")));
        this.jButtonLoadQuery.setText("Load query");
        this.jButtonLoadQuery.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonLoadQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizardNewReport.this.jButtonLoadQueryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jButtonLoadQuery, gridBagConstraints);
        this.jButtonSaveQuery.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/database_save.png")));
        this.jButtonSaveQuery.setText("Save query");
        this.jButtonSaveQuery.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonSaveQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizardNewReport.this.jButtonSaveQueryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel5.add((Component)this.jButtonSaveQuery, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel41.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.jPanel0.add((Component)this.jPanel41, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel0.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 5);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane2.setViewportView(this.jList2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 10);
        this.jPanel1.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanelButtons.setLayout(new GridBagLayout());
        this.jButton1.setText(">");
        this.jButton1.setMargin(new Insets(2, 0, 2, 0));
        this.jButton1.setMinimumSize(new Dimension(28, 28));
        this.jButton1.setPreferredSize(new Dimension(28, 28));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizardNewReport.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.jPanelButtons.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setText(">>");
        this.jButton2.setMargin(new Insets(2, 0, 2, 0));
        this.jButton2.setMinimumSize(new Dimension(28, 28));
        this.jButton2.setPreferredSize(new Dimension(28, 28));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizardNewReport.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.jPanelButtons.add((Component)this.jButton2, gridBagConstraints);
        this.jButton3.setText("<<");
        this.jButton3.setMargin(new Insets(2, 0, 2, 0));
        this.jButton3.setMinimumSize(new Dimension(28, 28));
        this.jButton3.setPreferredSize(new Dimension(28, 28));
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizardNewReport.this.jButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.jPanelButtons.add((Component)this.jButton3, gridBagConstraints);
        this.jButton4.setText("<");
        this.jButton4.setMargin(new Insets(2, 0, 2, 0));
        this.jButton4.setMinimumSize(new Dimension(28, 28));
        this.jButton4.setPreferredSize(new Dimension(28, 28));
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizardNewReport.this.jButton4ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.jPanelButtons.add((Component)this.jButton4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.jPanel1.add((Component)this.jPanelButtons, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.jRadioButtonColumnarLayout);
        this.jRadioButtonColumnarLayout.setSelected(true);
        this.jRadioButtonColumnarLayout.setText("Columnar layout");
        this.jRadioButtonColumnarLayout.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonColumnarLayout.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonColumnarLayout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizardNewReport.this.jRadioButtonColumnarLayoutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(30, 20, 0, 0);
        this.jPanel2.add((Component)this.jRadioButtonColumnarLayout, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonTabularLayout);
        this.jRadioButtonTabularLayout.setText("Tabular layout");
        this.jRadioButtonTabularLayout.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonTabularLayout.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonTabularLayout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizardNewReport.this.jRadioButtonTabularLayoutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 20, 0, 0);
        this.jPanel2.add((Component)this.jRadioButtonTabularLayout, gridBagConstraints);
        this.jPanel7.setLayout(new BorderLayout());
        this.jPanel7.setMinimumSize(new Dimension(150, 23));
        this.jPanel7.setPreferredSize(new Dimension(150, 0));
        this.jScrollPane3.setMinimumSize(new Dimension(100, 23));
        this.jList3.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SubreportWizardNewReport.this.jList3ValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jList3);
        this.jPanel7.add((Component)this.jScrollPane3, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 20, 10, 0);
        this.jPanel2.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabelImage.setHorizontalAlignment(2);
        this.jLabelImage.setText("  ");
        this.jLabelImage.setVerticalAlignment(1);
        this.jLabelImage.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jLabelImage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 10, 10, 10);
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel3.setText("Save the subreport as...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 20, 2, 0);
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.jPanel3.add((Component)this.jTextFieldReportFileName, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButton4);
        this.jRadioButton4.setSelected(true);
        this.jRadioButton4.setText("Store the directory name in a parameter");
        this.jRadioButton4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton4.setFocusPainted(false);
        this.jRadioButton4.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton4.setMinimumSize(new Dimension(115, 20));
        this.jRadioButton4.setPreferredSize(new Dimension(115, 20));
        this.jRadioButton4.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SubreportWizardNewReport.this.jRadioButton1ItemStateChanged2(evt);
            }
        });
        this.jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizardNewReport.this.jRadioButton1ActionPerformed2(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(40, 20, 0, 0);
        this.jPanel3.add((Component)this.jRadioButton4, gridBagConstraints);
        this.jLabel1.setText("$P{SUBREPORT_DIR} + /name.jasper");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 40, 0, 0);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButton5);
        this.jRadioButton5.setText("Use a static absolute path reference");
        this.jRadioButton5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton5.setFocusPainted(false);
        this.jRadioButton5.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton5.setMinimumSize(new Dimension(115, 20));
        this.jRadioButton5.setPreferredSize(new Dimension(115, 20));
        this.jRadioButton5.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SubreportWizardNewReport.this.jRadioButton2jRadioButton1ItemStateChanged1(evt);
            }
        });
        this.jRadioButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizardNewReport.this.jRadioButton2jRadioButton1ActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 20, 0, 0);
        this.jPanel3.add((Component)this.jRadioButton5, gridBagConstraints);
        this.jLabel2e.setText("path reference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 40, 0, 0);
        this.jPanel3.add((Component)this.jLabel2e, gridBagConstraints);
        this.jButton5.setText("Browse...");
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportWizardNewReport.this.jButton5ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 10);
        this.jPanel3.add((Component)this.jButton5, gridBagConstraints);
        this.setLayout(new BorderLayout());
    }

    private void jButtonSaveQueryActionPerformed(ActionEvent evt) {
        Misc.saveSQLQuery(this.jRSQLExpressionArea1.getText(), this);
    }

    private void jButtonLoadQueryActionPerformed(ActionEvent evt) {
        String query = Misc.loadSQLQuery(this);
        if (query != null) {
            this.jRSQLExpressionArea1.setText(query);
        }
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        File original_file = null;
        try {
            original_file = new File(MainFrame.getMainInstance().getActiveReportFrame().getReport().getFilename());
            if (original_file != null && original_file.getParentFile() != null) {
                jfc.setCurrentDirectory(original_file.getParentFile());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName().toLowerCase();
                return filename.endsWith(".jrxml") || file.isDirectory();
            }

            public String getDescription() {
                return "JasperReports Report file *jrxml";
            }
        });
        if (jfc.showSaveDialog(this) == 0) {
            if (original_file != null && original_file.equals(jfc.getSelectedFile())) {
                JOptionPane.showMessageDialog(this, "Master and report files can not be the same file!");
                return;
            }
            String s = jfc.getSelectedFile().getPath();
            if (original_file != null && original_file.getParentFile() != null && original_file.getParentFile().equals(jfc.getSelectedFile().getParentFile())) {
                s = jfc.getSelectedFile().getName();
            }
            if (!s.toLowerCase().endsWith(".jrxml")) {
                if (!s.endsWith(".")) {
                    s = s + ".";
                }
                s = s + "jrmxl";
            }
            this.jTextFieldReportFileName.setText(s);
        }
        if (this.wizardPanel != null) {
            this.wizardPanel.updateButtons();
        }
    }

    private void jList3ValueChanged(ListSelectionEvent evt) {
        if (this.jList3.getSelectedIndex() >= 0) {
            IReportTemplate tf = (IReportTemplate)this.jList3.getSelectedValue();
            this.jLabelImage.setIcon(tf.getIcon());
            if (tf.getIcon() == null) {
                this.jLabelImage.setText(" ");
            } else {
                this.jLabelImage.setText("");
            }
            this.jLabelImage.updateUI();
            if (this.wizardPanel != null) {
                this.wizardPanel.updateButtons();
            }
        }
    }

    private void jRadioButtonTabularLayoutActionPerformed(ActionEvent evt) {
        this.updateTemplatesList();
    }

    private void jRadioButtonColumnarLayoutActionPerformed(ActionEvent evt) {
        this.updateTemplatesList();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        int index = this.jList2.getSelectedIndex();
        if (index < 0) {
            return;
        }
        Object[] objs = this.jList2.getSelectedValues();
        for (int i = 0; i < objs.length; ++i) {
            Object obj = objs[i];
            ((DefaultListModel)this.jList1.getModel()).addElement(obj);
            ((DefaultListModel)this.jList2.getModel()).removeElement(obj);
        }
        if (this.jList1.getModel().getSize() > 0) {
            this.jList1.setSelectedIndex(0);
        }
        this.wizardPanel.updateButtons();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        DefaultListModel list2 = (DefaultListModel)this.jList2.getModel();
        DefaultListModel list1 = (DefaultListModel)this.jList1.getModel();
        for (int i = 0; i < list2.getSize(); ++i) {
            list1.addElement(list2.getElementAt(i));
        }
        list2.removeAllElements();
        if (list1.size() > 0) {
            this.jList1.setSelectedIndex(0);
        }
        this.wizardPanel.updateButtons();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        DefaultListModel list1 = (DefaultListModel)this.jList1.getModel();
        DefaultListModel list2 = (DefaultListModel)this.jList2.getModel();
        for (int i = 0; i < list1.getSize(); ++i) {
            list2.addElement(list1.getElementAt(i));
        }
        list1.removeAllElements();
        this.wizardPanel.updateButtons();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int index = this.jList1.getSelectedIndex();
        if (index < 0) {
            return;
        }
        Object[] objs = this.jList1.getSelectedValues();
        for (int i = 0; i < objs.length; ++i) {
            Object obj = objs[i];
            ((DefaultListModel)this.jList2.getModel()).addElement(obj);
            ((DefaultListModel)this.jList1.getModel()).removeElement(obj);
        }
        if (this.jList1.getModel().getSize() > 0) {
            this.jList1.setSelectedIndex(0);
        }
        this.wizardPanel.updateButtons();
    }

    private void jTextFieldBeanActionPerformed(ActionEvent evt) {
        this.jComboBoxConnectionActionPerformed(null);
    }

    private void jButtonNewConnectionActionPerformed(ActionEvent evt) {
        ConnectionDialog cd = new ConnectionDialog((Dialog)this.wizardDialog, true);
        cd.setVisible(true);
        IReportConnection con = null;
        if (cd.getDialogResult() == 0) {
            con = cd.getIReportConnection();
            MainFrame.getMainInstance().getConnections().addElement(con);
            if (MainFrame.getMainInstance().getConnections().size() == 1) {
                MainFrame.getMainInstance().setActiveConnection(con);
            } else {
                MainFrame.getMainInstance().saveiReportConfiguration();
            }
            this.updateConnections();
            this.jComboBoxConnection.setSelectedItem(con);
        }
    }

    public void updateConnections() {
        Object ircDefault = MainFrame.getMainInstance().getProperties().get("DefaultConnection");
        this.jComboBoxConnection.removeAllItems();
        this.jComboBoxConnection.addItem(new NullConnection());
        Enumeration e = MainFrame.getMainInstance().getConnections().elements();
        while (e.hasMoreElements()) {
            IReportConnection irc = (IReportConnection)e.nextElement();
            this.jComboBoxConnection.addItem(irc);
        }
        if (ircDefault != null) {
            this.jComboBoxConnection.setSelectedItem(ircDefault);
        }
    }

    private void jComboBoxConnectionActionPerformed(ActionEvent evt) {
        boolean canNext = false;
        if (this.jComboBoxConnection.getSelectedItem() != null) {
            IReportConnection irc = (IReportConnection)this.jComboBoxConnection.getSelectedItem();
            if (irc.isJDBCConnection()) {
                this.jLabel2.setText("SQL query");
                this.jTextFieldBean.setVisible(false);
                this.jRSQLExpressionArea1.setVisible(true);
                if (this.jRSQLExpressionArea1.getText().length() > 0) {
                    canNext = true;
                }
            } else if (irc instanceof JRHibernateConnection) {
                this.jLabel2.setText("HQL query");
                this.jTextFieldBean.setVisible(false);
                this.jRSQLExpressionArea1.setVisible(true);
                if (this.jRSQLExpressionArea1.getText().length() > 0) {
                    canNext = true;
                }
            } else if (irc instanceof JRDataSourceProviderConnection) {
                this.jLabel2.setText(" ");
                this.jTextFieldBean.setVisible(false);
                this.jRSQLExpressionArea1.setVisible(false);
                canNext = true;
            } else if (irc instanceof JavaBeanDataSourceConnection) {
                this.jLabel2.setText("JavaBean class");
                this.jRSQLExpressionArea1.setVisible(false);
                this.jTextFieldBean.setVisible(true);
                if (this.jTextFieldBean.getText().length() > 0) {
                    canNext = true;
                }
            } else if (irc instanceof JRCSVDataSourceConnection) {
                this.jLabel2.setText(" ");
                this.jTextFieldBean.setVisible(false);
                this.jRSQLExpressionArea1.setVisible(false);
                canNext = true;
            } else if (irc instanceof NullConnection) {
                this.jLabel2.setText(" ");
                this.jTextFieldBean.setVisible(false);
                this.jRSQLExpressionArea1.setVisible(false);
                canNext = true;
            } else {
                this.jLabel2.setText("You can't use the wizard with this kind of datasource");
                this.jRSQLExpressionArea1.setVisible(false);
                this.jTextFieldBean.setVisible(false);
                canNext = false;
            }
        } else {
            this.jLabel2.setText("Please create a new connection / datasource.");
            this.jRSQLExpressionArea1.setVisible(false);
            this.jTextFieldBean.setVisible(false);
        }
        this.jPanel5.setVisible(this.jRSQLExpressionArea1.isVisible());
        if (this.wizardPanel != null) {
            this.wizardPanel.updateButtons();
        }
    }

    private void jRadioButton2jRadioButton1ActionPerformed1(ActionEvent evt) {
    }

    private void jRadioButton2jRadioButton1ItemStateChanged1(ItemEvent evt) {
    }

    private void jRadioButton1ActionPerformed2(ActionEvent evt) {
    }

    private void jRadioButton1ItemStateChanged2(ItemEvent evt) {
    }

    private void jPanel0PropertyChange(PropertyChangeEvent evt) {
    }

    public String[] getStepsNames() {
        String[] names = new String[]{"Query/datasource", "Fields", "Template", "Expression"};
        return names;
    }

    public String getStepDescription(int step) {
        if (step == 0) {
            return "How fill the subreport";
        }
        if (step == 1) {
            return "Select the subreport fields";
        }
        if (step == 2) {
            return "Choose a template";
        }
        if (step == 3) {
            return "Subreport expession";
        }
        return "";
    }

    public void initWizard() {
        this.updateConnections();
    }

    public void finish(int currentStep) {
        if (currentStep < 0 && this.t != null && this.t.isAlive()) {
            this.t.interrupt();
            return;
        }
        if (currentStep >= 0) {
            try {
                Report finalReport = this.createReport(((IReportTemplate)this.jList3.getSelectedValue()).getXmlFile(), this.jRadioButtonColumnarLayout.isSelected() ? 1 : 0);
                if (this.jRadioButton4.isSelected()) {
                    Report report = MainFrame.getMainInstance().getActiveReportFrame().getReport();
                    Vector v = report.getParameters();
                    boolean found = false;
                    for (int i = 0; i < report.getParameters().size(); ++i) {
                        JRParameter param = (JRParameter)report.getParameters().elementAt(i);
                        if (!param.getName().equals("SUBREPORT_DIR")) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        JRParameter param = new JRParameter("SUBREPORT_DIR", "java.lang.String");
                        String s = MainFrame.getMainInstance().getTranslatedCompileDirectory();
                        if (s.length() > 0 && !s.endsWith(File.separator)) {
                            s = s + File.separator;
                        }
                        s = Misc.string_replace("\\\\", "\\", s);
                        s = "\"" + s + "\"";
                        param.setDefaultValueExpression(s);
                        report.addParameter(param);
                    }
                    this.getSubReportElement().setSubreportExpression(this.jLabel1.getText());
                } else {
                    this.getSubReportElement().setSubreportExpression(this.jLabel2e.getText());
                }
                this.getSubReportElement().setSubreportExpressionClass("java.lang.String");
                MainFrame.getMainInstance().openNewReportWindow(finalReport);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.getParent(), ex.getMessage() + "", "Error", 0);
                ex.printStackTrace();
            }
        }
        this.getWizardDialog().setVisible(false);
        this.getWizardDialog().dispose();
    }

    public boolean nextStep(int nextStep) {
        if (nextStep != 0) {
            if (nextStep == 1) {
                this.wizardPanel.getJButtonNext().setEnabled(false);
                this.wizardPanel.getJButtonPrev().setEnabled(false);
                this.wizardPanel.getJButtonFinish().setEnabled(false);
                this.t = new Thread(this);
                this.t.start();
                return false;
            }
            if (nextStep == 2) {
                this.updateExpressionLabels();
            }
        }
        return true;
    }

    public boolean previousStep(int previousStep) {
        return true;
    }

    public boolean canFinish(int currentStep) {
        if (currentStep < 3) {
            return false;
        }
        if (this.jTextFieldReportFileName.getText().trim().length() > 0) {
            String s = this.jTextFieldReportFileName.getText().trim();
            String s2 = MainFrame.getMainInstance().getActiveReportFrame().getReport().getFilename();
            if (s.indexOf(File.separator) >= 0) {
                return !s.equals(s2);
            }
            File f = new File(s2);
            return !f.getName().equals(s);
        }
        return false;
    }

    public boolean canNext(int currentStep) {
        if (currentStep == 0) {
            if (this.jComboBoxConnection.getSelectedItem() != null) {
                IReportConnection irc = (IReportConnection)this.jComboBoxConnection.getSelectedItem();
                if (irc.isJDBCConnection()) {
                    if (this.jRSQLExpressionArea1.getText().length() > 0) {
                        return true;
                    }
                } else if (irc instanceof JRHibernateConnection) {
                    this.jLabel2.setText("HQL query");
                    this.jTextFieldBean.setVisible(false);
                    this.jRSQLExpressionArea1.setVisible(true);
                    if (this.jRSQLExpressionArea1.getText().length() > 0) {
                        return true;
                    }
                } else {
                    if (irc instanceof JRDataSourceProviderConnection) {
                        return true;
                    }
                    if (irc instanceof JavaBeanDataSourceConnection) {
                        if (this.jTextFieldBean.getText().length() > 0) {
                            return true;
                        }
                    } else {
                        if (irc instanceof JRCSVDataSourceConnection) {
                            return true;
                        }
                        return irc instanceof NullConnection;
                    }
                }
            }
            return false;
        }
        if (currentStep == 1) {
            IReportConnection irc = (IReportConnection)this.jComboBoxConnection.getSelectedItem();
            if (irc instanceof NullConnection) {
                return true;
            }
            return this.jList2.getModel().getSize() > 0;
        }
        if (currentStep == 2) {
            return this.jList3.getSelectedIndex() >= 0;
        }
        return false;
    }

    public boolean canPrevious(int currentStep) {
        return currentStep > 0;
    }

    public JPanel getStepPanel(int step) {
        if (step == 0) {
            return this.jPanel0;
        }
        if (step == 1) {
            return this.jPanel1;
        }
        if (step == 2) {
            return this.jPanel2;
        }
        if (step == 3) {
            return this.jPanel3;
        }
        return null;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    public SubReportElement getSubReportElement() {
        return this.subReportElement;
    }

    public void setSubReportElement(SubReportElement subReportElement) {
        this.subReportElement = subReportElement;
    }

    public BaseWizardPanel getWizardPanel() {
        return this.wizardPanel;
    }

    public void setWizardPanel(BaseWizardPanel wizardPanel) {
        this.wizardPanel = wizardPanel;
    }

    public JDialog getWizardDialog() {
        return this.wizardDialog;
    }

    public void setWizardDialog(JDialog wizardDialog) {
        this.wizardDialog = wizardDialog;
    }

    public void run() {
        Thread.currentThread().setContextClassLoader(MainFrame.getMainInstance().getReportClassLoader());
        try {
            IReportConnection irc = (IReportConnection)this.jComboBoxConnection.getSelectedItem();
            DefaultListModel dlm1 = (DefaultListModel)this.jList1.getModel();
            dlm1.removeAllElements();
            DefaultListModel dlm2 = (DefaultListModel)this.jList2.getModel();
            dlm2.removeAllElements();
            List fields = WizardDialog.readFields(irc, this.jRSQLExpressionArea1.getText(), this.jTextFieldBean.getText());
            if (fields == null) {
                this.cancelElaborationStep1();
                return;
            }
            for (int i = 0; i < fields.size(); ++i) {
                JRField field = (JRField)fields.get(i);
                boolean found = false;
                int k = 0;
                while (i < dlm1.size()) {
                    JRField f = (JRField)dlm1.getElementAt(k);
                    if (f.getName().equalsIgnoreCase(field.getName())) {
                        found = true;
                        break;
                    }
                    ++k;
                }
                if (!found) {
                    dlm1.addElement(field);
                }
                if (this.jList1.getModel().getSize() <= 0) continue;
                this.jList1.setSelectedIndex(0);
            }
            this.wizardPanel.goStep(1);
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            JOptionPane.showMessageDialog(this.getParent(), sw.getBuffer() + "", "Error", 0);
            this.cancelElaborationStep1();
            return;
        }
    }

    public void cancelElaborationStep1() {
        this.wizardPanel.updateButtons();
    }

    public void updateTemplatesList() {
        if (this.templates == null) {
            this.loadTemplateFiles();
            if (this.templates == null) {
                return;
            }
        }
        ((DefaultListModel)this.jList3.getModel()).removeAllElements();
        for (int i = 0; i < this.templates.size(); ++i) {
            IReportTemplate itemplate = (IReportTemplate)this.templates.elementAt(i);
            if (this.jRadioButtonTabularLayout.isSelected() && itemplate.getType() != 1 || this.jRadioButtonColumnarLayout.isSelected() && itemplate.getType() != 0) continue;
            ((DefaultListModel)this.jList3.getModel()).addElement(itemplate);
        }
        if (((DefaultListModel)this.jList3.getModel()).getSize() > 0) {
            this.jList3.setSelectedIndex(0);
        }
        this.jList3.updateUI();
    }

    public void loadTemplateFiles() {
        this.templates = new Vector();
        String templates_dir = MainFrame.IREPORT_HOME_DIR;
        templates_dir = templates_dir + File.separator + "templates";
        try {
            File f = new File(templates_dir);
            File[] templates_files = null;
            if (f.exists() && f.isDirectory()) {
                templates_files = f.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith("T.xml") || name.endsWith("C.xml");
                    }
                });
            } else {
                templates_dir = MainFrame.IREPORT_HOME_DIR;
                f = new File(templates_dir = templates_dir + File.separator + "etc" + File.separator + "templates");
                if (f.exists() && f.isDirectory()) {
                    templates_files = f.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith("T.xml") || name.endsWith("C.xml");
                        }
                    });
                }
            }
            for (int i = 0; templates_files != null && i < templates_files.length; ++i) {
                IReportTemplate itemplate = new IReportTemplate();
                itemplate.setXmlFile(templates_files[i] + "");
                itemplate.setName(templates_files[i].getName());
                itemplate.setType(templates_files[i].getName().toLowerCase().endsWith("c.xml") ? 0 : 1);
                try {
                    String iconname = templates_files[i] + "";
                    iconname = Misc.changeFileExtension(iconname, ".gif");
                    itemplate.setIcon(new ImageIcon(iconname));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.templates.add(itemplate);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            Vector<URL> xml_template_files = new Vector<URL>();
            Enumeration<URL> enum_pl = this.getClass().getClassLoader().getResources("ireport/template.xml");
            while (enum_pl.hasMoreElements()) {
                URL oobj = enum_pl.nextElement();
                xml_template_files.add(oobj);
            }
            for (int i = 0; i < xml_template_files.size(); ++i) {
                Object source = xml_template_files.elementAt(i);
                DOMParser parser = new DOMParser();
                try {
                    parser.setEntityResolver(new EntityResolver(){

                        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                            InputSource inputSource = null;
                            if (systemId != null) {
                                String dtd = null;
                                if (!systemId.equals("http://ireport.sourceforge.net/dtds/iReportTemplate.dtd")) {
                                    return new InputSource(systemId);
                                }
                                dtd = "it/businesslogic/ireport/dtds/iReportTemplate.dtd";
                                ClassLoader classLoader = this.getClass().getClassLoader();
                                InputStream is = classLoader.getResourceAsStream(dtd);
                                if (is != null) {
                                    inputSource = new InputSource(is);
                                }
                            }
                            return inputSource;
                        }
                    });
                    InputStream input_source = null;
                    if (source instanceof File) {
                        input_source = new FileInputStream((File)source);
                    } else if (source instanceof URL) {
                        input_source = ((URL)source).openStream();
                    }
                    parser.parse(new InputSource(input_source));
                    Document document = parser.getDocument();
                    Element node = document.getDocumentElement();
                    NodeList list = XPathAPI.selectNodeList((Node)node, (String)"/iReportTemplateSet/iReportTemplate");
                    Node childnode = null;
                    for (int n = 0; n < list.getLength(); ++n) {
                        IReportTemplate ireportTemplate = new IReportTemplate();
                        childnode = XPathAPI.selectSingleNode((Node)list.item(n), (String)"@name");
                        if (childnode != null) {
                            ireportTemplate.setName(childnode.getNodeValue());
                        }
                        if (XPathAPI.eval((Node)list.item(n), (String)"@type = 'Tabular'").equals((XObject)XBoolean.S_TRUE)) {
                            ireportTemplate.setType(1);
                        } else {
                            ireportTemplate.setType(0);
                        }
                        childnode = XPathAPI.selectSingleNode((Node)list.item(n), (String)"XmlFile/text()");
                        if (childnode != null) {
                            ireportTemplate.setXmlFile(childnode.getNodeValue());
                        }
                        if ((childnode = XPathAPI.selectSingleNode((Node)list.item(n), (String)"IconFile/text()")) != null) {
                            try {
                                ireportTemplate.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(childnode.getNodeValue())));
                            }
                            catch (DOMException e) {
                                e.printStackTrace();
                            }
                        }
                        this.templates.add(ireportTemplate);
                    }
                    continue;
                }
                catch (SAXException e) {
                    System.err.println(e);
                    continue;
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }
        catch (Exception ex) {
            MainFrame.getMainInstance().logOnConsole("Error searching ireport/template.xml resources\n");
        }
    }

    public void updateExpressionLabels() {
        String fileName = this.jTextFieldReportFileName.getText().trim();
        if (fileName.length() == 0) {
            this.jLabel1.setText("");
            this.jLabel2e.setText("");
        } else {
            File f = new File(fileName);
            String s = f.getName();
            if (!s.toLowerCase().endsWith(".jasper")) {
                if (s.lastIndexOf(".") > 0) {
                    s = s.substring(0, s.lastIndexOf("."));
                }
                s = s + ".jasper";
            }
            this.jLabel1.setText("$P{SUBREPORT_DIR} + \"" + s + "\"");
            String s2 = MainFrame.getMainInstance().getTranslatedCompileDirectory();
            f = new File(fileName);
            f = new File(s2, Misc.string_replace(".jasper", ".jrxml", f.getName()));
            s2 = Misc.string_replace("\\\\", "\\", "" + f);
            this.jLabel2e.setText("\"" + s2 + "\"");
        }
    }

    public Report createReport(String templateFileName, int reportType) throws Exception {
        int fwidth;
        int nfields;
        TextFieldReportElement detailField;
        StaticTextReportElement detailLabel;
        int currenty;
        int currentx;
        Report template = new Report(templateFileName);
        template.incrementReportChanges();
        String s = this.jTextFieldReportFileName.getText().trim();
        String s2 = MainFrame.getMainInstance().getActiveReportFrame().getReport().getFilename();
        if (s.indexOf(File.separator) >= 0) {
            template.setFilename(s);
        } else {
            File f = new File(s2);
            if ((s2 = f.getParent()).length() > 0 && !s2.endsWith(File.separator)) {
                s2 = s2 + File.separator;
            }
            s2 = s2 + s;
            template.setFilename(s2);
        }
        Band detail = null;
        Band columns = null;
        Enumeration e = template.getBands().elements();
        while (e.hasMoreElements()) {
            Band band = (Band)e.nextElement();
            if (band.getName().equals("detail")) {
                detail = band;
                continue;
            }
            if (!band.getName().equals("columnHeader")) continue;
            columns = band;
        }
        e = template.getElements().elements();
        while (e.hasMoreElements()) {
            ReportElement rElement = (ReportElement)e.nextElement();
            rElement.trasform(new Point(0, -template.getBandYLocation(rElement.getBand())), TransformationType.TRANSFORMATION_MOVE);
        }
        if (reportType == 0) {
            currentx = template.getLeftMargin() + 10;
            currenty = 10;
            e = template.getElements().elements();
            detailLabel = null;
            detailField = null;
            while (e.hasMoreElements() && (detailLabel == null || detailField == null)) {
                TextFieldReportElement tfre;
                ReportElement rElement = (ReportElement)e.nextElement();
                if (rElement instanceof StaticTextReportElement) {
                    StaticTextReportElement stre = (StaticTextReportElement)rElement;
                    if (!stre.getText().equalsIgnoreCase("DetailLabel")) continue;
                    detailLabel = stre;
                    continue;
                }
                if (!(rElement instanceof TextFieldReportElement) || !(tfre = (TextFieldReportElement)rElement).getText().equalsIgnoreCase("DetailField")) continue;
                detailField = tfre;
            }
            if (detailField != null) {
                template.getElements().removeElement(detailField);
            }
            if (detailLabel != null) {
                template.getElements().removeElement(detailLabel);
            }
            if (detailField == null) {
                detailField = new TextFieldReportElement(0, 0, 100, 20);
            }
            if (detailLabel == null) {
                detailLabel = new StaticTextReportElement(0, 0, 100, 18);
            }
            nfields = this.jList2.getModel().getSize();
            fwidth = template.getColumnWidth() / (nfields <= 0 ? 1 : nfields);
            for (int i = 0; i < this.jList2.getModel().getSize(); ++i) {
                JRField f = (JRField)this.jList2.getModel().getElementAt(i);
                template.addField(f);
                TextFieldReportElement re = (TextFieldReportElement)detailField.cloneMe();
                re.setPosition(new Point(currentx, detailField.getPosition().y));
                re.setWidth(fwidth);
                re.updateBounds();
                re.setText("$F{" + f.getName() + "}");
                re.setBand(detail);
                re.setMatchingClassExpression(f.getClassType(), true);
                template.getElements().addElement(re);
                StaticTextReportElement sre = (StaticTextReportElement)detailLabel.cloneMe();
                sre.setPosition(new Point(currentx, detailLabel.getPosition().y));
                sre.setWidth(fwidth);
                sre.updateBounds();
                sre.setText("" + f.getName() + "");
                sre.setBand(columns);
                template.getElements().addElement(sre);
                currentx += fwidth;
                currentx = Math.min(template.getWidth() - template.getRightMargin() + 10 - 30, currentx);
            }
        } else {
            currentx = template.getLeftMargin() + 10;
            currenty = 10;
            e = template.getElements().elements();
            detailLabel = null;
            detailField = null;
            while (e.hasMoreElements() && (detailLabel == null || detailField == null)) {
                TextFieldReportElement tfre;
                ReportElement rElement = (ReportElement)e.nextElement();
                if (rElement instanceof StaticTextReportElement) {
                    StaticTextReportElement stre = (StaticTextReportElement)rElement;
                    if (!stre.getText().equalsIgnoreCase("DetailLabel")) continue;
                    detailLabel = stre;
                    continue;
                }
                if (!(rElement instanceof TextFieldReportElement) || !(tfre = (TextFieldReportElement)rElement).getText().equalsIgnoreCase("DetailField")) continue;
                detailField = tfre;
            }
            if (detailField != null) {
                template.getElements().removeElement(detailField);
            }
            if (detailLabel != null) {
                template.getElements().removeElement(detailLabel);
            }
            if (detailField == null) {
                detailField = new TextFieldReportElement(0, 0, 100, 20);
            }
            if (detailLabel == null) {
                detailLabel = new StaticTextReportElement(0, 0, 100, 18);
            }
            nfields = this.jList2.getModel().getSize();
            fwidth = template.getColumnWidth() / (nfields <= 0 ? 1 : nfields);
            int ffheight = detailField.getPosition().y;
            for (int i = 0; i < this.jList2.getModel().getSize(); ++i) {
                JRField f = (JRField)this.jList2.getModel().getElementAt(i);
                template.addField(f);
                TextFieldReportElement re = (TextFieldReportElement)detailField.cloneMe();
                re.setPosition(new Point(detailField.getPosition().x, ffheight));
                re.updateBounds();
                re.setText("$F{" + f.getName() + "}");
                re.setBand(detail);
                re.setMatchingClassExpression(f.getClassType(), true);
                template.getElements().addElement(re);
                StaticTextReportElement sre = (StaticTextReportElement)detailLabel.cloneMe();
                sre.setPosition(new Point(detailLabel.getPosition().x, ffheight));
                sre.setWidth(fwidth);
                sre.updateBounds();
                sre.setText("" + f.getName() + "");
                sre.setBand(detail);
                template.getElements().addElement(sre);
                ffheight += detailField.position.y + detailField.height - 10;
            }
            if (nfields != 0) {
                detail.setHeight(ffheight);
            }
        }
        e = template.getElements().elements();
        Vector<ReportElement> elements_to_delete = new Vector<ReportElement>();
        while (e.hasMoreElements()) {
            ReportElement rElement = (ReportElement)e.nextElement();
            if (rElement.getBand() == detail || rElement.getBand() == columns) continue;
            elements_to_delete.addElement(rElement);
        }
        e = elements_to_delete.elements();
        while (e.hasMoreElements()) {
            template.getElements().removeElement(e.nextElement());
        }
        Group g = template.getGroupByName("Group1");
        if (g != null) {
            template.getBands().removeElement(g.getGroupFooter());
            template.getBands().removeElement(g.getGroupHeader());
            template.getGroups().removeElement(g);
        }
        if ((g = template.getGroupByName("Group2")) != null) {
            template.getBands().removeElement(g.getGroupFooter());
            template.getBands().removeElement(g.getGroupHeader());
            template.getGroups().removeElement(g);
        }
        if ((g = template.getGroupByName("Group3")) != null) {
            template.getBands().removeElement(g.getGroupFooter());
            template.getBands().removeElement(g.getGroupHeader());
            template.getGroups().removeElement(g);
        }
        if ((g = template.getGroupByName("Group4")) != null) {
            template.getBands().removeElement(g.getGroupFooter());
            template.getBands().removeElement(g.getGroupHeader());
            template.getGroups().removeElement(g);
        }
        e = template.getBands().elements();
        while (e.hasMoreElements()) {
            Band band = (Band)e.nextElement();
            if (band == detail || band == columns) continue;
            band.setHeight(0);
        }
        int leftMargin = template.getLeftMargin();
        template.setWidth(template.getWidth() - template.getLeftMargin() - template.getRightMargin());
        template.setLeftMargin(0);
        template.setRightMargin(0);
        template.setHeight(template.getHeight() - template.getTopMargin() - template.getBottomMargin());
        template.setTopMargin(0);
        template.setBottomMargin(0);
        e = template.getElements().elements();
        while (e.hasMoreElements()) {
            ReportElement rElement = (ReportElement)e.nextElement();
            rElement.trasform(new Point(-leftMargin, template.getBandYLocation(rElement.getBand())), TransformationType.TRANSFORMATION_MOVE);
        }
        if (this.jComboBoxConnection.getSelectedItem() instanceof JDBCConnection) {
            this.getSubReportElement().setConnectionExpression("$P{REPORT_CONNECTION}");
            this.getSubReportElement().setUseConnection(true);
            template.setQuery(this.jRSQLExpressionArea1.getText());
        } else if (this.jComboBoxConnection.getSelectedItem() instanceof JRHibernateConnection) {
            template.setQuery(this.jRSQLExpressionArea1.getText());
            template.setQueryLanguage("hql");
        } else if (this.jComboBoxConnection.getSelectedItem() instanceof NullConnection) {
            template.setWhenNoDataType("AllSectionsNoDetail");
        }
        template.saveXMLFile();
        return template;
    }
}

