/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRAnchor;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;

public class JRExpressionCollector {
    private final JRReport report;
    private final JRExpressionCollector parent;
    private Map expressionIds;
    private GeneratedIds generatedIds = new GeneratedIds();
    private Map crosstabIds = new HashMap();
    private Map datasetCollectors;
    private Map crosstabCollectors;
    private final Set collectedStyles;

    public static JRExpressionCollector collector(JRReport report) {
        JRExpressionCollector collector = new JRExpressionCollector(null, report);
        collector.collect();
        return collector;
    }

    public static List collectExpressions(JRReport report) {
        return JRExpressionCollector.collector(report).getExpressions();
    }

    public static JRExpressionCollector collector(JRReport report, JRCrosstab crosstab) {
        JRExpressionCollector collector = new JRExpressionCollector(null, report);
        collector.collect(crosstab);
        return collector;
    }

    public static List collectExpressions(JRReport report, JRCrosstab crosstab) {
        return JRExpressionCollector.collector(report, crosstab).getExpressions(crosstab);
    }

    protected JRExpressionCollector(JRExpressionCollector parent, JRReport report) {
        this.parent = parent;
        this.report = report;
        if (parent == null) {
            this.expressionIds = new HashMap();
            this.datasetCollectors = new HashMap();
            this.crosstabCollectors = new HashMap();
        }
        this.collectedStyles = new HashSet();
    }

    private void addExpression(JRExpression expression) {
        if (expression != null) {
            Integer id = this.getGlobalGeneratedId(expression);
            if (id == null) {
                id = this.generatedIds.nextId();
                this.setGlobalGeneratedId(expression, id);
                this.generatedIds.put(id, expression);
            } else {
                JRExpression existingExpression = this.generatedIds.put(id, expression);
                if (existingExpression != null && !existingExpression.equals(expression)) {
                    Integer newId = this.generatedIds.nextId();
                    this.updateGlobalGeneratedId(existingExpression, id, newId);
                    this.generatedIds.put(newId, existingExpression);
                }
            }
        }
    }

    private Integer getGlobalGeneratedId(JRExpression expression) {
        Integer generatedId = this.parent == null ? (Integer)this.expressionIds.get(expression) : this.parent.getGlobalGeneratedId(expression);
        return generatedId;
    }

    private void setGlobalGeneratedId(JRExpression expression, Integer id) {
        if (this.parent == null) {
            Integer existingId = this.expressionIds.put(expression, id);
            if (existingId != null && !((Object)existingId).equals(id)) {
                throw new JRRuntimeException("Expression \"" + expression.getText() + "\" has two generated IDs");
            }
        } else {
            this.parent.setGlobalGeneratedId(expression, id);
        }
    }

    private void updateGlobalGeneratedId(JRExpression expression, Integer currentId, Integer newId) {
        if (this.parent == null) {
            Integer existingId = this.expressionIds.put(expression, newId);
            if (existingId == null || !((Object)existingId).equals(currentId)) {
                throw new JRRuntimeException("Expression \"" + expression.getText() + "\" not found with id " + currentId);
            }
        } else {
            this.parent.updateGlobalGeneratedId(expression, currentId, newId);
        }
    }

    private JRExpressionCollector getCollector(JRElementDataset elementDataset) {
        JRDatasetRun datasetRun = elementDataset.getDatasetRun();
        JRExpressionCollector collector = datasetRun == null ? this : this.getDatasetCollector(datasetRun.getDatasetName());
        return collector;
    }

    private JRExpressionCollector getDatasetCollector(String datasetName) {
        JRExpressionCollector collector = (JRExpressionCollector)this.datasetCollectors.get(datasetName);
        if (collector == null) {
            collector = new JRExpressionCollector(this, this.report);
            this.datasetCollectors.put(datasetName, collector);
        }
        return collector;
    }

    private JRExpressionCollector getCollector(JRDataset dataset) {
        JRExpressionCollector collector = dataset.isMainDataset() || this.datasetCollectors == null ? this : this.getDatasetCollector(dataset.getName());
        return collector;
    }

    private JRExpressionCollector getCollector(JRCrosstab crosstab) {
        JRExpressionCollector collector = (JRExpressionCollector)this.crosstabCollectors.get(crosstab);
        if (collector == null) {
            collector = new JRExpressionCollector(this, this.report);
            this.crosstabCollectors.put(crosstab, collector);
        }
        return collector;
    }

    public List getExpressions() {
        return new ArrayList(this.generatedIds.expressions());
    }

    public List getExpressions(JRDataset dataset) {
        return this.getCollector(dataset).getExpressions();
    }

    public List getExpressions(JRCrosstab crosstab) {
        return this.getCollector(crosstab).getExpressions();
    }

    public Integer getExpressionId(JRExpression expression) {
        return (Integer)this.expressionIds.get(expression);
    }

    public Integer getCrosstabId(JRCrosstab crosstab) {
        return (Integer)this.crosstabIds.get(crosstab);
    }

    public Collection collect() {
        this.collect(this.report.getDefaultStyle());
        this.collect(this.report.getMainDataset());
        JRDataset[] datasets = this.report.getDatasets();
        if (datasets != null && datasets.length > 0) {
            for (int i = 0; i < datasets.length; ++i) {
                JRExpressionCollector collector = this.getCollector(datasets[i]);
                collector.collect(datasets[i]);
            }
        }
        this.collect(this.report.getBackground());
        this.collect(this.report.getTitle());
        this.collect(this.report.getPageHeader());
        this.collect(this.report.getColumnHeader());
        this.collect(this.report.getDetail());
        this.collect(this.report.getColumnFooter());
        this.collect(this.report.getPageFooter());
        this.collect(this.report.getLastPageFooter());
        this.collect(this.report.getSummary());
        return this.getExpressions();
    }

    private void collect(JRStyle style) {
        if (style != null && this.collectedStyles.add(style)) {
            JRConditionalStyle[] conditionalStyles = style.getConditionalStyles();
            if (conditionalStyles != null && conditionalStyles.length > 0) {
                for (int i = 0; i < conditionalStyles.length; ++i) {
                    this.addExpression(conditionalStyles[i].getConditionExpression());
                }
            }
            this.collect(style.getStyle());
        }
    }

    private void collect(JRParameter[] parameters) {
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                this.addExpression(parameters[i].getDefaultValueExpression());
            }
        }
    }

    private void collect(JRVariable[] variables) {
        if (variables != null && variables.length > 0) {
            for (int i = 0; i < variables.length; ++i) {
                JRVariable variable = variables[i];
                this.addExpression(variable.getExpression());
                this.addExpression(variable.getInitialValueExpression());
            }
        }
    }

    private void collect(JRGroup[] groups) {
        if (groups != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                JRGroup group = groups[i];
                this.addExpression(group.getExpression());
                this.collect(group.getGroupHeader());
                this.collect(group.getGroupFooter());
            }
        }
    }

    private void collect(JRBand band) {
        if (band != null) {
            this.addExpression(band.getPrintWhenExpression());
            JRElement[] elements = band.getElements();
            if (elements != null && elements.length > 0) {
                for (int i = 0; i < elements.length; ++i) {
                    elements[i].collectExpressions(this);
                }
            }
        }
    }

    private void collectElement(JRElement element) {
        this.collect(element.getStyle());
        this.addExpression(element.getPrintWhenExpression());
    }

    private void collectAnchor(JRAnchor anchor) {
        this.addExpression(anchor.getAnchorNameExpression());
    }

    private void collectHyperlink(JRHyperlink hyperlink) {
        if (hyperlink != null) {
            this.addExpression(hyperlink.getHyperlinkReferenceExpression());
            this.addExpression(hyperlink.getHyperlinkAnchorExpression());
            this.addExpression(hyperlink.getHyperlinkPageExpression());
            this.addExpression(hyperlink.getHyperlinkTooltipExpression());
            JRHyperlinkParameter[] hyperlinkParameters = hyperlink.getHyperlinkParameters();
            if (hyperlinkParameters != null) {
                for (int i = 0; i < hyperlinkParameters.length; ++i) {
                    JRHyperlinkParameter parameter = hyperlinkParameters[i];
                    this.collectHyperlinkParameter(parameter);
                }
            }
        }
    }

    protected void collectHyperlinkParameter(JRHyperlinkParameter parameter) {
        if (parameter != null) {
            this.addExpression(parameter.getValueExpression());
        }
    }

    public void collect(JRLine line) {
        this.collectElement(line);
    }

    public void collect(JRRectangle rectangle) {
        this.collectElement(rectangle);
    }

    public void collect(JREllipse ellipse) {
        this.collectElement(ellipse);
    }

    public void collect(JRImage image) {
        this.collectElement(image);
        this.addExpression(image.getExpression());
        this.collectAnchor(image);
        this.collectHyperlink(image);
    }

    public void collect(JRStaticText staticText) {
        this.collectElement(staticText);
    }

    public void collect(JRTextField textField) {
        this.collectElement(textField);
        this.addExpression(textField.getExpression());
        this.collectAnchor(textField);
        this.collectHyperlink(textField);
    }

    public void collect(JRSubreport subreport) {
        this.collectElement(subreport);
        this.addExpression(subreport.getParametersMapExpression());
        JRSubreportParameter[] parameters = subreport.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int j = 0; j < parameters.length; ++j) {
                this.addExpression(parameters[j].getExpression());
            }
        }
        this.addExpression(subreport.getConnectionExpression());
        this.addExpression(subreport.getDataSourceExpression());
        this.addExpression(subreport.getExpression());
    }

    public void collect(JRChart chart) {
        this.collectElement(chart);
        this.collectAnchor(chart);
        this.collectHyperlink(chart);
        this.addExpression(chart.getTitleExpression());
        this.addExpression(chart.getSubtitleExpression());
        chart.getDataset().collectExpressions(this);
        chart.getPlot().collectExpressions(this);
    }

    public void collect(JRPieDataset pieDataset) {
        this.collect((JRElementDataset)pieDataset);
        JRExpressionCollector collector = this.getCollector(pieDataset);
        collector.addExpression(pieDataset.getKeyExpression());
        collector.addExpression(pieDataset.getValueExpression());
        collector.addExpression(pieDataset.getLabelExpression());
        collector.collectHyperlink(pieDataset.getSectionHyperlink());
    }

    public void collect(JRCategoryDataset categoryDataset) {
        this.collect((JRElementDataset)categoryDataset);
        JRCategorySeries[] categorySeries = categoryDataset.getSeries();
        if (categorySeries != null && categorySeries.length > 0) {
            JRExpressionCollector collector = this.getCollector(categoryDataset);
            for (int j = 0; j < categorySeries.length; ++j) {
                collector.collect(categorySeries[j]);
            }
        }
    }

    public void collect(JRXyDataset xyDataset) {
        this.collect((JRElementDataset)xyDataset);
        JRXySeries[] xySeries = xyDataset.getSeries();
        if (xySeries != null && xySeries.length > 0) {
            JRExpressionCollector collector = this.getCollector(xyDataset);
            for (int j = 0; j < xySeries.length; ++j) {
                collector.collect(xySeries[j]);
            }
        }
    }

    public void collect(JRTimeSeriesDataset timeSeriesDataset) {
        this.collect((JRElementDataset)timeSeriesDataset);
        JRTimeSeries[] timeSeries = timeSeriesDataset.getSeries();
        if (timeSeries != null && timeSeries.length > 0) {
            JRExpressionCollector collector = this.getCollector(timeSeriesDataset);
            for (int i = 0; i < timeSeries.length; ++i) {
                collector.collect(timeSeries[i]);
            }
        }
    }

    public void collect(JRTimePeriodDataset timePeriodDataset) {
        this.collect((JRElementDataset)timePeriodDataset);
        JRTimePeriodSeries[] timePeriodSeries = timePeriodDataset.getSeries();
        if (timePeriodSeries != null && timePeriodSeries.length > 0) {
            JRExpressionCollector collector = this.getCollector(timePeriodDataset);
            for (int i = 0; i < timePeriodSeries.length; ++i) {
                collector.collect(timePeriodSeries[i]);
            }
        }
    }

    private void collect(JRXySeries xySeries) {
        this.addExpression(xySeries.getSeriesExpression());
        this.addExpression(xySeries.getXValueExpression());
        this.addExpression(xySeries.getYValueExpression());
        this.addExpression(xySeries.getLabelExpression());
        this.collectHyperlink(xySeries.getItemHyperlink());
    }

    private void collect(JRCategorySeries categorySeries) {
        this.addExpression(categorySeries.getSeriesExpression());
        this.addExpression(categorySeries.getCategoryExpression());
        this.addExpression(categorySeries.getValueExpression());
        this.addExpression(categorySeries.getLabelExpression());
        this.collectHyperlink(categorySeries.getItemHyperlink());
    }

    public void collect(JRBarPlot barPlot) {
        this.addExpression(barPlot.getCategoryAxisLabelExpression());
        this.addExpression(barPlot.getValueAxisLabelExpression());
    }

    public void collect(JRBar3DPlot barPlot) {
        this.addExpression(barPlot.getCategoryAxisLabelExpression());
        this.addExpression(barPlot.getValueAxisLabelExpression());
    }

    public void collect(JRLinePlot linePlot) {
        this.addExpression(linePlot.getCategoryAxisLabelExpression());
        this.addExpression(linePlot.getValueAxisLabelExpression());
    }

    public void collect(JRTimeSeriesPlot timeSeriesPlot) {
        this.addExpression(timeSeriesPlot.getTimeAxisLabelExpression());
        this.addExpression(timeSeriesPlot.getValueAxisLabelExpression());
    }

    public void collect(JRScatterPlot scatterPlot) {
        this.addExpression(scatterPlot.getXAxisLabelExpression());
        this.addExpression(scatterPlot.getYAxisLabelExpression());
    }

    public void collect(JRAreaPlot areaPlot) {
        this.addExpression(areaPlot.getCategoryAxisLabelExpression());
        this.addExpression(areaPlot.getValueAxisLabelExpression());
    }

    private void collect(JRTimeSeries timeSeries) {
        this.addExpression(timeSeries.getSeriesExpression());
        this.addExpression(timeSeries.getTimePeriodExpression());
        this.addExpression(timeSeries.getValueExpression());
        this.addExpression(timeSeries.getLabelExpression());
        this.collectHyperlink(timeSeries.getItemHyperlink());
    }

    private void collect(JRTimePeriodSeries timePeriodSeries) {
        this.addExpression(timePeriodSeries.getSeriesExpression());
        this.addExpression(timePeriodSeries.getStartDateExpression());
        this.addExpression(timePeriodSeries.getEndDateExpression());
        this.addExpression(timePeriodSeries.getValueExpression());
        this.addExpression(timePeriodSeries.getLabelExpression());
        this.collectHyperlink(timePeriodSeries.getItemHyperlink());
    }

    public void collect(JRXyzDataset xyzDataset) {
        this.collect((JRElementDataset)xyzDataset);
        JRXyzSeries[] xyzSeries = xyzDataset.getSeries();
        if (xyzSeries != null && xyzSeries.length > 0) {
            JRExpressionCollector collector = this.getCollector(xyzDataset);
            for (int j = 0; j < xyzSeries.length; ++j) {
                collector.collect(xyzSeries[j]);
            }
        }
    }

    private void collect(JRXyzSeries xyzSeries) {
        this.addExpression(xyzSeries.getSeriesExpression());
        this.addExpression(xyzSeries.getXValueExpression());
        this.addExpression(xyzSeries.getYValueExpression());
        this.addExpression(xyzSeries.getZValueExpression());
        this.collectHyperlink(xyzSeries.getItemHyperlink());
    }

    public void collect(JRBubblePlot bubblePlot) {
        this.addExpression(bubblePlot.getXAxisLabelExpression());
        this.addExpression(bubblePlot.getYAxisLabelExpression());
    }

    public void collect(JRHighLowPlot highLowPlot) {
        this.addExpression(highLowPlot.getTimeAxisLabelExpression());
        this.addExpression(highLowPlot.getValueAxisLabelExpression());
    }

    public void collect(JRHighLowDataset highLowDataset) {
        this.collect((JRElementDataset)highLowDataset);
        JRExpressionCollector collector = this.getCollector(highLowDataset);
        collector.addExpression(highLowDataset.getSeriesExpression());
        collector.addExpression(highLowDataset.getDateExpression());
        collector.addExpression(highLowDataset.getHighExpression());
        collector.addExpression(highLowDataset.getLowExpression());
        collector.addExpression(highLowDataset.getOpenExpression());
        collector.addExpression(highLowDataset.getCloseExpression());
        collector.addExpression(highLowDataset.getVolumeExpression());
        collector.collectHyperlink(highLowDataset.getItemHyperlink());
    }

    public void collect(JRCandlestickPlot candlestickPlot) {
        this.addExpression(candlestickPlot.getTimeAxisLabelExpression());
        this.addExpression(candlestickPlot.getValueAxisLabelExpression());
    }

    public void collect(JRCrosstab crosstab) {
        JRCrosstabMeasure[] measures;
        JRCrosstabColumnGroup[] colGroups;
        this.collectElement(crosstab);
        this.createCrosstabId(crosstab);
        JRCrosstabDataset dataset = crosstab.getDataset();
        this.collect(dataset);
        JRExpressionCollector datasetCollector = this.getCollector(dataset);
        JRExpressionCollector crosstabCollector = this.getCollector(crosstab);
        crosstabCollector.collect(this.report.getDefaultStyle());
        this.addExpression(crosstab.getParametersMapExpression());
        JRCrosstabParameter[] parameters = crosstab.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                this.addExpression(parameters[i].getExpression());
            }
        }
        crosstabCollector.collect(crosstab.getHeaderCell());
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        if (rowGroups != null) {
            for (int i = 0; i < rowGroups.length; ++i) {
                JRCrosstabRowGroup rowGroup = rowGroups[i];
                JRCrosstabBucket bucket = rowGroup.getBucket();
                datasetCollector.addExpression(bucket.getExpression());
                this.addExpression(bucket.getComparatorExpression());
                crosstabCollector.collect(rowGroup.getHeader());
                crosstabCollector.collect(rowGroup.getTotalHeader());
            }
        }
        if ((colGroups = crosstab.getColumnGroups()) != null) {
            for (int i = 0; i < colGroups.length; ++i) {
                JRCrosstabColumnGroup columnGroup = colGroups[i];
                datasetCollector.addExpression(columnGroup.getBucket().getExpression());
                this.addExpression(columnGroup.getBucket().getComparatorExpression());
                crosstabCollector.collect(columnGroup.getHeader());
                crosstabCollector.collect(columnGroup.getTotalHeader());
            }
        }
        if ((measures = crosstab.getMeasures()) != null) {
            for (int i = 0; i < measures.length; ++i) {
                datasetCollector.addExpression(measures[i].getValueExpression());
            }
        }
        crosstabCollector.collect(crosstab.getWhenNoDataCell());
        this.collectCrosstabCells(crosstab, crosstabCollector);
    }

    private void createCrosstabId(JRCrosstab crosstab) {
        this.crosstabIds.put(crosstab, new Integer(this.crosstabIds.size()));
    }

    private void collectCrosstabCells(JRCrosstab crosstab, JRExpressionCollector crosstabCollector) {
        block5: {
            block4: {
                if (!(crosstab instanceof JRDesignCrosstab)) break block4;
                List cellsList = ((JRDesignCrosstab)crosstab).getCellsList();
                if (cellsList == null) break block5;
                Iterator iter = cellsList.iterator();
                while (iter.hasNext()) {
                    JRCrosstabCell cell = (JRCrosstabCell)iter.next();
                    crosstabCollector.collect(cell.getContents());
                }
                break block5;
            }
            JRCrosstabCell[][] cells = crosstab.getCells();
            if (cells != null) {
                for (int i = 0; i < cells.length; ++i) {
                    for (int j = 0; j < cells[i].length; ++j) {
                        if (cells[i][j] == null) continue;
                        crosstabCollector.collect(cells[i][j].getContents());
                    }
                }
            }
        }
    }

    public Collection collect(JRDataset dataset) {
        JRExpressionCollector collector = this.getCollector(dataset);
        collector.collect(dataset.getParameters());
        collector.collect(dataset.getVariables());
        collector.collect(dataset.getGroups());
        collector.addExpression(dataset.getFilterExpression());
        return this.getExpressions(dataset);
    }

    protected void collect(JRElementDataset dataset) {
        this.collect(dataset.getDatasetRun());
        JRExpression incrementWhenExpression = dataset.getIncrementWhenExpression();
        if (incrementWhenExpression != null) {
            JRExpressionCollector datasetCollector = this.getCollector(dataset);
            datasetCollector.addExpression(incrementWhenExpression);
        }
    }

    private void collect(JRDatasetRun datasetRun) {
        if (datasetRun != null) {
            this.addExpression(datasetRun.getParametersMapExpression());
            this.addExpression(datasetRun.getConnectionExpression());
            this.addExpression(datasetRun.getDataSourceExpression());
            JRDatasetParameter[] parameters = datasetRun.getParameters();
            if (parameters != null && parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    this.addExpression(parameters[i].getExpression());
                }
            }
        }
    }

    protected void collect(JRCellContents cell) {
        if (cell != null) {
            this.collect(cell.getStyle());
            JRElement[] elements = cell.getElements();
            if (elements != null && elements.length > 0) {
                for (int i = 0; i < elements.length; ++i) {
                    elements[i].collectExpressions(this);
                }
            }
        }
    }

    public void collect(JRFrame frame) {
        this.collectElement(frame);
        JRElement[] elements = frame.getElements();
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                elements[i].collectExpressions(this);
            }
        }
    }

    protected static class GeneratedIds {
        private final TreeMap ids = new TreeMap();
        private int nextId = 0;
        private List expressions;

        protected GeneratedIds() {
        }

        public JRExpression put(Integer id, JRExpression expression) {
            this.expressions = null;
            return this.ids.put(id, expression);
        }

        public Integer nextId() {
            Integer id = new Integer(this.nextId);
            while (this.ids.containsKey(id)) {
                id = new Integer(++this.nextId);
            }
            return id;
        }

        public List expressions() {
            if (this.expressions == null) {
                this.expressions = new ArrayList(this.ids.values());
            }
            return this.expressions;
        }
    }
}

