/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.MemberCache;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;

public class SqlTupleReader
implements TupleReader {
    TupleConstraint constraint;
    List targets = new ArrayList();
    int maxRows = 0;

    public SqlTupleReader(TupleConstraint constraint) {
        this.constraint = constraint;
    }

    public void addLevelMembers(RolapLevel level, TupleReader.MemberBuilder memberBuilder) {
        this.targets.add(new Target(level, memberBuilder));
    }

    public Object getCacheKey() {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(this.constraint.getCacheKey());
        key.add(SqlTupleReader.class);
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            Target t = (Target)it.next();
            key.add(t.getLevel());
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List readTuples(DataSource dataSource) {
        Connection con;
        try {
            con = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "could not connect to DB");
        }
        try {
            List list = this.readTuples(con);
            return list;
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                throw Util.newInternal(e, "could not close connection");
            }
        }
    }

    /*
     * Loose catch block
     */
    public List readTuples(Connection jdbcConnection) {
        int n;
        ResultSet resultSet;
        String sql;
        block19: {
            Object it;
            sql = this.makeLevelMembersSql(jdbcConnection);
            resultSet = null;
            resultSet = RolapUtil.executeQuery(jdbcConnection, sql, this.maxRows, "SqlTupleReader.readTuples " + this.targets);
            Iterator it2 = this.targets.iterator();
            while (it2.hasNext()) {
                ((Target)it2.next()).open();
            }
            int limit = MondrianProperties.instance().ResultLimit.get();
            int nFetch = 0;
            while (resultSet.next()) {
                if (limit > 0 && limit < ++nFetch) {
                    throw MondrianResource.instance().MemberFetchLimitExceeded.ex(new Long(limit));
                }
                int column = 0;
                it = this.targets.iterator();
                while (it.hasNext()) {
                    Target t = (Target)it.next();
                    column = t.addRow(resultSet, column);
                }
            }
            n = this.targets.size();
            if (n != 1) break block19;
            it = ((Target)this.targets.get(0)).close();
            Object var12_11 = null;
            try {
                if (resultSet != null) {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            return it;
        }
        ArrayList<RolapMember[]> tupleList = new ArrayList<RolapMember[]>();
        Iterator[] iter = new Iterator[n];
        for (int i = 0; i < n; ++i) {
            Target t = (Target)this.targets.get(i);
            iter[i] = t.close().iterator();
        }
        while (iter[0].hasNext()) {
            RolapMember[] tuples = new RolapMember[n];
            for (int i = 0; i < n; ++i) {
                tuples[i] = (RolapMember)iter[i].next();
            }
            tupleList.add(tuples);
        }
        ArrayList<RolapMember[]> arrayList = tupleList;
        Object var12_12 = null;
        try {
            if (resultSet != null) {
                resultSet.getStatement().close();
                resultSet.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        return arrayList;
        catch (Throwable e) {
            try {
                throw Util.newInternal(e, "while populating member cache with members for " + this.targets + "'; sql=[" + sql + "]");
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (SQLException e2) {}
                throw throwable;
            }
        }
    }

    String makeLevelMembersSql(Connection jdbcConnection) {
        String s = "while generating query to retrieve members of level(s) " + this.targets;
        SqlQuery sqlQuery = SqlTupleReader.newQuery(jdbcConnection, s);
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            Target t = (Target)it.next();
            this.addLevelMemberSql(sqlQuery, t.getLevel());
        }
        this.constraint.addConstraint(sqlQuery);
        return sqlQuery.toString();
    }

    void addLevelMemberSql(SqlQuery sqlQuery, RolapLevel level) {
        RolapHierarchy hierarchy = (RolapHierarchy)level.getHierarchy();
        RolapLevel[] levels = (RolapLevel[])hierarchy.getLevels();
        int levelDepth = level.getDepth();
        for (int i = 0; i <= levelDepth; ++i) {
            RolapLevel level2 = levels[i];
            if (level2.isAll()) continue;
            hierarchy.addToFrom(sqlQuery, level2.getKeyExp());
            String keySql = level2.getKeyExp().getExpression(sqlQuery);
            sqlQuery.addSelect(keySql);
            sqlQuery.addGroupBy(keySql);
            hierarchy.addToFrom(sqlQuery, level2.getOrdinalExp());
            this.constraint.addLevelConstraint(sqlQuery, level2);
            if (level2.hasCaptionColumn()) {
                MondrianDef.Expression captionExp = level2.getCaptionExp();
                hierarchy.addToFrom(sqlQuery, captionExp);
                String captionSql = captionExp.getExpression(sqlQuery);
                sqlQuery.addSelect(captionSql);
                sqlQuery.addGroupBy(captionSql);
            }
            String ordinalSql = level2.getOrdinalExp().getExpression(sqlQuery);
            sqlQuery.addGroupBy(ordinalSql);
            sqlQuery.addOrderBy(ordinalSql, true, false);
            RolapProperty[] properties = level2.getRolapProperties();
            for (int j = 0; j < properties.length; ++j) {
                RolapProperty property = properties[j];
                String propSql = property.getExp().getExpression(sqlQuery);
                sqlQuery.addSelect(propSql);
                sqlQuery.addGroupBy(propSql);
            }
        }
    }

    static SqlQuery newQuery(Connection jdbcConnection, String err) {
        try {
            return new SqlQuery(jdbcConnection.getMetaData());
        }
        catch (SQLException e) {
            throw Util.newInternal(e, err);
        }
    }

    int getMaxRows() {
        return this.maxRows;
    }

    void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    private class Target {
        RolapLevel level;
        RolapMember allMember;
        MemberCache cache;
        RolapLevel[] levels;
        RolapHierarchy hierarchy;
        List list;
        int levelDepth;
        boolean parentChild;
        RolapMember[] members;
        List[] siblings;
        TupleReader.MemberBuilder memberBuilder;

        public Target(RolapLevel level, TupleReader.MemberBuilder memberBuilder) {
            this.level = level;
            this.allMember = memberBuilder.getAllMember();
            this.cache = memberBuilder.getMemberCache();
            this.memberBuilder = memberBuilder;
        }

        public void open() {
            this.hierarchy = (RolapHierarchy)this.level.getHierarchy();
            this.levels = (RolapLevel[])this.hierarchy.getLevels();
            this.list = new ArrayList();
            this.levelDepth = this.level.getDepth();
            this.parentChild = this.level.getParentExp() != null;
            this.members = new RolapMember[this.levels.length];
            this.siblings = new ArrayList[this.levels.length + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int addRow(ResultSet resultSet, int column) throws SQLException {
            MemberCache memberCache = this.cache;
            synchronized (memberCache) {
                return this.internalAddRow(resultSet, column);
            }
        }

        private int internalAddRow(ResultSet resultSet, int column) throws SQLException {
            RolapMember member = null;
            for (int i = 0; i <= this.levelDepth; ++i) {
                MemberChildrenConstraint mcc;
                Object value;
                RolapLevel childLevel = this.levels[i];
                if (childLevel.isAll()) {
                    member = this.allMember;
                    continue;
                }
                if ((value = resultSet.getObject(++column)) == null) {
                    value = RolapUtil.sqlNullValue;
                }
                Object captionValue = childLevel.hasCaptionColumn() ? resultSet.getObject(++column) : null;
                RolapMember parentMember = member;
                Object key = this.cache.makeKey(parentMember, value);
                if ((member = this.cache.getMember(key)) == null) {
                    member = this.memberBuilder.makeMember(parentMember, childLevel, value, captionValue, this.parentChild, resultSet, key, column);
                }
                column += childLevel.getProperties().length;
                if (member == this.members[i]) continue;
                List children = this.siblings[i + 1];
                if (children != null && (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(this.members[i])) != null) {
                    this.cache.putChildren(this.members[i], mcc, children);
                }
                mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member);
                List cachedChildren = this.cache.getChildrenFromCache(member, mcc);
                this.siblings[i + 1] = i < this.levelDepth && cachedChildren == null ? new ArrayList() : null;
                this.members[i] = member;
                if (this.siblings[i] == null) continue;
                if (value == RolapUtil.sqlNullValue) {
                    this.addAsOldestSibling(this.siblings[i], member);
                    continue;
                }
                this.siblings[i].add(member);
            }
            this.list.add(member);
            return column;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List close() {
            MemberCache memberCache = this.cache;
            synchronized (memberCache) {
                return this.internalClose();
            }
        }

        public List internalClose() {
            for (int i = 0; i < this.members.length; ++i) {
                MemberChildrenConstraint mcc;
                RolapMember member = this.members[i];
                List children = this.siblings[i + 1];
                if (member == null || children == null || (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member)) == null) continue;
                this.cache.putChildren(member, mcc, children);
            }
            return this.list;
        }

        private void addAsOldestSibling(List list, RolapMember member) {
            RolapMember sibling;
            int i = list.size();
            while (--i >= 0 && (sibling = (RolapMember)list.get(i)).getParentMember() == member.getParentMember()) {
            }
            list.add(i + 1, member);
        }

        public RolapLevel getLevel() {
            return this.level;
        }

        public String toString() {
            return this.level.getUniqueName();
        }
    }
}

