/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class FooterRecord
extends Record {
    public static final short sid = 21;
    private byte field_1_footer_len;
    private String field_2_footer;

    public FooterRecord() {
    }

    public FooterRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public FooterRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 21) {
            throw new RecordFormatException("NOT A FooterRECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        if (size > 0) {
            this.field_1_footer_len = data[0 + offset];
            this.field_2_footer = StringUtil.getFromCompressedUnicode(data, 3 + offset, LittleEndian.ubyteToInt(this.field_1_footer_len));
        }
    }

    public void setFooterLength(byte len) {
        this.field_1_footer_len = len;
    }

    public void setFooter(String footer) {
        this.field_2_footer = footer;
    }

    public short getFooterLength() {
        return (short)(0xFF & this.field_1_footer_len);
    }

    public String getFooter() {
        return this.field_2_footer;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FOOTER]\n");
        buffer.append("    .footerlen      = ").append(Integer.toHexString(this.getFooterLength())).append("\n");
        buffer.append("    .footer         = ").append(this.getFooter()).append("\n");
        buffer.append("[/FOOTER]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int len = 4;
        if (this.getFooterLength() > 0) {
            len += 3;
        }
        LittleEndian.putShort(data, 0 + offset, (short)21);
        LittleEndian.putShort(data, 2 + offset, (short)(len - 4 + this.getFooterLength()));
        if (this.getFooterLength() > 0) {
            data[4 + offset] = (byte)this.getFooterLength();
            StringUtil.putCompressedUnicode(this.getFooter(), data, 7 + offset);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int retval = 4;
        if (this.getFooterLength() > 0) {
            retval += 3;
        }
        return retval + this.getFooterLength();
    }

    public short getSid() {
        return 21;
    }

    public Object clone() {
        FooterRecord rec = new FooterRecord();
        rec.field_1_footer_len = this.field_1_footer_len;
        rec.field_2_footer = this.field_2_footer;
        return rec;
    }
}

