/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRJdbcQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$query$JRJdbcQueryExecuter == null ? (class$net$sf$jasperreports$engine$query$JRJdbcQueryExecuter = JRJdbcQueryExecuter.class$("net.sf.jasperreports.engine.query.JRJdbcQueryExecuter")) : class$net$sf$jasperreports$engine$query$JRJdbcQueryExecuter));
    private Connection connection = (Connection)this.getParameterValue("REPORT_CONNECTION");
    private PreparedStatement statement;
    private ResultSet resultSet;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$query$JRJdbcQueryExecuter;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;

    public JRJdbcQueryExecuter(JRDataset dataset, Map parameters) {
        super(dataset, parameters);
        if (this.connection == null && log.isWarnEnabled()) {
            log.warn((Object)"The supplied java.sql.Connection object is null.");
        }
        this.parseQuery();
    }

    protected String getParameterReplacement(String parameterName) {
        return "?";
    }

    public JRDataSource createDatasource() throws JRException {
        JRResultSetDataSource dataSource = null;
        this.createStatement();
        if (this.statement != null) {
            try {
                Integer reportMaxCount = (Integer)this.getParameterValue("REPORT_MAX_COUNT");
                if (reportMaxCount != null) {
                    this.statement.setMaxRows(reportMaxCount);
                }
                this.resultSet = this.statement.executeQuery();
                dataSource = new JRResultSetDataSource(this.resultSet);
            }
            catch (SQLException e) {
                throw new JRException("Error executing SQL statement for : " + this.dataset.getName(), e);
            }
        }
        return dataSource;
    }

    private void createStatement() throws JRException {
        String queryString = this.getQueryString();
        if (this.connection != null && queryString != null && queryString.trim().length() > 0) {
            try {
                List parameterNames;
                this.statement = this.connection.prepareStatement(queryString);
                int fetchSize = JRProperties.getIntegerProperty(this.dataset.getPropertiesMap(), "net.sf.jasperreports.jdbc.fetch.size", 0);
                if (fetchSize > 0) {
                    this.statement.setFetchSize(fetchSize);
                }
                if (!(parameterNames = this.getCollectedParameterNames()).isEmpty()) {
                    for (int i = 0; i < parameterNames.size(); ++i) {
                        String parameterName = (String)parameterNames.get(i);
                        JRValueParameter parameter = this.getValueParameter(parameterName);
                        Class clazz = parameter.getValueClass();
                        Object parameterValue = parameter.getValue();
                        if (clazz.equals(class$java$lang$Object == null ? JRJdbcQueryExecuter.class$("java.lang.Object") : class$java$lang$Object)) {
                            if (parameterValue == null) {
                                this.statement.setNull(i + 1, 2000);
                                continue;
                            }
                            this.statement.setObject(i + 1, parameterValue);
                            continue;
                        }
                        if (clazz.equals(class$java$lang$Boolean == null ? JRJdbcQueryExecuter.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                            if (parameterValue == null) {
                                this.statement.setNull(i + 1, -7);
                                continue;
                            }
                            this.statement.setBoolean(i + 1, (Boolean)parameterValue);
                            continue;
                        }
                        if (clazz.equals(class$java$lang$Byte == null ? JRJdbcQueryExecuter.class$("java.lang.Byte") : class$java$lang$Byte)) {
                            if (parameterValue == null) {
                                this.statement.setNull(i + 1, -6);
                                continue;
                            }
                            this.statement.setByte(i + 1, (Byte)parameterValue);
                            continue;
                        }
                        if (clazz.equals(class$java$lang$Double == null ? JRJdbcQueryExecuter.class$("java.lang.Double") : class$java$lang$Double)) {
                            if (parameterValue == null) {
                                this.statement.setNull(i + 1, 8);
                                continue;
                            }
                            this.statement.setDouble(i + 1, (Double)parameterValue);
                            continue;
                        }
                        if (clazz.equals(class$java$lang$Float == null ? JRJdbcQueryExecuter.class$("java.lang.Float") : class$java$lang$Float)) {
                            if (parameterValue == null) {
                                this.statement.setNull(i + 1, 6);
                                continue;
                            }
                            this.statement.setFloat(i + 1, ((Float)parameterValue).floatValue());
                            continue;
                        }
                        if (clazz.equals(class$java$lang$Integer == null ? JRJdbcQueryExecuter.class$("java.lang.Integer") : class$java$lang$Integer)) {
                            if (parameterValue == null) {
                                this.statement.setNull(i + 1, 4);
                                continue;
                            }
                            this.statement.setInt(i + 1, (Integer)parameterValue);
                            continue;
                        }
                        if (clazz.equals(class$java$lang$Long == null ? JRJdbcQueryExecuter.class$("java.lang.Long") : class$java$lang$Long)) {
                            if (parameterValue == null) {
                                this.statement.setNull(i + 1, -5);
                                continue;
                            }
                            this.statement.setLong(i + 1, (Long)parameterValue);
                            continue;
                        }
                        if (clazz.equals(class$java$lang$Short == null ? JRJdbcQueryExecuter.class$("java.lang.Short") : class$java$lang$Short)) {
                            if (parameterValue == null) {
                                this.statement.setNull(i + 1, 5);
                                continue;
                            }
                            this.statement.setShort(i + 1, (Short)parameterValue);
                            continue;
                        }
                        if (clazz.equals(class$java$math$BigDecimal == null ? JRJdbcQueryExecuter.class$("java.math.BigDecimal") : class$java$math$BigDecimal)) {
                            if (parameterValue == null) {
                                this.statement.setNull(i + 1, 3);
                                continue;
                            }
                            this.statement.setBigDecimal(i + 1, (BigDecimal)parameterValue);
                            continue;
                        }
                        if (clazz.equals(class$java$lang$String == null ? JRJdbcQueryExecuter.class$("java.lang.String") : class$java$lang$String)) {
                            if (parameterValue == null) {
                                this.statement.setNull(i + 1, 12);
                                continue;
                            }
                            this.statement.setString(i + 1, parameterValue.toString());
                            continue;
                        }
                        if (clazz.equals(class$java$util$Date == null ? JRJdbcQueryExecuter.class$("java.util.Date") : class$java$util$Date)) {
                            if (parameterValue == null) {
                                this.statement.setNull(i + 1, 91);
                                continue;
                            }
                            this.statement.setDate(i + 1, new Date(((java.util.Date)parameterValue).getTime()));
                            continue;
                        }
                        if (clazz.equals(class$java$sql$Timestamp == null ? JRJdbcQueryExecuter.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) {
                            if (parameterValue == null) {
                                this.statement.setNull(i + 1, 93);
                                continue;
                            }
                            this.statement.setTimestamp(i + 1, (Timestamp)parameterValue);
                            continue;
                        }
                        if (clazz.equals(class$java$sql$Time == null ? JRJdbcQueryExecuter.class$("java.sql.Time") : class$java$sql$Time)) {
                            if (parameterValue == null) {
                                this.statement.setNull(i + 1, 92);
                                continue;
                            }
                            this.statement.setTime(i + 1, (Time)parameterValue);
                            continue;
                        }
                        throw new JRException("Parameter type not supported in query : " + parameterName + " class " + clazz.getName());
                    }
                }
            }
            catch (SQLException e) {
                throw new JRException("Error preparing statement for executing the report query : \n\n" + queryString + "\n\n", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error while closing result set.", (Throwable)e);
            }
            finally {
                this.resultSet = null;
            }
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error while closing statement.", (Throwable)e);
            }
            finally {
                this.statement = null;
            }
        }
    }

    public synchronized boolean cancelQuery() throws JRException {
        if (this.statement != null) {
            try {
                this.statement.cancel();
                return true;
            }
            catch (Throwable t) {
                throw new JRException("Error cancelling SQL statement", t);
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

