/*
 * Group.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 *  Created on 10 maggio 2003, 14.21
 */

package it.businesslogic.ireport;

public class Group
{
	private SubDataset parent;
	private String name;
	private String groupExpression;
	private boolean isStartNewColumn=false;
	private boolean isStartNewPage=false;
	private boolean isResetPageNumber=false;
	private boolean isReprintHeaderOnEachPage=false;
	private int minHeightToStartNewPage=0;
	
	private Band groupHeader=null;
	private Band groupFooter=null;

	public Group(SubDataset parent, String name)
	{
		this(parent, name, 0, 0);
	}
	
	public Group(SubDataset parent, String name, int headerHeight, int footerHeight)
	{
		this.parent = parent;		 
		this.name = name;
                if (parent instanceof Report)
                {
                    groupFooter = new Band((Report)parent, name+"Footer", headerHeight);
                    groupHeader = new Band((Report)parent, name+"Header", footerHeight);
                }
	}
        
        /** Getter for property groupExpression.
         * @return Value of property groupExpression.
         *
         */
        public java.lang.String getGroupExpression() {
            return groupExpression;
        }
        
        /** Setter for property groupExpression.
         * @param groupExpression New value of property groupExpression.
         *
         */
        public void setGroupExpression(java.lang.String groupExpression) {
            this.groupExpression = groupExpression;
        }
        
        /** Getter for property groupFooter.
         * @return Value of property groupFooter.
         *
         */
        public it.businesslogic.ireport.Band getGroupFooter() {
            return groupFooter;
        }
        
        /** Setter for property groupFooter.
         * @param groupFooter New value of property groupFooter.
         *
         */
        public void setGroupFooter(it.businesslogic.ireport.Band groupFooter) {
            this.groupFooter = groupFooter;
        }
        
        /** Getter for property groupHeader.
         * @return Value of property groupHeader.
         *
         */
        public it.businesslogic.ireport.Band getGroupHeader() {
            return groupHeader;
        }
        
        /** Setter for property groupHeader.
         * @param groupHeader New value of property groupHeader.
         *
         */
        public void setGroupHeader(it.businesslogic.ireport.Band groupHeader) {
            this.groupHeader = groupHeader;
        }
        
        /** Getter for property isReprintHeaderOnEachPage.
         * @return Value of property isReprintHeaderOnEachPage.
         *
         */
        public boolean isIsReprintHeaderOnEachPage() {
            return isReprintHeaderOnEachPage;
        }
        
        /** Setter for property isReprintHeaderOnEachPage.
         * @param isReprintHeaderOnEachPage New value of property isReprintHeaderOnEachPage.
         *
         */
        public void setIsReprintHeaderOnEachPage(boolean isReprintHeaderOnEachPage) {
            this.isReprintHeaderOnEachPage = isReprintHeaderOnEachPage;
        }
        
        /** Getter for property isResetPageNumber.
         * @return Value of property isResetPageNumber.
         *
         */
        public boolean isIsResetPageNumber() {
            return isResetPageNumber;
        }
        
        /** Setter for property isResetPageNumber.
         * @param isResetPageNumber New value of property isResetPageNumber.
         *
         */
        public void setIsResetPageNumber(boolean isResetPageNumber) {
            this.isResetPageNumber = isResetPageNumber;
        }
        
        /** Getter for property isStartNewColumn.
         * @return Value of property isStartNewColumn.
         *
         */
        public boolean isIsStartNewColumn() {
            return isStartNewColumn;
        }
        
        /** Setter for property isStartNewColumn.
         * @param isStartNewColumn New value of property isStartNewColumn.
         *
         */
        public void setIsStartNewColumn(boolean isStartNewColumn) {
            this.isStartNewColumn = isStartNewColumn;
        }
        
        /** Getter for property isStartNewPage.
         * @return Value of property isStartNewPage.
         *
         */
        public boolean isIsStartNewPage() {
            return isStartNewPage;
        }
        
        /** Setter for property isStartNewPage.
         * @param isStartNewPage New value of property isStartNewPage.
         *
         */
        public void setIsStartNewPage(boolean isStartNewPage) {
            this.isStartNewPage = isStartNewPage;
        }
        
        /** Getter for property minHeightToStartNewPage.
         * @return Value of property minHeightToStartNewPage.
         *
         */
        public int getMinHeightToStartNewPage() {
            return minHeightToStartNewPage;
        }
        
        /** Setter for property minHeightToStartNewPage.
         * @param minHeightToStartNewPage New value of property minHeightToStartNewPage.
         *
         */
        public void setMinHeightToStartNewPage(int minHeightToStartNewPage) {
            this.minHeightToStartNewPage = minHeightToStartNewPage;
        }
        
        /** Getter for property name.
         * @return Value of property name.
         *
         */
        public java.lang.String getName() {
            return name;
        }
        
        /** Setter for property name.
         * @param name New value of property name.
         *
         */
        public void setName(java.lang.String name) {
            this.name = name;
        }
        
        /** Getter for property parent.
         * @return Value of property parent.
         *
         */
        public it.businesslogic.ireport.SubDataset getParent() {
            return parent;
        }  
        
        public String toString()
        {
            return this.getName();
        }
}
