/*
 * PiePlot.java
 *
 * Created on 16 agosto 2005, 10.19
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package it.businesslogic.ireport.chart;

import java.awt.Color;

/**
 *
 * @author Administrator
 */
public class ThermometerPlot extends Plot{
    

    private String valueLocation = "bulb";
    private boolean showValueLines = false;
    private java.awt.Color mercuryColor = null;
    
    private ValueDisplay valueDisplay = new ValueDisplay();
    
    private DataRange dataRange = new DataRange();
    private DataRange lowRange = new DataRange();
    private DataRange mediumRange = new DataRange();
    private DataRange highRange = new DataRange();
    
    
    
    /** Creates a new instance of PiePlot */
    public ThermometerPlot() {
    }
  
   
    
    public Plot cloneMe()
    {
        ThermometerPlot obj = new ThermometerPlot();
        copyBasePlot(obj);
        obj.setValueLocation( new String(getValueLocation()) );
        obj.setShowValueLines( isShowValueLines() );
        if (getMercuryColor() != null) obj.setMercuryColor( new Color( getMercuryColor().getRGB())  );

        obj.setValueDisplay( getValueDisplay().cloneMe() );

        obj.setDataRange(  getDataRange().cloneMe() );
        obj.setLowRange(  getLowRange().cloneMe() );
        obj.setMediumRange(  getMediumRange().cloneMe() );
        obj.setHighRange(  getHighRange().cloneMe() );

        
        return obj;
    }

    public String getValueLocation() {
        return valueLocation;
    }

    public void setValueLocation(String valueLocation) {
        this.valueLocation = valueLocation;
    }

    public boolean isShowValueLines() {
        return showValueLines;
    }

    public void setShowValueLines(boolean showValueLines) {
        this.showValueLines = showValueLines;
    }

    public java.awt.Color getMercuryColor() {
        return mercuryColor;
    }

    public void setMercuryColor(java.awt.Color mercuryColor) {
        this.mercuryColor = mercuryColor;
    }

    public ValueDisplay getValueDisplay() {
        return valueDisplay;
    }

    public void setValueDisplay(ValueDisplay valueDisplay) {
        this.valueDisplay = valueDisplay;
    }

    public DataRange getDataRange() {
        return dataRange;
    }

    public void setDataRange(DataRange dataRange) {
        this.dataRange = dataRange;
    }

    public DataRange getLowRange() {
        return lowRange;
    }

    public void setLowRange(DataRange lowRange) {
        this.lowRange = lowRange;
    }

    public DataRange getMediumRange() {
        return mediumRange;
    }

    public void setMediumRange(DataRange mediumRange) {
        this.mediumRange = mediumRange;
    }

    public DataRange getHighRange() {
        return highRange;
    }

    public void setHighRange(DataRange highRange) {
        this.highRange = highRange;
    }

   
   
}
