/*
 * CategorySeries.java
 *
 * Created on 17 agosto 2005, 10.56
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package it.businesslogic.ireport.chart;

/**
 *
 * @author Administrator
 */
public class TimeSeries {
    
    private String seriesExpression = "";
    private String timePeriodExpression = "";
    private String valueExpression = "";
    private String labelExpression = "";
    private SectionItemHyperlink sectionItemHyperlink = new SectionItemHyperlink();
    
    /** Creates a new instance of CategorySeries */
    public TimeSeries() {
    }

    public String getSeriesExpression() {
        return seriesExpression;
    }

    public void setSeriesExpression(String seriesExpression) {
        this.seriesExpression = seriesExpression;
    }

    public String getValueExpression() {
        return valueExpression;
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public String getLabelExpression() {
        return labelExpression;
    }

    public void setLabelExpression(String labelExpression) {
        this.labelExpression = labelExpression;
    }
    
    public String toString()
    {
        String str = getSeriesExpression();
        if (str == null) str = "";
        if (str.length() > 50) str = str.substring(0,30);
        
        return "Time series [" + str + "]";
    }

    public String getTimePeriodExpression() {
        return timePeriodExpression;
    }

    public void setTimePeriodExpression(String timePeriodExpression) {
        this.timePeriodExpression = timePeriodExpression;
    }
    
    public TimeSeries cloneMe()
    {
        TimeSeries cs = new TimeSeries();
        cs.setSeriesExpression( this.getSeriesExpression());
        cs.setTimePeriodExpression( this.getTimePeriodExpression());
        cs.setValueExpression( this.getValueExpression());
        cs.setLabelExpression( this.getLabelExpression());
        cs.setSectionItemHyperlink( this.getSectionItemHyperlink().cloneMe());
        
        return cs;
    }

    public SectionItemHyperlink getSectionItemHyperlink() {
        return sectionItemHyperlink;
    }

    public void setSectionItemHyperlink(SectionItemHyperlink sectionItemHyperlink) {
        this.sectionItemHyperlink = sectionItemHyperlink;
    }
}
