/*
 * PiePlot.java
 *
 * Created on 16 agosto 2005, 10.19
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package it.businesslogic.ireport.chart;

/**
 *
 * @author Administrator
 */
public class TimeSeriesPlot extends Plot{
    
    private boolean showLines = true;
    private boolean showShapes = true;
    
    private String timeAxisLabelExpression = "";
    private String valueAxisLabelExpression = "";
    
    private AxisFormat timeAxisFormat = new AxisFormat();
    private AxisFormat valueAxisFormat = new AxisFormat();
    
    /** Creates a new instance of PiePlot */
    public TimeSeriesPlot() {
    }
  
    public boolean isShowLines() {
        return showLines;
    }

    public void setShowLines(boolean showLines) {
        this.showLines = showLines;
    }

    public boolean isShowShapes() {
        return showShapes;
    }

    public void setShowShapes(boolean showShapes) {
        this.showShapes = showShapes;
    }

    public String getTimeAxisLabelExpression() {
        return timeAxisLabelExpression;
    }

    public void setTimeAxisLabelExpression(String timeAxisLabelExpression) {
        this.timeAxisLabelExpression = timeAxisLabelExpression;
    }

    public String getValueAxisLabelExpression() {
        return valueAxisLabelExpression;
    }

    public void setValueAxisLabelExpression(String valueAxisLabelExpression) {
        this.valueAxisLabelExpression = valueAxisLabelExpression;
    }
    
    public Plot cloneMe()
    {
        TimeSeriesPlot obj = new TimeSeriesPlot();
        copyBasePlot(obj);
        obj.setShowLines( this.isShowLines());
        obj.setShowShapes( this.isShowShapes());
        obj.setTimeAxisLabelExpression( this.getTimeAxisLabelExpression());
        obj.setValueAxisLabelExpression( this.getValueAxisLabelExpression());
        
        obj.setTimeAxisFormat( getTimeAxisFormat().cloneMe());
        obj.setValueAxisFormat( getValueAxisFormat().cloneMe());
       
        return obj;
    }

    public AxisFormat getTimeAxisFormat() {
        return timeAxisFormat;
    }

    public void setTimeAxisFormat(AxisFormat timeAxisFormat) {
        this.timeAxisFormat = timeAxisFormat;
    }

    public AxisFormat getValueAxisFormat() {
        return valueAxisFormat;
    }

    public void setValueAxisFormat(AxisFormat valueAxisFormat) {
        this.valueAxisFormat = valueAxisFormat;
    }
}
