/*
 * FormatCommandAlignToLeftMargin.java
 *
 * Created on 9 mei 2005, 21:36
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.OperationType;
import java.awt.Point;

/**
 *
 */
public class FormatCommandAlignToLeftMargin extends FormatCommand {
    {
        operationType = OperationType.ALIGN_TO_LEFT_MARGIN;
    }
    
    int leftMargin;
    
    public void preparation() {
        leftMargin = jrf.getReport().getLeftMargin();
    }
    
    public void modify() {
        
        
        if (re.getCell() != null)
        {
            re.setPosition(new Point(re.getCell().getLeft() + 10, re.getPosition().y));
            re.updateRelativePosition();
            
        } else 
        {
            re.setPosition(new Point(leftMargin + 10, re.getPosition().y));
        }
    }
    
}
