/*
 * FormatCommandCenterInBand.java
 *
 * Created on 17 mei 2005
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import java.awt.Point;

/**
 *
 */
public class FormatCommandCenterInBandH extends FormatCommand {
    {
        operationType = OperationType.CENTER_IN_BAND_V;
    }

    int centerx;
    
    void preparation() {
        //centerx = 10+ jrf.getReport().getWidth()/2;
        int insideWidth = jrf.getReport().getWidth() - jrf.getReport().getRightMargin() - jrf.getReport().getLeftMargin() ;
        centerx = jrf.getReport().getLeftMargin() + 10+ insideWidth/2;
        
    }
    
    void modify() {
        if (re.getBand() == null) // Perform a center in cell...
        {
            CrosstabCell cell = re.getCell();
            if (cell == null) return;
            centerx = cell.getLeft() + 10 + (cell.getWidth()/2);
            
         
            re.setPosition(new Point(centerx-(re.getWidth()/2), re.getPosition().y));
            re.updateRelativePosition();
        }
        else
        {
            re.setPosition(new Point(centerx-(re.getWidth()/2), re.getPosition().y));
        }
        
    }
    
}
