package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TransformationType;

import java.awt.Point;

import java.util.Enumeration;

/*
 * FormatCommandSameHeightMin.java
 *
 * Created on 9 mei 2005, 21:36
 */
public class FormatCommandSameWidthMin
    extends FormatCommand
{


    {
        operationType = OperationType.SAME_WIDTH_MIN;
    }

    int width;

    /**
     * DOCUMENT ME!
     */
    public void preparation()
    {

        ReportElement re = (ReportElement)this.getSelectedElements().firstElement();

        // Height is at least the height of one of the selected elements.
        // If it were set to zero then it would never get a higher value.
        width = re.getWidth();

        Enumeration enum2 = this.getSelectedElements().elements();

        while (enum2.hasMoreElements())
        {
            re = (ReportElement)enum2.nextElement();

            if (width > re.getWidth())
            {
                width = re.getWidth();
            }
        }

    }

    /**
     * DOCUMENT ME!
     */
    public void modify()
    {
        re.trasform(new Point(width - re.getWidth(), 0), 
                    TransformationType.TRANSFORMATION_RESIZE_SE);
    }
}

