/*
 * TextAreaCellRenderer.java
 *
 * Created on September 21, 2006, 12:35 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package it.businesslogic.ireport.gui.expbuilder;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.DefaultStyledDocument;

public class ExpObjectCellRenderer extends JTextPane implements ListCellRenderer {
        private Color selectionBackground;
        private Color background;
        
        // Create a style object and then set the style attributes
        Style typeStyle = null;
        Style classTypeStyle = null;
        
        Style parameterStyle = null;
        Style variableStyle = null;
        Style fieldStyle = null;
        Style whiteStyle = null;

        public ExpObjectCellRenderer(JList list) {
            super();
            selectionBackground = list.getSelectionBackground();
            background = list.getBackground();
            StyledDocument doc = new DefaultStyledDocument();
            this.setDocument( doc );
            
            typeStyle = doc.addStyle("typeStyle", null);
            StyleConstants.setItalic(typeStyle, true);
            StyleConstants.setForeground(typeStyle, Color.gray);
            
            classTypeStyle = doc.addStyle("classTypeStyle", null);
            StyleConstants.setForeground(classTypeStyle, Color.gray);
            
            parameterStyle = doc.addStyle("parameterStyle", null);
            StyleConstants.setForeground(parameterStyle, Color.red.darker());
            
            variableStyle = doc.addStyle("variableStyle", null);
            StyleConstants.setForeground(variableStyle, Color.blue);
            
            fieldStyle = doc.addStyle("fieldStyle", null);
            StyleConstants.setForeground(fieldStyle, Color.green.darker().darker());
            
            whiteStyle = doc.addStyle("whiteStyle", null);
            StyleConstants.setForeground(whiteStyle, Color.white);
            
        }
        public Component getListCellRendererComponent(JList list, Object object,
                int index, boolean isSelected, boolean cellHasFocus) {
            
            this.setText("");
            StyledDocument doc = (StyledDocument)this.getDocument();
            if (object instanceof ExpObject)
            {
                ExpObject eo = (ExpObject)object;
                 
                 try {
                     
                     doc.insertString(doc.getLength(), eo.getName() + "   ", (isSelected) ? whiteStyle : null);
                     
                     Style s = parameterStyle;
                     String type = "Parameter";
                     if (eo.getType() == eo.TYPE_FIELD) 
                     {
                         s = fieldStyle;
                         type = "Field";
                     }
                     else if (eo.getType() == eo.TYPE_VARIABLE)
                     {
                         s = variableStyle;
                         type = "Variable";
                     }
                     
                     if (isSelected) s = whiteStyle;
                     
                     
                     doc.insertString(doc.getLength(), type + " ", s);
                     
                     String tp = eo.getClassType() + "";
                     if (tp.lastIndexOf(".") > 0) tp = tp.substring(tp.lastIndexOf(".")+1);
                     
                     doc.insertString(doc.getLength(), tp, classTypeStyle);
                } catch (Exception ex){}
            }
            else
            {
                 try {
                doc.insertString(doc.getLength(), "" + object, null);
                 } catch (Exception ex){}
            }
            setBackground(isSelected ? selectionBackground : background);
            return this;
        }
    }

