/*
 * ComboBoxSheetProperty.java
 *
 * Created on 16 febbraio 2005, 19.13
 */

package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.ExpressionContext;
import javax.swing.*;

public class MeterIntervalsSheetProperty extends SheetProperty {
    
    private MeterIntervalsSheetPropertyComponent editor = null;

    public MeterIntervalsSheetProperty(String key, String name) {
        super( key, name, SheetProperty.STRING, null);
    }
    
    public JComponent getEditor()
    {
        if (editor != null) return editor;
        editor = new MeterIntervalsSheetPropertyComponent();
        editor.addActionListener( this );
        return editor;
    }
    
    public Object getEditorValue(JComponent component)
    {
        return editor.getListOfMeterIntervals();
    }
    
    public void setEditorValue(JComponent component, Object str)
    {
        try {
            getEditor(); // In this way we are sure that editor is not null.
            editor.setListOfMeterIntervals( (java.util.List)str);
            
        } catch (Exception ex) {}
    }
}