/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java_cup.runtime.Symbol;
import org.apache.log4j.Logger;

public class Scanner {
    private static final Logger LOGGER = Logger.getLogger((Class)Scanner.class);
    protected int nextChar;
    private int lookaheadChar = 0;
    private Hashtable m_resWordsTable;
    private int iMaxResword;
    private String[] m_aResWords;
    protected boolean debug;
    private List lines;
    private int iChar;
    private int iPrevChar;
    private int previousSymbol;
    private boolean inFormula;

    Scanner(boolean debug) {
        this.debug = debug;
    }

    private final void advance() throws IOException {
        if (this.lookaheadChar == 0) {
            this.nextChar = this.getChar();
        } else {
            this.nextChar = this.lookaheadChar;
            this.lookaheadChar = 0;
        }
        if (this.nextChar == 10) {
            this.lines.add(new Integer(this.iChar));
        }
        ++this.iChar;
    }

    private final int lookahead() throws IOException {
        this.lookaheadChar = this.getChar();
        return this.lookaheadChar;
    }

    protected int getChar() throws IOException {
        return System.in.read();
    }

    public void init() throws IOException {
        this.initReswords();
        this.lines = new ArrayList();
        this.iPrevChar = 0;
        this.iChar = 0;
        this.advance();
    }

    void getLocation(Symbol symbol, int[] loc) {
        int iLineStart;
        int iTarget = symbol.left;
        int iLine = -1;
        int iLineEnd = 0;
        do {
            iLineStart = iLineEnd;
            iLineEnd = Integer.MAX_VALUE;
            if (++iLine >= this.lines.size()) continue;
            iLineEnd = (Integer)this.lines.get(iLine);
        } while (iLineEnd < iTarget);
        loc[0] = iLine;
        loc[1] = iTarget - iLineStart;
    }

    private Symbol trace(Symbol s) {
        if (this.debug) {
            String name = null;
            if (s.sym < this.m_aResWords.length) {
                name = this.m_aResWords[s.sym];
            }
            LOGGER.error((Object)("Scanner returns #" + s.sym + (name == null ? "" : ":" + name) + (s.value == null ? "" : "(" + s.value.toString() + ")")));
        }
        return s;
    }

    private void initResword(int id, String s) {
        this.m_resWordsTable.put(s, new Integer(id));
        if (id > this.iMaxResword) {
            this.iMaxResword = id;
        }
    }

    private void initReswords() {
        this.m_resWordsTable = new Hashtable();
        this.iMaxResword = 0;
        this.initResword(2, "AND");
        this.initResword(3, "AS");
        this.initResword(4, "AXIS");
        this.initResword(5, "CASE");
        this.initResword(6, "CELL");
        this.initResword(7, "DIMENSION");
        this.initResword(8, "ELSE");
        this.initResword(9, "EMPTY");
        this.initResword(10, "END");
        this.initResword(11, "FROM");
        this.initResword(12, "IS");
        this.initResword(13, "MEMBER");
        this.initResword(14, "NON");
        this.initResword(15, "NOT");
        this.initResword(16, "NULL");
        this.initResword(17, "ON");
        this.initResword(18, "OR");
        this.initResword(19, "PROPERTIES");
        this.initResword(21, "SELECT");
        this.initResword(22, "SET");
        this.initResword(23, "THEN");
        this.initResword(24, "WHEN");
        this.initResword(25, "WHERE");
        this.initResword(27, "WITH");
        this.initResword(26, "XOR");
        this.m_aResWords = new String[this.iMaxResword + 1];
        Enumeration e = this.m_resWordsTable.keys();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            String s = (String)o;
            int i = (Integer)this.m_resWordsTable.get(s);
            this.m_aResWords[i] = s;
        }
    }

    public String lookupReserved(int i) {
        return this.m_aResWords[i];
    }

    private Symbol makeSymbol(int id, Object o) {
        int iPrevPrevChar = this.iPrevChar;
        this.iPrevChar = this.iChar;
        this.previousSymbol = id;
        return this.trace(new Symbol(id, iPrevPrevChar, this.iChar, o));
    }

    private Symbol makeNumber(double mantissa, int exponent) {
        double d = mantissa * Math.pow(10.0, exponent);
        return this.makeSymbol(47, new Double(d));
    }

    private Symbol makeId(String s, boolean quoted, boolean ampersand) {
        return this.makeSymbol(quoted && ampersand ? 50 : (quoted ? 49 : 48), s);
    }

    private Symbol makeRes(int i) {
        return this.makeSymbol(i, this.m_aResWords[i]);
    }

    private Symbol makeToken(int i, String s) {
        return this.makeSymbol(i, s);
    }

    private Symbol makeString(String s) {
        return this.makeSymbol(51, s);
    }

    public Symbol next_token() throws IOException {
        boolean ampersandId = false;
        while (true) {
            switch (this.nextChar) {
                case 46: {
                    switch (this.lookahead()) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            break;
                        }
                        default: {
                            this.advance();
                            return this.makeToken(33, ".");
                        }
                    }
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    boolean leftOfPoint = false;
                    boolean rightOfPoint = true;
                    int inExponent = 2;
                    int n = 0;
                    int nDigits = 0;
                    int nSign = 0;
                    int exponent = 0;
                    double mantissa = 0.0;
                    int state = 0;
                    while (true) {
                        if (this.nextChar == 46) {
                            if (state == 0) {
                                state = 1;
                                mantissa = n;
                                nDigits = 0;
                                n = 0;
                                nSign = 1;
                                this.advance();
                                continue;
                            }
                            if (state == 1) {
                                mantissa += (double)n * Math.pow(10.0, -nDigits);
                            } else {
                                exponent = n * nSign;
                            }
                            return this.makeNumber(mantissa, exponent);
                        }
                        if (this.nextChar == 69 || this.nextChar == 101) {
                            if (state == 2) {
                                exponent = n * nSign;
                                return this.makeNumber(mantissa, exponent);
                            }
                            mantissa = state == 0 ? (double)n : (mantissa += (double)n * Math.pow(10.0, -nDigits));
                            nDigits = 0;
                            n = 0;
                            nSign = 1;
                            this.advance();
                            state = 2;
                            continue;
                        }
                        if ((this.nextChar == 43 || this.nextChar == 45) && state == 2 && nDigits == 0) {
                            nSign = -nSign;
                            this.advance();
                            continue;
                        }
                        if (this.nextChar < 48 || this.nextChar > 57) break;
                        n = n * 10 + (this.nextChar - 48);
                        ++nDigits;
                        this.advance();
                    }
                    if (state == 0) {
                        mantissa = n;
                    } else if (state == 1) {
                        mantissa += (double)n * Math.pow(10.0, -nDigits);
                    } else {
                        exponent = n * nSign;
                    }
                    return this.makeNumber(mantissa, exponent);
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    StringBuffer id = new StringBuffer();
                    block54: while (true) {
                        id.append((char)this.nextChar);
                        this.advance();
                        switch (this.nextChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 95: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: {
                                continue block54;
                            }
                        }
                        break;
                    }
                    String strId = id.toString();
                    Integer i = (Integer)this.m_resWordsTable.get(strId.toUpperCase());
                    if (i == null) {
                        return this.makeId(strId, false, false);
                    }
                    return this.makeRes(i);
                }
                case 38: {
                    this.advance();
                    if (this.nextChar == 91) {
                        ampersandId = true;
                    } else {
                        return this.makeToken(52, "&");
                    }
                }
                case 91: {
                    StringBuffer id = new StringBuffer();
                    block55: while (true) {
                        this.advance();
                        switch (this.nextChar) {
                            case 93: {
                                this.advance();
                                if (this.nextChar == 93) {
                                    id.append(']');
                                    continue block55;
                                }
                                if (ampersandId) {
                                    ampersandId = false;
                                    return this.makeId(id.toString(), true, true);
                                }
                                return this.makeId(id.toString(), true, false);
                            }
                            case -1: {
                                if (ampersandId) {
                                    ampersandId = false;
                                    return this.makeId(id.toString(), true, true);
                                }
                                return this.makeId(id.toString(), true, false);
                            }
                        }
                        id.append((char)this.nextChar);
                    }
                }
                case 58: {
                    this.advance();
                    return this.makeToken(30, ":");
                }
                case 44: {
                    this.advance();
                    return this.makeToken(31, ",");
                }
                case 61: {
                    this.advance();
                    return this.makeToken(34, "=");
                }
                case 60: {
                    this.advance();
                    switch (this.nextChar) {
                        case 62: {
                            this.advance();
                            return this.makeToken(42, "<>");
                        }
                        case 61: {
                            this.advance();
                            return this.makeToken(38, "<=");
                        }
                    }
                    return this.makeToken(40, "<");
                }
                case 62: {
                    this.advance();
                    switch (this.nextChar) {
                        case 61: {
                            this.advance();
                            return this.makeToken(35, ">=");
                        }
                    }
                    return this.makeToken(36, ">");
                }
                case 123: {
                    this.advance();
                    return this.makeToken(37, "{");
                }
                case 40: {
                    this.advance();
                    return this.makeToken(39, "(");
                }
                case 125: {
                    this.advance();
                    return this.makeToken(44, "}");
                }
                case 41: {
                    this.advance();
                    return this.makeToken(45, ")");
                }
                case 43: {
                    this.advance();
                    return this.makeToken(43, "+");
                }
                case 45: {
                    this.advance();
                    return this.makeToken(41, "-");
                }
                case 42: {
                    this.advance();
                    return this.makeToken(29, "*");
                }
                case 47: {
                    this.advance();
                    return this.makeToken(46, "/");
                }
                case 124: {
                    this.advance();
                    switch (this.nextChar) {
                        case 124: {
                            this.advance();
                            return this.makeToken(32, "||");
                        }
                    }
                    return this.makeToken(52, "|");
                }
                case 34: {
                    StringBuffer id = new StringBuffer();
                    block56: while (true) {
                        this.advance();
                        switch (this.nextChar) {
                            case 34: {
                                this.advance();
                                if (this.nextChar == 34) {
                                    id.append('\"');
                                    continue block56;
                                }
                                return this.makeString(id.toString());
                            }
                            case -1: {
                                return this.makeString(id.toString());
                            }
                        }
                        id.append((char)this.nextChar);
                    }
                }
                case 39: {
                    if (this.inFormula) {
                        this.inFormula = false;
                        this.advance();
                        return this.makeToken(20, "'");
                    }
                    if (this.previousSymbol == 3) {
                        this.inFormula = true;
                        this.advance();
                        return this.makeToken(20, "'");
                    }
                    StringBuffer id = new StringBuffer();
                    block57: while (true) {
                        this.advance();
                        switch (this.nextChar) {
                            case 39: {
                                this.advance();
                                if (this.nextChar == 39) {
                                    id.append('\'');
                                    continue block57;
                                }
                                return this.makeString(id.toString());
                            }
                            case -1: {
                                return this.makeString(id.toString());
                            }
                        }
                        id.append((char)this.nextChar);
                    }
                }
                case -1: {
                    return this.makeToken(0, "EOF");
                }
            }
            this.iPrevChar = this.iChar;
            this.advance();
        }
    }
}

