/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.gui.MainFrame;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JasperReport;

public class JRDataSourceProviderConnection
extends IReportConnection {
    private JRDataSourceProvider dsp;
    private JRDataSource ds;
    private HashMap properties = new HashMap();

    public JRDataSourceProvider getDataSourceProvider() {
        if (this.dsp == null && this.getProperties().get("JRDataSourceProvider") != null) {
            try {
                this.dsp = (JRDataSourceProvider)Class.forName((String)this.getProperties().get("JRDataSourceProvider"), true, MainFrame.getMainInstance().getReportClassLoader()).newInstance();
            }
            catch (NoClassDefFoundError ex) {
                JOptionPane.showMessageDialog(MainFrame.getMainInstance(), "NoClassDefFoundError!!\nCheck your classpath!", "Error", 0);
            }
            catch (ClassNotFoundException ex) {
                JOptionPane.showMessageDialog(MainFrame.getMainInstance(), "ClassNotFoundError:\n" + ex.getMessage() + "\n\nCheck your classpath!", "Error", 0);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(MainFrame.getMainInstance(), "Exception:\n" + ex.getMessage() + "\n", "Error", 0);
            }
        }
        return this.dsp;
    }

    public String getDescription() {
        return "JasperReports DataSource Provider";
    }

    public JRDataSource getJRDataSource() {
        return this.getJRDataSource(null);
    }

    public JRDataSource getJRDataSource(JasperReport jasper) {
        if (this.ds != null) {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), "This datasource is already in use by another filling process!!", "Error", 0);
            return null;
        }
        try {
            this.ds = this.getDataSourceProvider().create(jasper);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), "Problems occurred creating the new datasource!!\n" + ex.getMessage(), "Error", 0);
        }
        return this.ds;
    }

    public void disposeDataSource() {
        if (this.dsp != null) {
            try {
                this.dsp.dispose(this.ds);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ds = null;
        }
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public void loadProperties(HashMap map) {
        this.properties = map;
    }

    public void save(PrintWriter pw) {
        HashMap hm = this.getProperties();
        pw.println("\t<iReportConnection name=\"" + this.getName() + "\" connectionClass=\"" + this.getClass().getName() + "\">");
        Iterator iterator = hm.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            pw.println("\t\t<connectionParameter name=\"" + key + "\"><![CDATA[" + hm.get(key) + "]]></connectionParameter>");
        }
        pw.println("\t</iReportConnection>");
    }
}

