/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.undo.ReplacedElementItem;
import java.util.Enumeration;
import java.util.Vector;

public class ReplacedElementsOperation
implements UndoOperation {
    private Vector elements = null;
    private JReportFrame jrf = null;
    private CrosstabReportElement crosstabReportElement = null;

    public ReplacedElementsOperation(JReportFrame jrf, CrosstabReportElement crosstabReportElement) {
        this.setCrosstabReportElement(crosstabReportElement);
        this.elements = new Vector();
        this.jrf = jrf;
    }

    public ReplacedElementsOperation(JReportFrame jrf) {
        this(jrf, null);
    }

    public void redo() {
        if (this.jrf == null) {
            return;
        }
        Enumeration e = this.getElements().elements();
        Vector<ReportElement> added_elements = new Vector<ReportElement>();
        Vector<ReportElement> removed_elements = new Vector<ReportElement>();
        while (e.hasMoreElements()) {
            int index;
            ReplacedElementItem ei = (ReplacedElementItem)e.nextElement();
            ReportElement newElement = ei.getNewElement();
            ReportElement oldElement = ei.getOldElement();
            if (this.getCrosstabReportElement() != null) {
                index = this.getCrosstabReportElement().getElements().indexOf(oldElement);
                this.getCrosstabReportElement().getElements().remove(oldElement);
                this.getCrosstabReportElement().getElements().add(index, newElement);
                added_elements.add(newElement);
                removed_elements.add(oldElement);
                continue;
            }
            index = this.jrf.getReport().getElements().indexOf(oldElement);
            this.jrf.getReport().getElements().remove(oldElement);
            this.jrf.getReport().getElements().add(index, newElement);
            added_elements.add(newElement);
            removed_elements.add(oldElement);
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.getCrosstabReportElement(), removed_elements, 1));
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.getCrosstabReportElement(), added_elements, 2));
        if (this.getCrosstabReportElement() != null) {
            this.jrf.getCrosstabEditor(this.getCrosstabReportElement()).getPanelEditor().repaint();
        } else {
            this.jrf.getReportPanel().repaint();
        }
    }

    public void undo() {
        if (this.jrf == null) {
            return;
        }
        Vector<ReportElement> added_elements = new Vector<ReportElement>();
        Vector<ReportElement> removed_elements = new Vector<ReportElement>();
        for (int i = this.getElements().size() - 1; i >= 0; --i) {
            int index;
            ReplacedElementItem ei = (ReplacedElementItem)this.getElements().get(i);
            ReportElement newElement = ei.getNewElement();
            ReportElement oldElement = ei.getOldElement();
            if (this.getCrosstabReportElement() != null) {
                index = this.getCrosstabReportElement().getElements().indexOf(newElement);
                this.getCrosstabReportElement().getElements().remove(newElement);
                this.getCrosstabReportElement().getElements().add(index, oldElement);
                added_elements.add(oldElement);
                removed_elements.add(newElement);
                continue;
            }
            index = this.jrf.getReport().getElements().indexOf(newElement);
            this.jrf.getReport().getElements().remove(newElement);
            this.jrf.getReport().getElements().add(index, oldElement);
            added_elements.add(oldElement);
            removed_elements.add(newElement);
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.getCrosstabReportElement(), removed_elements, 1));
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.getCrosstabReportElement(), added_elements, 2));
        if (this.getCrosstabReportElement() != null) {
            this.jrf.getCrosstabEditor(this.getCrosstabReportElement()).getPanelEditor().repaint();
        } else {
            this.jrf.getReportPanel().repaint();
        }
    }

    public String toString() {
        return "Transformed element(s)";
    }

    public Vector getElements() {
        return this.elements;
    }

    public void setElements(Vector elements) {
        this.elements = elements;
    }

    public void addElement(ReportElement oldEelement, ReportElement newElement) {
        ReplacedElementItem ei = new ReplacedElementItem(oldEelement, newElement);
        this.getElements().add(ei);
    }

    public CrosstabReportElement getCrosstabReportElement() {
        return this.crosstabReportElement;
    }

    public void setCrosstabReportElement(CrosstabReportElement crosstabReportElement) {
        this.crosstabReportElement = crosstabReportElement;
    }
}

