/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.parser;

import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Type;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NegationExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.RegexExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.Numbers;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.parser.ASTHelper;
import org.codehaus.groovy.syntax.parser.ParserException;

public class ASTBuilder
extends ASTHelper {
    public static final int[] EXPRESSION_HANDLERS = new int[]{1370, 1104, 30, 1220, 97, 1200, 1210, 1910, 546};

    public ASTBuilder(SourceUnit sourceUnit, ClassLoader classLoader) {
        super(sourceUnit, classLoader);
    }

    public ModuleNode build(CSTNode input) throws ParserException {
        this.makeModule();
        this.setPackageName(this.packageDeclaration(input.get(1)));
        this.importStatements(input.get(2));
        for (int i = 3; i < input.size(); ++i) {
            this.topLevelStatement(this.output, input.get(i));
        }
        if (this.output.isEmpty()) {
            this.output.addStatement(new BlockStatement());
        }
        return this.output;
    }

    protected String packageDeclaration(CSTNode reduction) {
        if (reduction.hasChildren()) {
            return this.makeName(reduction.get(1));
        }
        return null;
    }

    protected void importStatements(CSTNode container) {
        for (int i = 1; i < container.size(); ++i) {
            this.importStatement(container.get(i));
        }
    }

    protected void importStatement(CSTNode reduction) {
        String importPackage = this.makeName(reduction.get(1), null);
        if (reduction.get(2).isA(202)) {
            this.importPackageWithStar(importPackage);
        } else {
            for (int i = 2; i < reduction.size(); ++i) {
                CSTNode clause = reduction.get(i);
                String name = this.identifier(clause);
                String as = clause.hasChildren() ? this.identifier(clause.get(1)) : name;
                this.importClass(importPackage, name, as);
            }
        }
    }

    protected void topLevelStatement(ModuleNode module, CSTNode reduction) throws ParserException {
        int type = reduction.getMeaning();
        switch (type) {
            case 801: {
                module.addClass(this.classDeclaration(null, reduction));
                break;
            }
            case 802: {
                module.addClass(this.interfaceDeclaration(null, reduction));
                break;
            }
            case 804: {
                module.addMethod(this.methodDeclaration(null, reduction));
                break;
            }
            default: {
                module.addStatement(this.statement(reduction));
            }
        }
    }

    protected ClassNode classDeclaration(ClassNode context, CSTNode reduction) throws ParserException {
        String name = this.identifier(reduction);
        this.addNewClassName(name);
        int modifiers = this.modifiers(reduction.get(1));
        String parent = this.resolveName(reduction.get(2).get(1));
        CSTNode interfaceReduction = reduction.get(3);
        String[] interfaces = new String[interfaceReduction.children()];
        for (int i = 1; i < interfaceReduction.size(); ++i) {
            interfaces[i - 1] = this.resolveName(interfaceReduction.get(i));
        }
        ClassNode classNode = context == null ? new ClassNode(this.dot(this.getPackageName(), name), modifiers, parent, interfaces, MixinNode.EMPTY_ARRAY) : new InnerClassNode(context, this.dot(this.getPackageName(), name), modifiers, parent, interfaces, MixinNode.EMPTY_ARRAY);
        classNode.setCSTNode(reduction.get(0));
        this.typeBody(classNode, reduction.get(4), 0, 0);
        return classNode;
    }

    protected void typeBody(ClassNode classNode, CSTNode body, int propertyModifiers, int methodModifiers) throws ParserException {
        block6: for (int i = 1; i < body.size(); ++i) {
            CSTNode statement = body.get(i);
            switch (statement.getMeaning()) {
                case 805: {
                    this.addPropertyDeclaration(classNode, statement, propertyModifiers);
                    continue block6;
                }
                case 804: {
                    this.methodDeclaration(classNode, statement, methodModifiers);
                    continue block6;
                }
                case 801: {
                    this.classDeclaration(classNode, statement);
                    continue block6;
                }
                case 802: {
                    this.interfaceDeclaration(classNode, statement);
                    continue block6;
                }
                default: {
                    throw new GroovyBugError("unrecognized type body statement [" + statement.toString() + "]");
                }
            }
        }
    }

    protected void addPropertyDeclaration(ClassNode classNode, CSTNode reduction, int extraModifiers) throws ParserException {
        String name = this.identifier(reduction);
        int modifiers = this.modifiers(reduction.get(1)) | extraModifiers;
        String type = this.resolveName(reduction.get(2));
        Expression value = reduction.size() > 3 ? this.expression(reduction.get(3)) : null;
        PropertyNode propertyNode = classNode.addProperty(name, modifiers, type, value, null, null);
        propertyNode.setCSTNode(reduction.get(0));
    }

    protected void addPropertyDeclaration(ClassNode classNode, CSTNode reduction) throws ParserException {
        this.addPropertyDeclaration(classNode, reduction, 0);
    }

    protected MethodNode methodDeclaration(ClassNode classNode, CSTNode reduction, int extraModifiers) throws ParserException {
        String className = null;
        if (classNode != null) {
            className = classNode.getNameWithoutPackage();
        }
        String name = this.identifier(reduction);
        int modifiers = this.modifiers(reduction.get(1)) | extraModifiers;
        String type = this.resolveName(reduction.get(2));
        Parameter[] parameters = this.parameterDeclarations(reduction.get(3));
        BlockStatement body = this.statementBody(reduction.get(5));
        CSTNode clause = reduction.get(4);
        String[] throwTypes = new String[clause.children()];
        for (int i = 1; i < clause.size(); ++i) {
            throwTypes[i - 1] = this.resolveName(clause.get(i));
        }
        if (clause.hasChildren()) {
            throw new GroovyBugError("NOT YET IMPLEMENTED: throws clause");
        }
        if (name.length() == 0) {
            throw new GroovyBugError("NOT YET IMPLEMENTED: static initializers");
        }
        if (className != null && name.equals(className)) {
            ConstructorNode node = new ConstructorNode(modifiers, parameters, body);
            node.setCSTNode(reduction.get(0));
            classNode.addConstructor(node);
            return null;
        }
        MethodNode method = new MethodNode(name, modifiers, type, parameters, body);
        method.setCSTNode(reduction.get(0));
        if (classNode != null) {
            classNode.addMethod(method);
        }
        return method;
    }

    protected MethodNode methodDeclaration(ClassNode classNode, CSTNode reduction) throws ParserException {
        return this.methodDeclaration(classNode, reduction, 0);
    }

    protected Parameter[] parameterDeclarations(CSTNode reduction) throws ParserException {
        Parameter[] parameters = new Parameter[reduction.children()];
        for (int i = 1; i < reduction.size(); ++i) {
            CSTNode node = reduction.get(i);
            String identifier = this.identifier(node);
            String type = this.resolveName(node.get(1));
            parameters[i - 1] = node.size() > 2 ? new Parameter(type, identifier, this.expression(node.get(2))) : new Parameter(type, identifier);
        }
        return parameters;
    }

    protected ClassNode interfaceDeclaration(ClassNode context, CSTNode reduction) throws ParserException {
        throw new GroovyBugError("NOT YET IMPLEMENTED: interfaces");
    }

    protected BlockStatement statementBody(CSTNode reduction) throws ParserException {
        if (reduction.isEmpty()) {
            return new BlockStatement();
        }
        if (reduction.getMeaning() == 10) {
            return this.statementBlock(reduction);
        }
        Statement statement = this.statement(reduction);
        statement.setCSTNode(reduction);
        BlockStatement block = null;
        if (statement instanceof BlockStatement) {
            block = (BlockStatement)statement;
        } else {
            block = new BlockStatement();
            block.addStatement(statement);
        }
        return block;
    }

    protected BlockStatement statements(CSTNode reduction, int first) throws ParserException {
        BlockStatement block = new BlockStatement();
        for (int i = first; i < reduction.size(); ++i) {
            CSTNode statementReduction = reduction.get(i);
            Statement statement = this.statement(statementReduction);
            statement.setCSTNode(statementReduction);
            block.addStatement(statement);
        }
        return block;
    }

    protected BlockStatement statementBlock(CSTNode reduction) throws ParserException {
        return this.statements(reduction, 1);
    }

    protected Statement statement(CSTNode reduction) throws ParserException {
        Statement statement = null;
        switch (reduction.getMeaning()) {
            case 585: {
                statement = this.assertStatement(reduction);
                break;
            }
            case 574: {
                statement = this.breakStatement(reduction);
                break;
            }
            case 575: {
                statement = this.continueStatement(reduction);
                break;
            }
            case 561: {
                statement = this.ifStatement(reduction);
                break;
            }
            case 560: {
                statement = this.returnStatement(reduction);
                break;
            }
            case 576: {
                statement = this.switchStatement(reduction);
                break;
            }
            case 520: {
                statement = this.synchronizedStatement(reduction);
                break;
            }
            case 583: {
                statement = this.throwStatement(reduction);
                break;
            }
            case 580: {
                statement = this.tryStatement(reduction);
                break;
            }
            case 572: {
                statement = this.forStatement(reduction);
                break;
            }
            case 571: {
                statement = this.whileStatement(reduction);
                break;
            }
            case 570: {
                statement = this.doWhileStatement(reduction);
                break;
            }
            case 10: 
            case 816: {
                statement = this.statementBlock(reduction);
                break;
            }
            case 818: {
                statement = this.statement(reduction.get(1));
                statement.setStatementLabel(this.identifier(reduction));
                break;
            }
            default: {
                statement = this.expressionStatement(reduction);
            }
        }
        statement.setCSTNode(reduction);
        return statement;
    }

    protected AssertStatement assertStatement(CSTNode reduction) throws ParserException {
        BooleanExpression expression = new BooleanExpression(this.expression(reduction.get(1)));
        if (reduction.children() > 1) {
            return new AssertStatement(expression, this.expression(reduction.get(2)));
        }
        return new AssertStatement(expression, ConstantExpression.NULL);
    }

    protected BreakStatement breakStatement(CSTNode reduction) throws ParserException {
        if (reduction.hasChildren()) {
            return new BreakStatement(reduction.get(1).getRootText());
        }
        return new BreakStatement();
    }

    protected ContinueStatement continueStatement(CSTNode reduction) throws ParserException {
        if (reduction.hasChildren()) {
            return new ContinueStatement(reduction.get(1).getRootText());
        }
        return new ContinueStatement();
    }

    protected IfStatement ifStatement(CSTNode reduction) throws ParserException {
        Expression condition = this.expression(reduction.get(1));
        BlockStatement body = this.statementBody(reduction.get(2));
        Statement elseBlock = EmptyStatement.INSTANCE;
        if (reduction.size() > 3) {
            CSTNode elseReduction = reduction.get(3);
            elseBlock = elseReduction.getMeaning() == 561 ? this.ifStatement(elseReduction) : this.statementBody(elseReduction.get(1));
        }
        return new IfStatement(new BooleanExpression(condition), body, elseBlock);
    }

    protected ReturnStatement returnStatement(CSTNode reduction) throws ParserException {
        if (reduction.hasChildren()) {
            return new ReturnStatement(this.expression(reduction.get(1)));
        }
        return ReturnStatement.RETURN_NULL_OR_VOID;
    }

    protected SwitchStatement switchStatement(CSTNode reduction) throws ParserException {
        SwitchStatement statement = new SwitchStatement(this.expression(reduction.get(1)));
        block4: for (int i = 2; i < reduction.size(); ++i) {
            CSTNode child = reduction.get(i);
            switch (child.getMeaning()) {
                case 577: {
                    statement.addCase(this.caseStatement(child));
                    continue block4;
                }
                case 578: {
                    statement.setDefaultStatement(this.statementBlock(child));
                    continue block4;
                }
                default: {
                    throw new GroovyBugError("invalid something in switch [" + child + "]");
                }
            }
        }
        return statement;
    }

    protected CaseStatement caseStatement(CSTNode reduction) throws ParserException {
        return new CaseStatement(this.expression(reduction.get(1)), this.statements(reduction, 2));
    }

    protected SynchronizedStatement synchronizedStatement(CSTNode reduction) throws ParserException {
        return new SynchronizedStatement(this.expression(reduction.get(1)), this.statementBody(reduction.get(2)));
    }

    protected ThrowStatement throwStatement(CSTNode reduction) throws ParserException {
        return new ThrowStatement(this.expression(reduction.get(1)));
    }

    protected TryCatchStatement tryStatement(CSTNode reduction) throws ParserException {
        BlockStatement body = this.statementBody(reduction.get(1));
        BlockStatement finallyBlock = this.statementBody(reduction.get(3));
        TryCatchStatement statement = new TryCatchStatement(body, finallyBlock);
        CSTNode catches = reduction.get(2);
        for (int i = 1; i < catches.size(); ++i) {
            CSTNode element = catches.get(i);
            String type = this.resolveName(element.get(1));
            String identifier = this.identifier(element.get(2));
            statement.addCatch(new CatchStatement(type, identifier, this.statementBody(element.get(3))));
        }
        return statement;
    }

    protected ForStatement forStatement(CSTNode reduction) throws ParserException {
        CSTNode header = reduction.get(1);
        BlockStatement body = this.statementBody(reduction.get(2));
        if (header.getMeaning() == 0) {
            Expression[] init = this.expressions(header.get(1));
            Expression test = this.expression(header.get(2));
            Expression[] incr = this.expressions(header.get(3));
            throw new GroovyBugError("NOT YET IMPLEMENTED: standard for loop");
        }
        Type type = this.typeExpression(header.get(1));
        String identifier = this.identifier(header.get(2));
        Expression source = this.expression(header.get(3));
        return new ForStatement(identifier, type, source, body);
    }

    protected DoWhileStatement doWhileStatement(CSTNode reduction) throws ParserException {
        Expression condition = this.expression(reduction.get(2));
        BlockStatement body = this.statementBody(reduction.get(1));
        return new DoWhileStatement(new BooleanExpression(condition), body);
    }

    protected WhileStatement whileStatement(CSTNode reduction) throws ParserException {
        Expression condition = this.expression(reduction.get(1));
        BlockStatement body = this.statementBody(reduction.get(2));
        return new WhileStatement(new BooleanExpression(condition), body);
    }

    protected Statement expressionStatement(CSTNode node) throws ParserException {
        return new ExpressionStatement(this.expression(node));
    }

    protected Expression[] expressions(CSTNode reduction) throws ParserException {
        Expression[] expressions = new Expression[reduction.children()];
        for (int i = 1; i < reduction.size(); ++i) {
            expressions[i - 1] = this.expression(reduction.get(i));
        }
        return expressions;
    }

    protected Expression expression(CSTNode reduction) throws ParserException {
        Expression expression = null;
        int type = reduction.getMeaningAs(EXPRESSION_HANDLERS);
        switch (type) {
            case 1370: {
                expression = this.syntheticExpression(reduction);
                break;
            }
            case 1104: {
                Expression from = this.expression(reduction.get(1));
                Expression to = this.expression(reduction.get(2));
                expression = new RangeExpression(from, to, reduction.getMeaning() == 75);
                break;
            }
            case 30: 
            case 1220: {
                expression = this.infixExpression(reduction);
                break;
            }
            case 97: {
                CSTNode body = reduction.get(1);
                Token token = body.getRoot();
                String text = body.getRootText();
                if (body.isA(812)) {
                    expression = new RegexExpression(this.expression(reduction.get(1)));
                    break;
                }
                expression = new BitwiseNegExpression(this.expression(body));
                break;
            }
            case 1200: {
                expression = this.prefixExpression(reduction);
                break;
            }
            case 1210: {
                Expression body = this.expression(reduction.get(1));
                expression = new PostfixExpression(body, reduction.getRoot());
                break;
            }
            case 1910: {
                expression = this.simpleExpression(reduction);
                break;
            }
            case 546: {
                expression = this.newExpression(reduction);
                break;
            }
            default: {
                throw new GroovyBugError("unhandled CST: [" + reduction.toString() + "]");
            }
        }
        if (expression == null) {
            throw new GroovyBugError("expression produced null: [" + reduction.toString() + "]");
        }
        expression.setCSTNode(reduction);
        return expression;
    }

    public Expression infixExpression(CSTNode reduction) throws ParserException {
        Expression expression;
        int type = reduction.getMeaning();
        switch (type) {
            case 70: 
            case 80: {
                CSTNode node;
                String name = reduction.get(2).getRootText();
                Expression context = null;
                if (name.equals("class") && (node = reduction.get(1)).isA(30) && node.children() == 1) {
                    throw new GroovyBugError("NOT YET IMPLEMENTED: .class for array types");
                }
                if (context == null) {
                    context = this.expression(reduction.get(1));
                }
                expression = new PropertyExpression(context, name, type == 80);
                break;
            }
            case 544: {
                Expression lhs = this.expression(reduction.get(1));
                ClassExpression rhs = this.classExpression(reduction.get(2));
                expression = new BinaryExpression(lhs, reduction.getRoot(), rhs);
                break;
            }
            default: {
                Expression lhs = this.expression(reduction.get(1));
                Expression rhs = this.expression(reduction.get(2));
                expression = new BinaryExpression(lhs, reduction.getRoot(), rhs);
                break;
            }
        }
        return expression;
    }

    public Expression prefixExpression(CSTNode reduction) throws ParserException {
        Expression expression = null;
        CSTNode body = reduction.get(1);
        int type = reduction.getMeaning();
        switch (type) {
            case 263: {
                if (body.size() == 1 && body.isA(1320)) {
                    expression = this.numericExpression(body, true);
                    break;
                }
                expression = new NegationExpression(this.expression(body));
                break;
            }
            case 253: {
                expression = this.expression(body);
                break;
            }
            case 160: {
                expression = new NotExpression(this.expression(body));
                break;
            }
            case 97: {
                expression = new BitwiseNegExpression(this.expression(body));
                break;
            }
            default: {
                expression = new PrefixExpression(reduction.getRoot(), this.expression(body));
            }
        }
        return expression;
    }

    public Expression simpleExpression(CSTNode reduction) throws ParserException {
        Expression expression = null;
        int type = reduction.getMeaning();
        switch (type) {
            case 612: {
                expression = ConstantExpression.NULL;
                break;
            }
            case 610: {
                expression = ConstantExpression.TRUE;
                break;
            }
            case 611: {
                expression = ConstantExpression.FALSE;
                break;
            }
            case 400: {
                expression = new ConstantExpression(reduction.getRootText());
                break;
            }
            case 450: 
            case 451: {
                expression = this.numericExpression(reduction, false);
                break;
            }
            case 542: 
            case 543: {
                expression = this.variableExpression(reduction);
                break;
            }
            case 440: {
                expression = this.variableOrClassExpression(reduction);
            }
        }
        return expression;
    }

    public Expression numericExpression(CSTNode reduction, boolean negate) throws ParserException {
        Token token = reduction.getRoot();
        String text = reduction.getRootText();
        String signed = negate ? "-" + text : text;
        boolean isInteger = token.getMeaning() == 450;
        try {
            Number number = isInteger ? (Number)Numbers.parseInteger(signed) : (Number)Numbers.parseDecimal(signed);
            return new ConstantExpression(number);
        }
        catch (NumberFormatException e) {
            this.error("numeric literal [" + signed + "] invalid or out of range for its type", token);
            throw new GroovyBugError("this should never happen");
        }
    }

    public Expression syntheticExpression(CSTNode reduction) throws ParserException {
        Expression expression = null;
        int type = reduction.getMeaning();
        switch (type) {
            case 819: {
                BooleanExpression condition = new BooleanExpression(this.expression(reduction.get(1)));
                Expression trueBranch = this.expression(reduction.get(2));
                Expression falseBranch = this.expression(reduction.get(3));
                expression = new TernaryExpression(condition, trueBranch, falseBranch);
                break;
            }
            case 815: {
                String className = this.resolveName(reduction.get(1));
                Expression body = this.expression(reduction.get(2));
                expression = new CastExpression(className, body);
                break;
            }
            case 830: {
                expression = this.variableDeclarationExpression(reduction);
                break;
            }
            case 814: {
                expression = this.methodCallExpression(reduction);
                break;
            }
            case 817: {
                expression = this.closureExpression(reduction);
                break;
            }
            case 812: {
                expression = this.gstringExpression(reduction);
                break;
            }
            case 810: {
                expression = this.listExpression(reduction);
                break;
            }
            case 811: {
                expression = this.mapExpression(reduction);
            }
        }
        return expression;
    }

    protected Expression variableOrClassExpression(CSTNode reduction) throws ParserException {
        String className = this.resolveName(reduction, false);
        if (className == null) {
            return this.variableExpression(reduction);
        }
        return new ClassExpression(className);
    }

    protected ClassExpression classExpression(CSTNode reduction) throws ParserException {
        String name = this.resolveName(reduction, true);
        return new ClassExpression(name);
    }

    protected VariableExpression variableExpression(CSTNode reduction) {
        return new VariableExpression(reduction.getRootText(), null);
    }

    protected VariableExpression variableExpression(CSTNode reduction, String type) {
        return new VariableExpression(reduction.getRootText(), type);
    }

    protected Type typeExpression(CSTNode reduction) {
        String name = this.makeName(reduction, null);
        if (name == null) {
            return Type.DYNAMIC_TYPE;
        }
        return new Type(this.resolveName(name, true));
    }

    protected Expression variableDeclarationExpression(CSTNode reduction) throws ParserException {
        String type = this.resolveName(reduction.get(1));
        if (reduction.size() == 3) {
            CSTNode node = reduction.get(2);
            VariableExpression name = this.variableExpression(node, type);
            Token symbol = Token.newSymbol(100, -1, -1);
            return new BinaryExpression(name, symbol, this.expression(node.get(1)));
        }
        throw new GroovyBugError("NOT YET IMPLEMENTED: generalized variable declarations");
    }

    protected MethodCallExpression methodCallExpression(CSTNode reduction) throws ParserException {
        MethodCallExpression call = null;
        CSTNode descriptor = reduction.get(1);
        Expression context = null;
        boolean implicit = false;
        String method = "call";
        boolean safe = false;
        int type = descriptor.getMeaning();
        switch (type) {
            case 543: {
                context = this.variableExpression(descriptor);
                method = this.identifier(descriptor);
                break;
            }
            case 542: {
                context = VariableExpression.THIS_EXPRESSION;
                method = this.identifier(descriptor);
                break;
            }
            case 440: {
                context = VariableExpression.THIS_EXPRESSION;
                method = this.identifier(descriptor);
                implicit = true;
                break;
            }
            case 70: 
            case 80: {
                context = this.expression(descriptor.get(1));
                method = this.identifier(descriptor.get(2));
                safe = type == 80;
                break;
            }
            default: {
                context = this.expression(descriptor);
            }
        }
        Expression parameters = this.parameterList(reduction.get(2));
        call = new MethodCallExpression(context, method, parameters);
        call.setImplicitThis(implicit);
        call.setSafe(safe);
        return call;
    }

    protected ClosureExpression closureExpression(CSTNode reduction) throws ParserException {
        ClosureExpression expression = null;
        Parameter[] parameters = this.parameterDeclarations(reduction.get(1));
        expression = new ClosureExpression(parameters, this.statementBlock(reduction.get(2)));
        return expression;
    }

    protected Expression parameterList(CSTNode reduction) throws ParserException {
        TupleExpression list = new TupleExpression();
        for (int i = 1; i < reduction.size(); ++i) {
            CSTNode node = reduction.get(i);
            list.addExpression(this.expression(node));
        }
        return list;
    }

    protected Expression newExpression(CSTNode reduction) throws ParserException {
        Expression expression = null;
        CSTNode typeNode = reduction.get(1);
        String type = this.resolveName(typeNode);
        if (typeNode.getMeaning() == 30) {
            CSTNode dimensions = reduction.get(2);
            if (typeNode.get(1).getMeaning() == 30) {
                throw new GroovyBugError("NOT YET IMPLEMENTED: multidimensional arrays");
            }
            type = this.resolveName(typeNode.get(1));
            if (dimensions.isEmpty()) {
                CSTNode data = reduction.get(3);
                if (data.get(1, true).getMeaning() == 820) {
                    throw new GroovyBugError("NOT YET IMPLEMENTED: multidimensional arrays");
                }
                expression = new ArrayExpression(type, this.tupleExpression(data).getExpressions());
            } else {
                if (dimensions.size() > 2) {
                    throw new GroovyBugError("NOT YET IMPLEMENTED: multidimensional arrays");
                }
                expression = new ArrayExpression(type, this.expression(dimensions.get(1)));
            }
        } else {
            Expression parameters = this.parameterList(reduction.get(2));
            if (reduction.size() > 3) {
                throw new GroovyBugError("NOT YET IMPLEMENTED: anonymous classes");
            }
            expression = new ConstructorCallExpression(type, parameters);
        }
        return expression;
    }

    protected TupleExpression tupleExpression(CSTNode reduction) throws ParserException {
        TupleExpression tuple = new TupleExpression();
        for (int i = 1; i < reduction.size(); ++i) {
            CSTNode element = reduction.get(i);
            if (element.getMeaning() == 820) {
                tuple.addExpression(this.tupleExpression(element));
                continue;
            }
            tuple.addExpression(this.expression(element));
        }
        return tuple;
    }

    protected Expression gstringExpression(CSTNode reduction) throws ParserException {
        if (!reduction.hasChildren()) {
            return new ConstantExpression("");
        }
        if (reduction.children() == 1 && reduction.get(1).getMeaning() == 400) {
            return this.expression(reduction.get(1));
        }
        GStringExpression expression = new GStringExpression(reduction.getRootText());
        boolean lastWasExpression = false;
        for (int i = 1; i < reduction.size(); ++i) {
            CSTNode element = reduction.get(i);
            if (element.getMeaning() == 400) {
                ConstantExpression string = new ConstantExpression(element.getRootText());
                string.setCSTNode(element);
                expression.addString(string);
                lastWasExpression = false;
                continue;
            }
            if (lastWasExpression) {
                expression.addString(new ConstantExpression(""));
            }
            lastWasExpression = true;
            expression.addValue(element.isEmpty() ? ConstantExpression.NULL : this.expression(element));
        }
        return expression;
    }

    protected ListExpression listExpression(CSTNode reduction) throws ParserException {
        ListExpression list = new ListExpression();
        for (int i = 1; i < reduction.size(); ++i) {
            list.addExpression(this.expression(reduction.get(i)));
        }
        return list;
    }

    protected MapExpression mapExpression(CSTNode reduction) throws ParserException {
        MapExpression map = new MapExpression();
        for (int i = 1; i < reduction.size(); ++i) {
            CSTNode element = reduction.get(i);
            Expression key = this.expression(element.get(1));
            Expression value = this.expression(element.get(2));
            map.addMapEntryExpression(key, value);
        }
        return map;
    }

    protected String makeName(CSTNode root, String defaultName) {
        if (root == null) {
            return defaultName;
        }
        String name = "";
        switch (root.getMeaning()) {
            case 30: {
                name = this.makeName(root.get(1)) + "[]";
                break;
            }
            case 70: {
                CSTNode node = root;
                while (node.isA(70)) {
                    name = "." + node.get(2).getRootText() + name;
                    node = node.get(1);
                }
                name = node.getRootText() + name;
                break;
            }
            case 0: {
                name = defaultName;
                break;
            }
            default: {
                name = root.getRootText();
            }
        }
        return name;
    }

    protected String makeName(CSTNode root) {
        return this.makeName(root, "");
    }

    protected String identifier(CSTNode identifier) {
        return identifier.getRootText();
    }

    protected String resolveName(CSTNode root, boolean safe) {
        String name = this.makeName(root);
        if (name.length() == 0) {
            return "";
        }
        return this.resolveNewClassOrName(name, safe);
    }

    protected String resolveName(CSTNode root) {
        return this.resolveName(root, true);
    }

    protected int modifiers(CSTNode list) {
        int modifiers = 0;
        block12: for (int i = 1; i < list.size(); ++i) {
            switch (list.get(i).getMeaning()) {
                case 502: {
                    modifiers |= 1;
                    continue block12;
                }
                case 501: {
                    modifiers |= 4;
                    continue block12;
                }
                case 500: {
                    modifiers |= 2;
                    continue block12;
                }
                case 510: {
                    modifiers |= 0x400;
                    continue block12;
                }
                case 511: {
                    modifiers |= 0x10;
                    continue block12;
                }
                case 512: {
                    modifiers |= 0x100;
                    continue block12;
                }
                case 513: {
                    modifiers |= 0x80;
                    continue block12;
                }
                case 514: {
                    modifiers |= 0x40;
                    continue block12;
                }
                case 520: {
                    modifiers |= 0x20;
                    continue block12;
                }
                case 521: {
                    modifiers |= 8;
                    continue block12;
                }
            }
        }
        if ((modifiers & 6) == 0) {
            modifiers |= 1;
        }
        return modifiers;
    }

    protected void error(String description, CSTNode node) throws ParserException {
        throw new ParserException(description, node.getRoot());
    }
}

