/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.adapter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import org.flexdock.docking.adapter.AdapterMapping;
import org.flexdock.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MappingReader {
    public static final String ADAPTER_KEY = "adapter";
    public static final String CLASS_KEY = "class";
    public static final String METHOD_KEY = "method";
    public static final String FLEXDOCK_KEY = "flexdock";
    public static final String CLIENT_KEY = "client";

    public AdapterMapping[] readMappings(Document mappingDoc) {
        if (mappingDoc == null) {
            return new AdapterMapping[0];
        }
        NodeList nodes = mappingDoc.getElementsByTagName(ADAPTER_KEY);
        ArrayList<AdapterMapping> mappings = new ArrayList<AdapterMapping>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elem = (Element)nodes.item(i);
            String className = elem.getAttribute(CLASS_KEY);
            if (className == null) continue;
            AdapterMapping mapping = this.createMapping(elem);
            mapping.setClassName(className);
            mappings.add(mapping);
        }
        return mappings.toArray(new AdapterMapping[0]);
    }

    private AdapterMapping createMapping(Element adapterElem) {
        NodeList nodes = adapterElem.getElementsByTagName(METHOD_KEY);
        String className = adapterElem.getAttribute(CLASS_KEY);
        int len = nodes.getLength();
        Properties p = new Properties();
        for (int i = 0; i < len; ++i) {
            Element elem = (Element)nodes.item(i);
            String key = elem.getAttribute(FLEXDOCK_KEY);
            String value = elem.getAttribute(CLIENT_KEY);
            if (key == null || value == null) continue;
            p.setProperty(key, value);
        }
        return this.createMapping(p);
    }

    private AdapterMapping createMapping(Properties props) {
        Method[] setters = AdapterMapping.class.getMethods();
        AdapterMapping mapping = new AdapterMapping();
        for (int i = 0; i < setters.length; ++i) {
            String key;
            String clientMethod;
            String methodName = setters[i].getName();
            if (!methodName.startsWith("set") || (clientMethod = props.getProperty(key = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4, methodName.length()))) == null) continue;
            Method setter = setters[i];
            try {
                setter.invoke((Object)mapping, clientMethod);
                continue;
            }
            catch (Exception e) {
                Log.warn(e.getMessage(), e);
            }
        }
        return mapping;
    }
}

