/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.MenuComponent;
import java.awt.PopupMenu;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.DockingStrategy;
import org.flexdock.docking.defaults.DefaultDockingStrategy;
import org.flexdock.docking.event.DockingEvent;
import org.flexdock.docking.event.DockingListener;
import org.flexdock.docking.props.DockablePropertySet;
import org.flexdock.docking.props.PropertyManager;
import org.flexdock.plaf.PlafManager;
import org.flexdock.plaf.theme.ViewUI;
import org.flexdock.util.DockingUtility;
import org.flexdock.util.ResourceManager;
import org.flexdock.view.Button;
import org.flexdock.view.Titlebar;
import org.flexdock.view.ViewProps;
import org.flexdock.view.Viewport;

public class View
extends JComponent
implements Dockable,
DockingConstants,
HierarchyListener {
    static final DockingStrategy VIEW_DOCKING_STRATEGY = View.createDockingStrategy();
    protected String id;
    protected Titlebar titlepane;
    protected Container contentPane;
    protected boolean addRemoveAllowed;
    protected ArrayList dockingListeners;
    protected ArrayList dragSources;
    protected HashSet frameDragSources;
    private transient HashSet blockedActions;

    private static DockingStrategy createDockingStrategy() {
        return new DefaultDockingStrategy(){

            protected DockingPort createDockingPortImpl(DockingPort base) {
                return new Viewport();
            }
        };
    }

    public static View getInstance(String viewId) {
        Dockable view = DockingManager.getDockable(viewId);
        return view instanceof View ? (View)view : null;
    }

    public View(String name) {
        this(name, null);
    }

    public View(String name, String title) {
        this(name, title, null);
    }

    public View(String name, String title, String tabText) {
        if (name == null) {
            throw new IllegalArgumentException("The 'name' parameter cannot be null.");
        }
        this.addHierarchyListener(this);
        if (title == null) {
            title = "";
        }
        if (tabText == null) {
            tabText = title;
        }
        this.dragSources = new ArrayList(1);
        this.frameDragSources = new HashSet(1);
        this.dockingListeners = new ArrayList(1);
        this.id = name;
        this.setTabText(tabText);
        this.setLayout(null);
        this.setTitlebar(this.createTitlebar());
        this.setTitle(title);
        this.setContentPane(this.createContentPane());
        this.updateUI();
        DockingManager.registerDockable(this);
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public Titlebar getTitlebar() {
        return this.titlepane;
    }

    public DockablePropertySet getDockingProperties() {
        return PropertyManager.getDockablePropertySet(this);
    }

    public ViewProps getViewProperties() {
        return (ViewProps)this.getDockingProperties();
    }

    public void addAction(Action action) {
        if (this.titlepane != null) {
            this.titlepane.addAction(action);
        }
    }

    public void addAction(String action) {
        if (this.titlepane != null) {
            this.titlepane.addAction(action);
        }
    }

    public void setIcon(Icon icon) {
        if (this.titlepane != null) {
            this.titlepane.setIcon(icon);
        }
    }

    public void setIcon(String imgUri) {
        ImageIcon icon = imgUri == null ? null : ResourceManager.createIcon(imgUri);
        this.setIcon(icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentPane(Container c) {
        if (c == null) {
            throw new NullPointerException("Unable to set a null content pane.");
        }
        if (c == this.titlepane) {
            throw new IllegalArgumentException("Cannot use the same component as both content pane and titlebar.");
        }
        View view = this;
        synchronized (view) {
            this.addRemoveAllowed = true;
            if (this.contentPane != null) {
                this.removeImpl(this.contentPane);
            }
            this.addImpl(c);
            this.contentPane = c;
            this.addRemoveAllowed = false;
        }
    }

    protected Container createContentPane() {
        return new JPanel();
    }

    protected Titlebar createTitlebar() {
        return new Titlebar();
    }

    protected String getPreferredTitlebarUIName() {
        return this.ui instanceof ViewUI ? ((ViewUI)this.ui).getPreferredTitlebarUI() : null;
    }

    private void removeImpl(Component c) {
        if (c instanceof Titlebar) {
            ((Titlebar)c).setView(null);
        }
        super.remove(c);
    }

    private void addImpl(Component c) {
        if (c instanceof Titlebar) {
            ((Titlebar)c).setView(this);
        }
        super.add(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitlebar(Titlebar titlebar) {
        if (titlebar != null) {
            if (titlebar == this.contentPane) {
                throw new IllegalArgumentException("Cannot use the same component as both content pane and titlebar.");
            }
            if (!(titlebar instanceof Component)) {
                throw new IllegalArgumentException("Titlebar must be a type of java.awt.Component.");
            }
        }
        View view = this;
        synchronized (view) {
            this.addRemoveAllowed = true;
            this.removeTitlebarImpl();
            this.addTitlebarImpl(titlebar);
            this.titlepane = titlebar;
            this.addRemoveAllowed = false;
        }
    }

    protected void addTitlebarImpl(Titlebar titlebar) {
        if (titlebar != null) {
            this.addImpl(titlebar);
            this.dragSources.add(titlebar);
            this.frameDragSources.add(titlebar);
            DockingManager.updateDragListeners(this);
        }
    }

    protected void removeTitlebarImpl() {
        if (this.titlepane != null) {
            this.removeImpl(this.titlepane);
            this.dragSources.remove(this.titlepane);
            this.frameDragSources.remove(this.titlepane);
            DockingManager.removeDragListeners(this.titlepane);
        }
    }

    protected Component getTitlePane() {
        return this.titlepane;
    }

    public void setTitle(String title) {
        this.setTitle(title, false);
    }

    public void setTitle(String title, boolean alsoTabText) {
        Titlebar tbar = this.getTitlebar();
        if (tbar != null) {
            tbar.setText(title);
        }
        if (alsoTabText) {
            this.setTabText(title);
        }
    }

    public String getTitle() {
        Titlebar tbar = this.getTitlebar();
        return tbar == null ? null : tbar.getText();
    }

    public void doLayout() {
        Component titlebar = this.getTitlePane();
        int titleHeight = titlebar == null ? 0 : this.titlepane.getPreferredSize().height;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.titlepane != null) {
            this.titlepane.setBounds(0, 0, w, titleHeight);
        }
        this.contentPane.setBounds(0, titleHeight, w, h - titleHeight);
    }

    public void updateUI() {
        this.setUI(PlafManager.getUI(this));
    }

    public Component add(Component comp, int index) {
        if (!this.addRemoveAllowed) {
            throw new RuntimeException("The add() method is may not be called directly.  Use setContentPane() instead.");
        }
        return super.add(comp, index);
    }

    public void add(Component comp, Object constraints, int index) {
        if (!this.addRemoveAllowed) {
            throw new RuntimeException("The add() method is may not be called directly.  Use setContentPane() instead.");
        }
        super.add(comp, constraints, index);
    }

    public void add(Component comp, Object constraints) {
        if (!this.addRemoveAllowed) {
            throw new RuntimeException("The add() method is may not be called directly.  Use setContentPane() instead.");
        }
        super.add(comp, constraints);
    }

    public Component add(Component comp) {
        if (!this.addRemoveAllowed) {
            throw new RuntimeException("The add() method is may not be called directly.  Use setContentPane() instead.");
        }
        return super.add(comp);
    }

    public Component add(String name, Component comp) {
        if (!this.addRemoveAllowed) {
            throw new RuntimeException("The add() method is may not be called directly.  Use setContentPane() instead.");
        }
        return super.add(name, comp);
    }

    public synchronized void add(PopupMenu popup) {
        if (!this.addRemoveAllowed) {
            throw new RuntimeException("The add() method is may not be called directly.  Use setContentPane() instead.");
        }
        super.add(popup);
    }

    public void remove(Component comp) {
        if (!this.addRemoveAllowed) {
            throw new RuntimeException("The remove() method is may not be called directly.");
        }
        super.remove(comp);
    }

    public void remove(int index) {
        if (!this.addRemoveAllowed) {
            throw new RuntimeException("The remove() method is may not be called directly.");
        }
        super.remove(index);
    }

    public void removeAll() {
        if (!this.addRemoveAllowed) {
            throw new RuntimeException("The remove() method is may not be called directly.");
        }
        super.removeAll();
    }

    public synchronized void remove(MenuComponent popup) {
        if (!this.addRemoveAllowed) {
            throw new RuntimeException("The remove() method is may not be called directly.");
        }
        super.remove(popup);
    }

    public AbstractButton getActionButton(String actionName) {
        Titlebar tbar = this.getTitlebar();
        return tbar == null ? null : tbar.getActionButton(actionName);
    }

    public Component getComponent() {
        return this;
    }

    public List getDragSources() {
        return this.dragSources;
    }

    public Set getFrameDragSources() {
        return this.frameDragSources;
    }

    public String getPersistentId() {
        return this.id;
    }

    public boolean isTerritoryBlocked(Dockable dockable, String region) {
        return this.getDockingProperties().isTerritoryBlocked(region);
    }

    public void setTerritoryBlocked(String region, boolean blocked) {
        this.getDockingProperties().setTerritoryBlocked(region, blocked);
    }

    public String getTabText() {
        String txt = this.getDockingProperties().getDockableDesc();
        return txt == null ? this.getTitle() : txt;
    }

    public void setTabText(String tabText) {
        this.getDockingProperties().setDockableDesc(tabText);
    }

    public Icon getTabIcon() {
        return this.getDockingProperties().getTabIcon();
    }

    public void setTabIcon(Icon icon) {
        this.getDockingProperties().setTabIcon(icon);
    }

    public boolean dock(Dockable dockable) {
        return this.dock(dockable, "CENTER");
    }

    public DockingPort getDockingPort() {
        return DockingManager.getDockingPort(this);
    }

    public Dockable getSibling(String region) {
        return DefaultDockingStrategy.getSibling(this, region);
    }

    public Viewport getViewport() {
        DockingPort port = this.getDockingPort();
        return port instanceof Viewport ? (Viewport)port : null;
    }

    public boolean dock(Dockable dockable, String relativeRegion) {
        return DockingManager.dock(dockable, this, relativeRegion);
    }

    public boolean dock(Dockable dockable, String relativeRegion, float ratio) {
        return DockingManager.dock(dockable, this, relativeRegion, ratio);
    }

    public void setActive(boolean b) {
        this.getViewProperties().setActive(b);
    }

    public boolean isActive() {
        return this.getViewProperties().isActive();
    }

    public void setActiveStateLocked(boolean b) {
        this.getViewProperties().setActiveStateLocked(b);
    }

    public boolean isActiveStateLocked() {
        return this.getViewProperties().isActiveStateLocked();
    }

    public boolean isMinimized() {
        return DockingUtility.isMinimized(this);
    }

    public int getMinimizedConstraint() {
        return DockingUtility.getMinimizedConstraint(this);
    }

    public void addDockingListener(DockingListener listener) {
        this.dockingListeners.add(listener);
    }

    public DockingListener[] getDockingListeners() {
        return this.dockingListeners.toArray(new DockingListener[0]);
    }

    public void removeDockingListener(DockingListener listener) {
        this.dockingListeners.remove(listener);
    }

    public void dockingCanceled(DockingEvent evt) {
    }

    public void dockingComplete(DockingEvent evt) {
        this.setActionBlocked("pin", this.isFloating());
        if (this.titlepane != null) {
            this.titlepane.revalidate();
        }
    }

    public void dragStarted(DockingEvent evt) {
    }

    public void dropStarted(DockingEvent evt) {
    }

    public void undockingComplete(DockingEvent evt) {
        this.clearButtonRollovers();
    }

    public void undockingStarted(DockingEvent evt) {
    }

    private void clearButtonRollovers() {
        if (this.titlepane == null) {
            return;
        }
        Component[] comps = this.titlepane.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Button button;
            Button button2 = button = comps[i] instanceof Button ? (Button)comps[i] : null;
            if (button == null) continue;
            button.getModel().setRollover(false);
        }
    }

    public void setActionBlocked(String actionName, boolean blocked) {
        if (actionName == null) {
            return;
        }
        HashSet actions = this.getBlockedActions();
        if (blocked) {
            actions.add(actionName);
        } else if (actions != null) {
            actions.remove(actionName);
        }
    }

    public boolean isActionBlocked(String actionName) {
        return actionName == null || this.blockedActions == null ? false : this.blockedActions.contains(actionName);
    }

    private HashSet getBlockedActions() {
        if (this.blockedActions == null) {
            this.blockedActions = new HashSet(1);
        }
        return this.blockedActions;
    }

    public boolean isFloating() {
        return DockingUtility.isFloating(this);
    }

    public String toString() {
        return "View[Id=" + this.id + "]";
    }

    public void hierarchyChanged(HierarchyEvent e) {
        this.clearButtonRollovers();
    }

    static {
        DockingManager.setDockingStrategy(View.class, VIEW_DOCKING_STRATEGY);
        PropertyManager.setDockablePropertyType(View.class, ViewProps.class);
    }
}

