/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.engine.TypedValue;
import org.hibernate.impl.FilterImpl;
import org.hibernate.type.Type;

public final class FilterKey {
    private String filterName;
    private Map filterParameters = new HashMap();

    public FilterKey(String name, Map params, Map types, EntityMode entityMode) {
        this.filterName = name;
        Iterator iter = params.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            Type type = (Type)types.get(me.getKey());
            this.filterParameters.put(me.getKey(), new TypedValue(type, me.getValue(), entityMode));
        }
    }

    public int hashCode() {
        int result = 13;
        result = 37 * result + this.filterName.hashCode();
        result = 37 * result + ((Object)this.filterParameters).hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof FilterKey)) {
            return false;
        }
        FilterKey that = (FilterKey)other;
        if (!that.filterName.equals(this.filterName)) {
            return false;
        }
        return ((Object)that.filterParameters).equals(this.filterParameters);
    }

    public String toString() {
        return "FilterKey[" + this.filterName + this.filterParameters + ']';
    }

    public static Set createFilterKeys(Map enabledFilters, EntityMode entityMode) {
        if (enabledFilters.size() == 0) {
            return null;
        }
        HashSet<FilterKey> result = new HashSet<FilterKey>();
        Iterator iter = enabledFilters.values().iterator();
        while (iter.hasNext()) {
            FilterImpl filter = (FilterImpl)iter.next();
            FilterKey key = new FilterKey(filter.getName(), filter.getParameters(), filter.getParameterTypes(), entityMode);
            result.add(key);
        }
        return result;
    }
}

