/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import org.aopalliance.aop.AspectException;

public abstract class AopContext {
    private static ThreadLocal currentProxy = new ThreadLocal();

    public static Object currentProxy() throws AspectException {
        if (currentProxy.get() == null) {
            String mesg = "Cannot find proxy: set 'exposeProxy' property on Advised to true to make it available";
            throw new AspectException(mesg, new Throwable(mesg));
        }
        return currentProxy.get();
    }

    public static Object setCurrentProxy(Object proxy) {
        Object old = currentProxy.get();
        currentProxy.set(proxy);
        return old;
    }
}

