/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.util.LittleEndian;

public class ExternSheetSubRecord
extends Record {
    public static final short sid = 4095;
    private short field_1_index_to_supbook;
    private short field_2_index_to_first_supbook_sheet;
    private short field_3_index_to_last_supbook_sheet;

    public ExternSheetSubRecord() {
    }

    public ExternSheetSubRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ExternSheetSubRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public void setIndexToSupBook(short index) {
        this.field_1_index_to_supbook = index;
    }

    public short getIndexToSupBook() {
        return this.field_1_index_to_supbook;
    }

    public void setIndexToFirstSupBook(short index) {
        this.field_2_index_to_first_supbook_sheet = index;
    }

    public short getIndexToFirstSupBook() {
        return this.field_2_index_to_first_supbook_sheet;
    }

    public void setIndexToLastSupBook(short index) {
        this.field_3_index_to_last_supbook_sheet = index;
    }

    public short getIndexToLastSupBook() {
        return this.field_3_index_to_last_supbook_sheet;
    }

    protected void validateSid(short id) {
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_index_to_supbook = LittleEndian.getShort(data, 0 + offset);
        this.field_2_index_to_first_supbook_sheet = LittleEndian.getShort(data, 2 + offset);
        this.field_3_index_to_last_supbook_sheet = LittleEndian.getShort(data, 4 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("   supbookindex =").append(this.getIndexToSupBook()).append('\n');
        buffer.append("   1stsbindex   =").append(this.getIndexToFirstSupBook()).append('\n');
        buffer.append("   lastsbindex  =").append(this.getIndexToLastSupBook()).append('\n');
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, this.getIndexToSupBook());
        LittleEndian.putShort(data, 2 + offset, this.getIndexToFirstSupBook());
        LittleEndian.putShort(data, 4 + offset, this.getIndexToLastSupBook());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4095;
    }
}

