/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.crosstab.gui;

import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.box.BoxPanel;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class CrosstabCellDialog
extends JDialog {
    private CrosstabCell tmpCell = null;
    private BoxPanel boxPanel = null;
    private Color bgcolor = null;
    private JButton jButtonBackground;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxTransparent;
    private JComboBox jComboBoxstyles;
    private JLabel jLabel1;
    private JLabel jLabelHeight;
    private JLabel jLabelStyle;
    private JLabel jLabelWidth;
    private JLabel jLabelWidth1;
    private JNumberField jNumberFieldHeight;
    private JNumberField jNumberFieldWidth;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanelBorder;
    private JSeparator jSeparator1;
    private int dialogResult;

    public CrosstabCellDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public CrosstabCellDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.boxPanel = new BoxPanel();
        this.boxPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabCellDialog.this.boxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.jPanelBorder.add((Component)this.boxPanel, gridBagConstraints);
        this.pack();
        Misc.centerFrame(this);
        Font font = this.jLabel1.getFont();
        this.jLabel1.setFont(new Font(font.getFontName(), 1, 14));
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                CrosstabCellDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public void boxActionPerformed(ActionEvent evt) {
    }

    private void initComponents() {
        this.jLabelWidth = new JLabel();
        this.jNumberFieldWidth = new JNumberField();
        this.jLabelHeight = new JLabel();
        this.jNumberFieldHeight = new JNumberField();
        this.jPanelBorder = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabelWidth1 = new JLabel();
        this.jButtonBackground = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jCheckBoxTransparent = new JCheckBox();
        this.jLabelStyle = new JLabel();
        this.jComboBoxstyles = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Modify cell");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CrosstabCellDialog.this.closeDialog(evt);
            }
        });
        this.jLabelWidth.setHorizontalAlignment(4);
        this.jLabelWidth.setText("Column width");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 3, 3);
        this.getContentPane().add((Component)this.jLabelWidth, gridBagConstraints);
        this.jNumberFieldWidth.setColumns(4);
        this.jNumberFieldWidth.setHorizontalAlignment(4);
        try {
            this.jNumberFieldWidth.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.jNumberFieldWidth.setMinimumSize(new Dimension(40, 21));
        this.jNumberFieldWidth.setPreferredSize(new Dimension(38, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jNumberFieldWidth, gridBagConstraints);
        this.jLabelHeight.setHorizontalAlignment(4);
        this.jLabelHeight.setText("Row height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 3, 3);
        this.getContentPane().add((Component)this.jLabelHeight, gridBagConstraints);
        this.jNumberFieldHeight.setColumns(4);
        this.jNumberFieldHeight.setHorizontalAlignment(4);
        try {
            this.jNumberFieldHeight.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.jNumberFieldHeight.setMinimumSize(new Dimension(40, 21));
        this.jNumberFieldHeight.setPreferredSize(new Dimension(38, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 6, 3);
        this.getContentPane().add((Component)this.jNumberFieldHeight, gridBagConstraints);
        this.jPanelBorder.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanelBorder, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabelWidth1.setText("Cell background color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 14, 3, 3);
        this.jPanel2.add((Component)this.jLabelWidth1, gridBagConstraints);
        this.jButtonBackground.setBackground(new Color(0, 0, 0));
        this.jButtonBackground.setMaximumSize(new Dimension(45, 20));
        this.jButtonBackground.setMinimumSize(new Dimension(45, 20));
        this.jButtonBackground.setPreferredSize(new Dimension(45, 20));
        this.jButtonBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabCellDialog.this.jButtonBackgroundActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonBackground, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(126, 40));
        this.jPanel1.setPreferredSize(new Dimension(126, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabCellDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 14;
        this.jPanel1.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabCellDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setText("Cell name");
        this.jLabel1.setMaximumSize(new Dimension(34, 23));
        this.jLabel1.setMinimumSize(new Dimension(34, 23));
        this.jLabel1.setPreferredSize(new Dimension(34, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jCheckBoxTransparent.setText("Transparent");
        this.jCheckBoxTransparent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxTransparent.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 14, 0, 0);
        this.getContentPane().add((Component)this.jCheckBoxTransparent, gridBagConstraints);
        this.jLabelStyle.setHorizontalAlignment(4);
        this.jLabelStyle.setText("Cell style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 40;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 3, 3);
        this.getContentPane().add((Component)this.jLabelStyle, gridBagConstraints);
        this.jComboBoxstyles.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxstyles.setPreferredSize(new Dimension(200, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 40;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jComboBoxstyles, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonBackgroundActionPerformed(ActionEvent evt) {
        this.bgcolor = JColorChooser.showDialog(null, "Select background color...", this.jButtonBackground.getBackground());
        if (this.bgcolor != null) {
            this.jButtonBackground.setBackground(this.bgcolor);
        } else {
            this.bgcolor = this.jButtonBackground.getBackground();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.tmpCell = new CrosstabCell();
        this.tmpCell.setBox(this.boxPanel.getBox());
        this.tmpCell.setWidth((int)this.jNumberFieldWidth.getValue());
        this.tmpCell.setHeight((int)this.jNumberFieldHeight.getValue());
        this.tmpCell.setBackcolor(this.bgcolor);
        this.tmpCell.setMode(this.jCheckBoxTransparent.isSelected() ? "Transparent" : "Opaque");
        if (this.jComboBoxstyles.getSelectedIndex() > 0) {
            this.tmpCell.setStyle((Style)this.jComboBoxstyles.getSelectedItem());
        }
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public CrosstabCell getTmpCell() {
        return this.tmpCell;
    }

    public void setTmpCell(CrosstabCell selectedCell) {
        this.jComboBoxstyles.removeAllItems();
        this.jComboBoxstyles.addItem("");
        Vector styles = MainFrame.getMainInstance().getActiveReportFrame().getReport().getStyles();
        for (int i = 0; i < styles.size(); ++i) {
            this.jComboBoxstyles.addItem(styles.elementAt(i));
        }
        this.setBgcolor(selectedCell.getBackcolor());
        if (this.bgcolor != null) {
            this.jButtonBackground.setBackground(this.bgcolor);
        } else {
            this.jButtonBackground.setBackground(Color.WHITE);
        }
        this.jLabel1.setText(selectedCell.getName());
        this.boxPanel.setBox(selectedCell.getBox().cloneMe());
        this.jCheckBoxTransparent.setSelected(selectedCell.getMode().equals("Transparent"));
        if (selectedCell.getTopIndex() < selectedCell.getBottomIndex() - 1) {
            this.jNumberFieldHeight.setEditable(false);
        }
        if (selectedCell.getLeftIndex() < selectedCell.getRightIndex() - 1) {
            this.jNumberFieldWidth.setEditable(false);
        }
        try {
            this.jNumberFieldWidth.setValue(selectedCell.getWidth());
            this.jNumberFieldHeight.setValue(selectedCell.getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (selectedCell.getStyle() != null) {
            this.jComboBoxstyles.setSelectedItem(selectedCell.getStyle());
        } else {
            this.jComboBoxstyles.setSelectedIndex(0);
        }
    }

    public BoxPanel getBoxPanel() {
        return this.boxPanel;
    }

    public void setBoxPanel(BoxPanel boxPanel) {
        this.boxPanel = boxPanel;
    }

    public Color getBgcolor() {
        return this.bgcolor;
    }

    public void setBgcolor(Color bgcolor) {
        this.bgcolor = bgcolor;
    }
}

