/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.crosstabs.fill.JRPercentageCalculator;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRCalculable;

public class JRPercentageCalculatorFactory {
    private static final Map builtInCalculators = new HashMap();
    private static final Map cachedCalculators;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    public static boolean hasBuiltInCalculator(Class valueClass) {
        return builtInCalculators.containsKey(valueClass.getName());
    }

    public static JRPercentageCalculator getPercentageCalculator(Class percentageCalculatorClass, Class valueClass) {
        JRPercentageCalculator calculator;
        if (percentageCalculatorClass == null) {
            calculator = (JRPercentageCalculator)builtInCalculators.get(valueClass.getName());
            if (calculator == null) {
                throw new JRRuntimeException("Measure with type " + valueClass.getName() + " should specify a percentage calculator class.");
            }
        } else {
            calculator = (JRPercentageCalculator)cachedCalculators.get(percentageCalculatorClass.getName());
            if (calculator == null) {
                try {
                    calculator = (JRPercentageCalculator)percentageCalculatorClass.newInstance();
                    cachedCalculators.put(percentageCalculatorClass.getName(), calculator);
                }
                catch (InstantiationException e) {
                    throw new JRRuntimeException("Error while creating percentage calculator instance of " + percentageCalculatorClass + ".", e);
                }
                catch (IllegalAccessException e) {
                    throw new JRRuntimeException("Error while creating percentage calculator instance of " + percentageCalculatorClass + ".", e);
                }
            }
        }
        return calculator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        builtInCalculators.put((class$java$lang$Float == null ? (class$java$lang$Float = JRPercentageCalculatorFactory.class$("java.lang.Float")) : class$java$lang$Float).getName(), new FloatPercentageCalculator());
        builtInCalculators.put((class$java$lang$Double == null ? (class$java$lang$Double = JRPercentageCalculatorFactory.class$("java.lang.Double")) : class$java$lang$Double).getName(), new DoublePercentageCalculator());
        builtInCalculators.put((class$java$lang$Integer == null ? (class$java$lang$Integer = JRPercentageCalculatorFactory.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), new IntegerPercentageCalculator());
        builtInCalculators.put((class$java$lang$Long == null ? (class$java$lang$Long = JRPercentageCalculatorFactory.class$("java.lang.Long")) : class$java$lang$Long).getName(), new LongPercentageCalculator());
        builtInCalculators.put((class$java$lang$Short == null ? (class$java$lang$Short = JRPercentageCalculatorFactory.class$("java.lang.Short")) : class$java$lang$Short).getName(), new ShortPercentageCalculator());
        builtInCalculators.put((class$java$lang$Byte == null ? (class$java$lang$Byte = JRPercentageCalculatorFactory.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), new BytePercentageCalculator());
        builtInCalculators.put((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRPercentageCalculatorFactory.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName(), new BigDecimalPercentageCalculator());
        builtInCalculators.put((class$java$math$BigInteger == null ? (class$java$math$BigInteger = JRPercentageCalculatorFactory.class$("java.math.BigInteger")) : class$java$math$BigInteger).getName(), new BigIntegerPercentageCalculator());
        cachedCalculators = new HashMap();
    }

    public static class BigIntegerPercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable value, JRCalculable total) {
            BigInteger totalVal = (BigInteger)total.getValue();
            BigInteger val = (BigInteger)value.getValue();
            BigInteger percentage = totalVal != null && totalVal.doubleValue() != 0.0 ? val.multiply(BigInteger.valueOf(100L)).divide(totalVal) : BigInteger.valueOf(0L);
            return percentage;
        }
    }

    public static class BigDecimalPercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable value, JRCalculable total) {
            BigDecimal totalVal = (BigDecimal)total.getValue();
            BigDecimal val = (BigDecimal)value.getValue();
            BigDecimal percentage = totalVal != null && totalVal.doubleValue() != 0.0 ? val.multiply(BigDecimal.valueOf(100L)).divide(totalVal, 4) : BigDecimal.valueOf(0L);
            return percentage;
        }
    }

    public static class DoublePercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable value, JRCalculable total) {
            Double totalVal = (Double)total.getValue();
            Double val = (Double)value.getValue();
            double percentage = 0.0;
            if (totalVal != null && totalVal != 0.0) {
                percentage = 100.0 * val / totalVal;
            }
            return new Double(percentage);
        }
    }

    public static class FloatPercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable value, JRCalculable total) {
            Float totalVal = (Float)total.getValue();
            Float val = (Float)value.getValue();
            float percentage = 0.0f;
            if (totalVal != null && totalVal.floatValue() != 0.0f) {
                percentage = 100.0f * val.floatValue() / totalVal.floatValue();
            }
            return new Float(percentage);
        }
    }

    public static class LongPercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable value, JRCalculable total) {
            Long totalVal = (Long)total.getValue();
            Long val = (Long)value.getValue();
            long percentage = 0L;
            if (totalVal != null && totalVal != 0L) {
                percentage = 100L * val / totalVal;
            }
            return new Long(percentage);
        }
    }

    public static class IntegerPercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable value, JRCalculable total) {
            Integer totalVal = (Integer)total.getValue();
            Integer val = (Integer)value.getValue();
            int percentage = 0;
            if (totalVal != null && totalVal != 0) {
                percentage = 100 * val / totalVal;
            }
            return new Integer(percentage);
        }
    }

    public static class ShortPercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable value, JRCalculable total) {
            Short totalVal = (Short)total.getValue();
            Short val = (Short)value.getValue();
            short percentage = 0;
            if (totalVal != null && totalVal != 0) {
                percentage = (short)(100 * val / totalVal);
            }
            return new Short(percentage);
        }
    }

    public static class BytePercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable value, JRCalculable total) {
            Byte totalVal = (Byte)total.getValue();
            Byte val = (Byte)value.getValue();
            byte percentage = 0;
            if (totalVal != null && totalVal != 0) {
                percentage = (byte)(100 * val / totalVal);
            }
            return new Byte(percentage);
        }
    }
}

