/*
 * Decompiled with CFR 0.152.
 */
package mondrian.recorder;

import java.io.PrintStream;
import mondrian.recorder.AbstractRecorder;

public class PrintStreamRecorder
extends AbstractRecorder {
    private final PrintStream err;
    private final PrintStream out;

    public PrintStreamRecorder() {
        this(System.out, System.err);
    }

    public PrintStreamRecorder(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    protected void recordMessage(String msg, Object info, int msgType) {
        PrintStream ps = null;
        String prefix = null;
        switch (msgType) {
            case 1: {
                prefix = "INFO: ";
                ps = this.out;
                break;
            }
            case 2: {
                prefix = "WARN: ";
                ps = this.out;
                break;
            }
            case 3: {
                prefix = "ERROR: ";
                ps = this.err;
                break;
            }
            default: {
                prefix = "UNKNOWN: ";
            }
        }
        String context = this.getContext();
        ps.print(prefix);
        ps.print(context);
        ps.print(": ");
        ps.println(msg);
    }
}

