/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Literal;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.Util;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapNativeSql;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.sql.SqlQuery;

public class RolapNativeTopCount
extends RolapNativeSet {
    boolean ascending;

    public RolapNativeTopCount() {
        super.setEnabled(MondrianProperties.instance().EnableNativeTopCount.get());
    }

    protected boolean isStrict() {
        return true;
    }

    /*
     * Loose catch block
     */
    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        RolapNativeSet.SetEvaluator setEvaluator;
        Connection con;
        block20: {
            String orderByExpr;
            RolapSchemaReader schemaReader;
            int count;
            RolapNativeSet.CrossJoinArg[] cargs;
            block18: {
                NativeEvaluator nativeEvaluator;
                block19: {
                    if (!this.isEnabled()) {
                        return null;
                    }
                    String funName = fun.getName();
                    if ("TopCount".equalsIgnoreCase(funName)) {
                        this.ascending = false;
                    } else if ("BottomCount".equalsIgnoreCase(funName)) {
                        this.ascending = true;
                    } else {
                        return null;
                    }
                    if (args.length < 2 || args.length > 3) {
                        return null;
                    }
                    cargs = this.checkCrossJoinArg(args[0]);
                    if (cargs == null) {
                        return null;
                    }
                    if (this.isPreferInterpreter(cargs)) {
                        return null;
                    }
                    if (!(args[1] instanceof Literal)) {
                        return null;
                    }
                    count = ((Literal)args[1]).getIntValue();
                    schemaReader = (RolapSchemaReader)evaluator.getSchemaReader();
                    DataSource ds = schemaReader.getDataSource();
                    con = null;
                    con = ds.getConnection();
                    SqlQuery sqlQuery = SqlTupleReader.newQuery(con, "NativeTopCount");
                    RolapNativeSql sql = new RolapNativeSql(sqlQuery);
                    orderByExpr = null;
                    if (args.length != 3 || (orderByExpr = sql.generateTopCountOrderBy(args[2])) != null) break block18;
                    nativeEvaluator = null;
                    Object var17_16 = null;
                    if (con == null) break block19;
                    try {
                        con.close();
                    }
                    catch (SQLException e2) {
                        LOGGER.error(null, (Throwable)e2);
                    }
                }
                return nativeEvaluator;
            }
            LOGGER.info((Object)"using native topcount");
            TopCountConstraint constraint = new TopCountConstraint(cargs, evaluator, orderByExpr);
            RolapNativeSet.SetEvaluator sev = new RolapNativeSet.SetEvaluator(cargs, schemaReader, constraint);
            sev.setMaxRows(count);
            setEvaluator = sev;
            Object var17_17 = null;
            if (con == null) break block20;
            try {
                con.close();
            }
            catch (SQLException e2) {
                LOGGER.error(null, (Throwable)e2);
            }
        }
        return setEvaluator;
        catch (SQLException e) {
            try {
                throw Util.newInternal(e, "RolapNativeTopCount");
            }
            catch (Throwable throwable) {
                block21: {
                    Object var17_18 = null;
                    if (con == null) break block21;
                    try {
                        con.close();
                    }
                    catch (SQLException e2) {
                        LOGGER.error(null, (Throwable)e2);
                    }
                }
                throw throwable;
            }
        }
    }

    class TopCountConstraint
    extends RolapNativeSet.SetConstraint {
        String orderByExpr;

        public TopCountConstraint(RolapNativeSet.CrossJoinArg[] args, RolapEvaluator evaluator, String orderByExpr) {
            super(args, evaluator, true);
            this.orderByExpr = orderByExpr;
        }

        protected boolean isJoinRequired() {
            return true;
        }

        public void addConstraint(SqlQuery sqlQuery) {
            if (this.orderByExpr != null) {
                SqlQuery.Dialect dialect = sqlQuery.getDialect();
                if (dialect.isMySQL() || dialect.isDB2()) {
                    String alias = sqlQuery.nextColumnAlias();
                    alias = dialect.quoteIdentifier(alias);
                    sqlQuery.addSelect(this.orderByExpr, alias);
                    sqlQuery.addOrderBy(alias, RolapNativeTopCount.this.ascending, true);
                } else {
                    sqlQuery.addOrderBy(this.orderByExpr, RolapNativeTopCount.this.ascending, true);
                }
            }
            super.addConstraint(sqlQuery);
        }

        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            key.add(this.orderByExpr);
            key.add(RolapNativeTopCount.this.ascending);
            return key;
        }
    }
}

