/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Hierarchy;
import mondrian.olap.HierarchyBase;
import mondrian.olap.Level;
import mondrian.olap.LevelType;
import mondrian.olap.Member;
import mondrian.olap.Property;
import mondrian.olap.Role;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RolapCube;
import mondrian.util.SAXHandler;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.Enumeration;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.Rowset;
import mondrian.xmla.XmlaMediator;
import org.xml.sax.SAXException;

abstract class RowsetDefinition
extends EnumeratedValues.BasicValue {
    final Column[] columnDefinitions;
    private static final String nl = Util.nl;
    public static final int DISCOVER_DATASOURCES = 0;
    public static final int DISCOVER_PROPERTIES = 1;
    public static final int DISCOVER_SCHEMA_ROWSETS = 2;
    public static final int DISCOVER_ENUMERATORS = 3;
    public static final int DISCOVER_KEYWORDS = 4;
    public static final int DISCOVER_LITERALS = 5;
    public static final int DBSCHEMA_CATALOGS = 6;
    public static final int DBSCHEMA_COLUMNS = 7;
    public static final int DBSCHEMA_PROVIDER_TYPES = 8;
    public static final int DBSCHEMA_TABLES = 9;
    public static final int DBSCHEMA_TABLES_INFO = 10;
    public static final int MDSCHEMA_ACTIONS = 11;
    public static final int MDSCHEMA_CUBES = 12;
    public static final int MDSCHEMA_DIMENSIONS = 13;
    public static final int MDSCHEMA_FUNCTIONS = 14;
    public static final int MDSCHEMA_HIERARCHIES = 15;
    public static final int MDSCHEMA_LEVELS = 16;
    public static final int MDSCHEMA_MEASURES = 17;
    public static final int MDSCHEMA_MEMBERS = 18;
    public static final int MDSCHEMA_PROPERTIES = 19;
    public static final int MDSCHEMA_SETS = 20;
    public static final int OTHER = 21;
    public static final EnumeratedValues enumeration = new EnumeratedValues(new RowsetDefinition[]{DiscoverDatasourcesRowset.definition, DiscoverEnumeratorsRowset.definition, DiscoverPropertiesRowset.definition, DiscoverSchemaRowsetsRowset.access$000(), DiscoverKeywordsRowset.definition, DiscoverLiteralsRowset.definition, DbschemaCatalogsRowset.definition, DbschemaColumnsRowset.definition, DbschemaProviderTypesRowset.definition, DbschemaTablesRowset.definition, DbschemaTablesInfoRowset.definition, MdschemaActionsRowset.definition, MdschemaCubesRowset.definition, MdschemaDimensionsRowset.definition, MdschemaFunctionsRowset.definition, MdschemaHierarchiesRowset.definition, MdschemaLevelsRowset.definition, MdschemaMeasuresRowset.definition, MdschemaMembersRowset.definition, MdschemaPropertiesRowset.definition, MdschemaSetsRowset.definition});

    RowsetDefinition(String name, int ordinal, String description, Column[] columnDefinitions) {
        super(name, ordinal, description);
        this.columnDefinitions = columnDefinitions;
    }

    public static RowsetDefinition getValue(String name) {
        return (RowsetDefinition)enumeration.getValue(name, true);
    }

    public abstract Rowset getRowset(HashMap var1, Properties var2);

    public Column lookupColumn(String name) {
        for (int i = 0; i < this.columnDefinitions.length; ++i) {
            Column columnDefinition = this.columnDefinitions[i];
            if (!columnDefinition.name.equals(name)) continue;
            return columnDefinition;
        }
        return null;
    }

    static int getDimensionType(Dimension dim) {
        if (dim.isMeasures()) {
            return 2;
        }
        if (DimensionType.TimeDimension.equals(dim.getDimensionType())) {
            return 1;
        }
        return 3;
    }

    static /* synthetic */ String access$100() {
        return nl;
    }

    static class MdschemaPropertiesRowset
    extends Rowset {
        private static final int MDPROP_MEMBER = 1;
        private static final int MDPROP_CELL = 2;
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, null);
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, null);
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, null);
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, null);
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, false, null);
        private static final Column MemberUniqueName = new Column("MEMBER_UNIQUE_NAME", Type.String, null, true, true, null);
        private static final Column PropertyName = new Column("PROPERTY_NAME", Type.String, null, true, false, null);
        private static final Column PropertyType = new Column("PROPERTY_TYPE", Type.Integer, null, true, false, null);
        private static final Column PropertyContentType = new Column("PROPERTY_CONTENT_TYPE", Type.Integer, null, true, false, null);
        private static final Column PropertyCaption = new Column("PROPERTY_CAPTION", Type.String, null, true, false, null);
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_PROPERTIES", 19, null, new Column[]{CatalogName, SchemaName, CubeName, DimensionUniqueName, HierarchyUniqueName, LevelUniqueName, MemberUniqueName, PropertyName, PropertyType, PropertyContentType, PropertyCaption}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new MdschemaPropertiesRowset(restrictions, properties);
            }
        };

        MdschemaPropertiesRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            Connection connection = XmlaMediator.getConnection(this.properties);
            Cube[] cubes = connection.getSchema().getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                Cube cube = cubes[i];
                Dimension[] dimensions = cube.getDimensions();
                for (int j = 0; j < dimensions.length; ++j) {
                    Dimension dimension = dimensions[j];
                    Hierarchy[] hierarchies = dimension.getHierarchies();
                    for (int k = 0; k < hierarchies.length; ++k) {
                        Hierarchy hierarchy = hierarchies[k];
                        Level[] levels = hierarchy.getLevels();
                        for (int l = 0; l < levels.length; ++l) {
                            Level level = levels[l];
                            Property[] properties = level.getProperties();
                            for (int m = 0; m < properties.length; ++m) {
                                Property property = properties[m];
                                Rowset.Row row = new Rowset.Row();
                                row.set(MdschemaPropertiesRowset.CatalogName.name, cube.getSchema().getName());
                                row.set(MdschemaPropertiesRowset.SchemaName.name, cube.getSchema().getName());
                                row.set(MdschemaPropertiesRowset.CubeName.name, cube.getName());
                                row.set(MdschemaPropertiesRowset.DimensionUniqueName.name, dimension.getUniqueName());
                                row.set(MdschemaPropertiesRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
                                row.set(MdschemaPropertiesRowset.LevelUniqueName.name, level.getUniqueName());
                                row.set(MdschemaPropertiesRowset.PropertyName.name, property.getName());
                                row.set(MdschemaPropertiesRowset.PropertyType.name, 1);
                                row.set(MdschemaPropertiesRowset.PropertyContentType.name, 0);
                                row.set(MdschemaPropertiesRowset.PropertyCaption.name, property.getCaption());
                                this.emit(row, saxHandler);
                            }
                        }
                    }
                }
            }
        }
    }

    static class MdschemaSetsRowset
    extends Rowset {
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, null);
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, null);
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column SetName = new Column("SET_NAME", Type.String, null, true, false, null);
        private static final Column Scope = new Column("SCOPE", Type.Integer, null, true, false, null);
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_SETS", 20, null, new Column[]{CatalogName, SchemaName, CubeName, SetName, Scope}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new MdschemaSetsRowset(restrictions, properties);
            }
        };

        MdschemaSetsRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            throw new UnsupportedOperationException();
        }
    }

    static class MdschemaMembersRowset
    extends Rowset {
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, null);
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, null);
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, null);
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, null);
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, false, null);
        private static final Column LevelNumber = new Column("LEVEL_NUMBER", Type.UnsignedInteger, null, true, false, null);
        private static final Column MemberName = new Column("MEMBER_NAME", Type.String, null, true, false, null);
        private static final Column MemberOrdinal = new Column("MEMBER_ORDINAL", Type.Integer, null, true, false, null);
        private static final Column MemberUniqueName = new Column("MEMBER_UNIQUE_NAME", Type.String, null, true, false, null);
        private static final Column MemberType = new Column("MEMBER_TYPE", Type.Integer, null, true, false, null);
        private static final Column MemberCaption = new Column("MEMBER_CAPTION", Type.String, null, true, false, null);
        private static final Column ChildrenCardinality = new Column("CHILDREN_CARDINALITY", Type.Integer, null, true, false, null);
        private static final Column ParentLevel = new Column("PARENT_LEVEL", Type.Integer, null, false, false, null);
        private static final Column ParentUniqueName = new Column("PARENT_UNIQUE_NAME", Type.String, null, true, true, null);
        private static final Column TreeOp = new Column("TREE_OP", Type.Enumeration, Enumeration.TreeOp.enumeration, true, true, null);
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_MEMBERS", 18, null, new Column[]{CatalogName, SchemaName, CubeName, DimensionUniqueName, HierarchyUniqueName, LevelUniqueName, LevelNumber, MemberName, MemberOrdinal, MemberUniqueName, MemberType, MemberCaption, ChildrenCardinality, ParentLevel, ParentUniqueName, TreeOp}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new MdschemaMembersRowset(restrictions, properties);
            }
        };

        MdschemaMembersRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            Connection connection = XmlaMediator.getConnection(this.properties);
            Cube[] cubes = connection.getSchema().getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                Cube cube = cubes[i];
                if (!this.passesRestriction(CubeName, cube.getName())) continue;
                if (this.isRestricted(MemberUniqueName)) {
                    String memberUniqueName = (String)this.restrictions.get(MdschemaMembersRowset.MemberUniqueName.name);
                    String[] nameParts = Util.explode(memberUniqueName);
                    Member member = cube.getSchemaReader(null).getMemberByUniqueName(nameParts, false);
                    if (member == null) continue;
                    String treeOp0 = (String)this.restrictions.get(MdschemaMembersRowset.TreeOp.name);
                    int treeOp = Enumeration.TreeOp.Self.ordinal;
                    if (treeOp0 != null) {
                        try {
                            treeOp = Integer.parseInt(treeOp0);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    this.unparseImplMember(connection, cube, member, saxHandler, treeOp);
                    continue;
                }
                Dimension[] dimensions = cube.getDimensions();
                for (int j = 0; j < dimensions.length; ++j) {
                    Dimension dimension = dimensions[j];
                    if (!this.passesRestriction(DimensionUniqueName, dimension.getUniqueName())) continue;
                    Hierarchy[] hierarchies = dimension.getHierarchies();
                    for (int k = 0; k < hierarchies.length; ++k) {
                        Hierarchy hierarchy = hierarchies[k];
                        if (!this.passesRestriction(HierarchyUniqueName, hierarchy.getUniqueName())) continue;
                        Member[] rootMembers = connection.getSchemaReader().getHierarchyRootMembers(hierarchy);
                        for (int m = 0; m < rootMembers.length; ++m) {
                            Member member = rootMembers[m];
                            this.unparseImplMember(connection, cube, member, saxHandler, Enumeration.TreeOp.Self.ordinal | Enumeration.TreeOp.Descendants.ordinal);
                        }
                    }
                }
            }
        }

        private static boolean mask(int value, int mask) {
            return (value & mask) == mask;
        }

        private void unparseImplMember(Connection connection, Cube cube, Member member, SAXHandler saxHandler, int treeOp) throws SAXException {
            Member[] children;
            Member parent;
            if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Self.ordinal)) {
                this.emitMember(member, connection, cube, saxHandler);
            }
            if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Siblings.ordinal)) {
                parent = connection.getSchemaReader().getMemberParent(member);
                Member[] siblings = parent == null ? connection.getSchemaReader().getHierarchyRootMembers(member.getHierarchy()) : connection.getSchemaReader().getMemberChildren(parent);
                for (int i = 0; i < siblings.length; ++i) {
                    Member sibling = siblings[i];
                    if (sibling == member) continue;
                    this.unparseImplMember(connection, cube, sibling, saxHandler, Enumeration.TreeOp.Self.ordinal);
                }
            }
            if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Descendants.ordinal)) {
                children = connection.getSchemaReader().getMemberChildren(member);
                for (int i = 0; i < children.length; ++i) {
                    Member child = children[i];
                    this.unparseImplMember(connection, cube, child, saxHandler, Enumeration.TreeOp.Self.ordinal | Enumeration.TreeOp.Descendants.ordinal);
                }
            } else if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Children.ordinal)) {
                children = connection.getSchemaReader().getMemberChildren(member);
                for (int i = 0; i < children.length; ++i) {
                    Member child = children[i];
                    this.unparseImplMember(connection, cube, child, saxHandler, Enumeration.TreeOp.Self.ordinal);
                }
            }
            if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Ancestors.ordinal)) {
                parent = connection.getSchemaReader().getMemberParent(member);
                if (parent != null) {
                    this.unparseImplMember(connection, cube, parent, saxHandler, Enumeration.TreeOp.Self.ordinal | Enumeration.TreeOp.Ancestors.ordinal);
                }
            } else if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Parent.ordinal) && (parent = connection.getSchemaReader().getMemberParent(member)) != null) {
                this.unparseImplMember(connection, cube, parent, saxHandler, Enumeration.TreeOp.Self.ordinal);
            }
        }

        protected ArrayList pruneRestrictions(ArrayList list) {
            if (list.contains(TreeOp)) {
                list.remove(TreeOp);
                list.remove(MemberUniqueName);
            }
            return list;
        }

        private void emitMember(Member member, Connection connection, Cube cube, SAXHandler saxHandler) throws SAXException {
            Level level = member.getLevel();
            Hierarchy hierarchy = level.getHierarchy();
            Dimension dimension = hierarchy.getDimension();
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaMembersRowset.CatalogName.name, cube.getSchema().getName());
            row.set(MdschemaMembersRowset.SchemaName.name, cube.getSchema().getName());
            row.set(MdschemaMembersRowset.CubeName.name, cube.getName());
            row.set(MdschemaMembersRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaMembersRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaMembersRowset.LevelUniqueName.name, level.getUniqueName());
            row.set(MdschemaMembersRowset.LevelNumber.name, level.getDepth());
            row.set(MdschemaMembersRowset.MemberName.name, member.getName());
            row.set(MdschemaMembersRowset.MemberOrdinal.name, member.getOrdinal());
            row.set(MdschemaMembersRowset.MemberUniqueName.name, member.getUniqueName());
            row.set(MdschemaMembersRowset.MemberType.name, member.getMemberType());
            row.set(MdschemaMembersRowset.MemberCaption.name, member.getCaption());
            row.set(MdschemaMembersRowset.ChildrenCardinality.name, member.getPropertyValue(Property.CHILDREN_CARDINALITY.name));
            row.set(MdschemaMembersRowset.ParentLevel.name, member.getParentMember() == null ? 0 : member.getParentMember().getDepth());
            row.set(MdschemaMembersRowset.ParentUniqueName.name, member.getParentUniqueName());
            this.emit(row, saxHandler);
        }
    }

    static class MdschemaMeasuresRowset
    extends Rowset {
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, null);
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, null);
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column MeasureName = new Column("MEASURE_NAME", Type.String, null, true, false, null);
        private static final Column MeasureUniqueName = new Column("MEASURE_UNIQUE_NAME", Type.String, null, true, false, null);
        private static final Column MeasureCaption = new Column("MEASURE_CAPTION", Type.String, null, true, false, null);
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_MEASURES", 17, null, new Column[]{CatalogName, SchemaName, CubeName, MeasureName, MeasureUniqueName, MeasureCaption}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new MdschemaMeasuresRowset(restrictions, properties);
            }
        };

        MdschemaMeasuresRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            Connection connection = XmlaMediator.getConnection(this.properties);
            Role role = connection.getRole();
            Cube[] cubes = connection.getSchema().getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                Cube cube = cubes[i];
                SchemaReader schemaReader = cube.getSchemaReader(role);
                Dimension measuresDimension = cube.getDimensions()[0];
                Hierarchy measuresHierarchy = measuresDimension.getHierarchies()[0];
                Member[] storedMembers = schemaReader.getLevelMembers(measuresHierarchy.getLevels()[0]);
                for (int j = 0; j < storedMembers.length; ++j) {
                    this.emitMember(saxHandler, storedMembers[j], cube);
                }
                List calculatedMembers = schemaReader.getCalculatedMembers(measuresHierarchy);
                Iterator it = calculatedMembers.iterator();
                while (it.hasNext()) {
                    this.emitMember(saxHandler, (Member)it.next(), cube);
                }
            }
        }

        private void emitMember(SAXHandler saxHandler, Member member, Cube cube) throws SAXException {
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaMeasuresRowset.CatalogName.name, cube.getSchema().getName());
            row.set(MdschemaMeasuresRowset.SchemaName.name, cube.getSchema().getName());
            row.set(MdschemaMeasuresRowset.CubeName.name, cube.getName());
            row.set(MdschemaMeasuresRowset.MeasureName.name, member.getName());
            row.set(MdschemaMeasuresRowset.MeasureUniqueName.name, member.getUniqueName());
            row.set(MdschemaMeasuresRowset.MeasureCaption.name, member.getCaption());
            this.emit(row, saxHandler);
        }
    }

    static class MdschemaLevelsRowset
    extends Rowset {
        public static final int MDLEVEL_TYPE_UNKNOWN = 0;
        public static final int MDLEVEL_TYPE_REGULAR = 0;
        public static final int MDLEVEL_TYPE_ALL = 1;
        public static final int MDLEVEL_TYPE_CALCULATED = 2;
        public static final int MDLEVEL_TYPE_TIME = 4;
        public static final int MDLEVEL_TYPE_RESERVED1 = 8;
        public static final int MDLEVEL_TYPE_TIME_YEARS = 20;
        public static final int MDLEVEL_TYPE_TIME_HALF_YEAR = 36;
        public static final int MDLEVEL_TYPE_TIME_QUARTERS = 68;
        public static final int MDLEVEL_TYPE_TIME_MONTHS = 132;
        public static final int MDLEVEL_TYPE_TIME_WEEKS = 260;
        public static final int MDLEVEL_TYPE_TIME_DAYS = 516;
        public static final int MDLEVEL_TYPE_TIME_HOURS = 772;
        public static final int MDLEVEL_TYPE_TIME_MINUTES = 1028;
        public static final int MDLEVEL_TYPE_TIME_SECONDS = 2052;
        public static final int MDLEVEL_TYPE_TIME_UNDEFINED = 4100;
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, null);
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, null);
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, null);
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, null);
        private static final Column LevelName = new Column("LEVEL_NAME", Type.String, null, true, false, null);
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, false, null);
        private static final Column LevelCaption = new Column("LEVEL_CAPTION", Type.String, null, true, false, null);
        private static final Column LevelNumber = new Column("LEVEL_NUMBER", Type.Integer, null, true, false, null);
        private static final Column LevelType = new Column("LEVEL_TYPE", Type.Integer, null, true, false, null);
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_LEVELS", 16, null, new Column[]{CatalogName, SchemaName, CubeName, DimensionUniqueName, HierarchyUniqueName, LevelName, LevelUniqueName, LevelCaption, LevelNumber, LevelType}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new MdschemaLevelsRowset(restrictions, properties);
            }
        };

        MdschemaLevelsRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            Connection connection = XmlaMediator.getConnection(this.properties);
            Cube[] cubes = connection.getSchema().getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                Cube cube = cubes[i];
                Dimension[] dimensions = cube.getDimensions();
                for (int j = 0; j < dimensions.length; ++j) {
                    Dimension dimension = dimensions[j];
                    Hierarchy[] hierarchies = dimension.getHierarchies();
                    for (int k = 0; k < hierarchies.length; ++k) {
                        Hierarchy hierarchy = hierarchies[k];
                        Level[] levels = hierarchy.getLevels();
                        for (int m = 0; m < levels.length; ++m) {
                            Level level = levels[m];
                            Rowset.Row row = new Rowset.Row();
                            row.set(MdschemaLevelsRowset.CatalogName.name, cube.getSchema().getName());
                            row.set(MdschemaLevelsRowset.SchemaName.name, cube.getSchema().getName());
                            row.set(MdschemaLevelsRowset.CubeName.name, cube.getName());
                            row.set(MdschemaLevelsRowset.DimensionUniqueName.name, dimension.getUniqueName());
                            row.set(MdschemaLevelsRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
                            row.set(MdschemaLevelsRowset.LevelName.name, level.getName());
                            row.set(MdschemaLevelsRowset.LevelUniqueName.name, level.getUniqueName());
                            row.set(MdschemaLevelsRowset.LevelCaption.name, level.getCaption());
                            row.set(MdschemaLevelsRowset.LevelNumber.name, level.getDepth());
                            row.set(MdschemaLevelsRowset.LevelType.name, this.getLevelType(level));
                            this.emit(row, saxHandler);
                        }
                    }
                }
            }
        }

        private int getLevelType(Level lev) {
            if (lev.isAll()) {
                return 1;
            }
            LevelType type = lev.getLevelType();
            switch (type.getOrdinal()) {
                case 0: {
                    return 0;
                }
                case 5: {
                    return 516;
                }
                case 3: {
                    return 132;
                }
                case 2: {
                    return 68;
                }
                case 4: {
                    return 260;
                }
                case 1: {
                    return 20;
                }
            }
            return 0;
        }
    }

    static class MdschemaHierarchiesRowset
    extends Rowset {
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, null);
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, null);
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, null);
        private static final Column HierarchyName = new Column("HIERARCHY_NAME", Type.String, null, true, false, null);
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, null);
        private static final Column HierarchyCaption = new Column("HIERARCHY_CAPTION", Type.String, null, true, false, null);
        private static final Column DimensionType = new Column("DIMENSION_TYPE", Type.Integer, null, true, false, null);
        private static final Column DefaultMember = new Column("DEFAULT_MEMBER", Type.String, null, true, true, null);
        private static final Column AllMember = new Column("ALL_MEMBER", Type.String, null, true, true, null);
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_HIERARCHIES", 15, null, new Column[]{CatalogName, SchemaName, CubeName, DimensionUniqueName, HierarchyName, HierarchyUniqueName, HierarchyCaption, DimensionType, DefaultMember, AllMember}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new MdschemaHierarchiesRowset(restrictions, properties);
            }
        };

        MdschemaHierarchiesRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            Connection connection = XmlaMediator.getConnection(this.properties);
            Cube[] cubes = connection.getSchema().getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                Cube cube = cubes[i];
                Dimension[] dimensions = cube.getDimensions();
                for (int j = 0; j < dimensions.length; ++j) {
                    Dimension dimension = dimensions[j];
                    Hierarchy[] hierarchies = dimension.getHierarchies();
                    for (int k = 0; k < hierarchies.length; ++k) {
                        HierarchyBase hierarchy = (HierarchyBase)hierarchies[k];
                        Rowset.Row row = new Rowset.Row();
                        row.set(MdschemaHierarchiesRowset.CatalogName.name, cube.getSchema().getName());
                        row.set(MdschemaHierarchiesRowset.SchemaName.name, cube.getSchema().getName());
                        row.set(MdschemaHierarchiesRowset.CubeName.name, cube.getName());
                        row.set(MdschemaHierarchiesRowset.DimensionUniqueName.name, dimension.getUniqueName());
                        row.set(MdschemaHierarchiesRowset.HierarchyName.name, hierarchy.getName());
                        row.set(MdschemaHierarchiesRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
                        row.set(MdschemaHierarchiesRowset.HierarchyCaption.name, hierarchy.getCaption());
                        row.set(MdschemaHierarchiesRowset.DimensionType.name, RowsetDefinition.getDimensionType(dimension));
                        row.set(MdschemaHierarchiesRowset.DefaultMember.name, hierarchy.getDefaultMember());
                        if (hierarchy.hasAll()) {
                            row.set(MdschemaHierarchiesRowset.AllMember.name, Util.makeFqName(hierarchy, hierarchy.getAllMemberName()));
                        }
                        this.emit(row, saxHandler);
                    }
                }
            }
        }
    }

    static class MdschemaFunctionsRowset
    extends Rowset {
        private static final Column LibraryName = new Column("LIBRARY_NAME", Type.String, null, true, true, null);
        private static final Column InterfaceName = new Column("INTERFACE_NAME", Type.String, null, true, true, null);
        private static final Column FunctionName = new Column("FUNCTION_NAME", Type.String, null, true, true, null);
        private static final Column Origin = new Column("ORIGIN", Type.Integer, null, true, true, null);
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_FUNCTIONS", 14, null, new Column[]{LibraryName, InterfaceName, FunctionName, Origin}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new MdschemaFunctionsRowset(restrictions, properties);
            }
        };

        MdschemaFunctionsRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            throw new UnsupportedOperationException();
        }
    }

    static class MdschemaDimensionsRowset
    extends Rowset {
        public static final int MD_DIMTYPE_OTHER = 3;
        public static final int MD_DIMTYPE_MEASURE = 2;
        public static final int MD_DIMTYPE_TIME = 1;
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, null);
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, null);
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column DimensionName = new Column("DIMENSION_NAME", Type.String, null, true, false, null);
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, null);
        private static final Column DimensionCaption = new Column("DIMENSION_CAPTION", Type.String, null, true, false, null);
        private static final Column DimensionOrdinal = new Column("DIMENSION_ORDINAL", Type.Integer, null, true, false, null);
        private static final Column DimensionType = new Column("DIMENSION_TYPE", Type.Integer, null, true, false, null);
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_DIMENSIONS", 13, null, new Column[]{CatalogName, SchemaName, CubeName, DimensionName, DimensionUniqueName, DimensionCaption, DimensionOrdinal, DimensionType}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new MdschemaDimensionsRowset(restrictions, properties);
            }
        };

        MdschemaDimensionsRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            Connection connection = XmlaMediator.getConnection(this.properties);
            Cube[] cubes = connection.getSchema().getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                Cube cube = cubes[i];
                Dimension[] dimensions = cube.getDimensions();
                for (int j = 0; j < dimensions.length; ++j) {
                    Dimension dimension = dimensions[j];
                    Rowset.Row row = new Rowset.Row();
                    row.set(MdschemaDimensionsRowset.CatalogName.name, cube.getSchema().getName());
                    row.set(MdschemaDimensionsRowset.SchemaName.name, cube.getSchema().getName());
                    row.set(MdschemaDimensionsRowset.CubeName.name, cube.getName());
                    row.set(MdschemaDimensionsRowset.DimensionName.name, dimension.getName());
                    row.set(MdschemaDimensionsRowset.DimensionUniqueName.name, dimension.getUniqueName());
                    row.set(MdschemaDimensionsRowset.DimensionCaption.name, dimension.getCaption());
                    row.set(MdschemaDimensionsRowset.DimensionOrdinal.name, dimension.getOrdinal(cube));
                    row.set(MdschemaDimensionsRowset.DimensionType.name, RowsetDefinition.getDimensionType(dimension));
                    this.emit(row, saxHandler);
                }
            }
        }
    }

    static class MdschemaCubesRowset
    extends Rowset {
        private static final String MD_CUBTYPE_CUBE = "CUBE";
        private static final String MD_CUBTYPE_VIRTUAL_CUBE = "VIRTUAL CUBE";
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, null);
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, null);
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column CubeType = new Column("CUBE_TYPE", Type.String, null, true, false, "Cube type.");
        private static final Column IsDrillthroughEnabled = new Column("IS_DRILLTHROUGH_ENABLED", Type.Boolean, null, false, false, "Describes whether DRILLTHROUGH can be performed on the members of a cube");
        private static final Column IsWriteEnabled = new Column("IS_WRITE_ENABLED", Type.Boolean, null, false, false, "Describes whether a cube is write-enabled");
        private static final Column IsLinkable = new Column("IS_LINKABLE", Type.Boolean, null, false, false, "Describes whether a cube can be used in a linked cube");
        private static final Column IsSqlAllowed = new Column("IS_SQL_ALLOWED", Type.Boolean, null, false, false, "Describes whether or not SQL can be used on the cube");
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_CUBES", 12, null, new Column[]{CatalogName, SchemaName, CubeName, CubeType, IsDrillthroughEnabled, IsWriteEnabled, IsLinkable, IsSqlAllowed}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new MdschemaCubesRowset(restrictions, properties);
            }
        };

        MdschemaCubesRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            Connection connection = XmlaMediator.getConnection(this.properties);
            Cube[] cubes = connection.getSchema().getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                Cube cube = cubes[i];
                Rowset.Row row = new Rowset.Row();
                row.set(MdschemaCubesRowset.CatalogName.name, cube.getSchema().getName());
                row.set(MdschemaCubesRowset.SchemaName.name, cube.getSchema().getName());
                row.set(MdschemaCubesRowset.CubeName.name, cube.getName());
                row.set(MdschemaCubesRowset.CubeType.name, ((RolapCube)cube).isVirtual() ? MD_CUBTYPE_VIRTUAL_CUBE : MD_CUBTYPE_CUBE);
                row.set(MdschemaCubesRowset.IsDrillthroughEnabled.name, true);
                row.set(MdschemaCubesRowset.IsWriteEnabled.name, false);
                row.set(MdschemaCubesRowset.IsLinkable.name, false);
                row.set(MdschemaCubesRowset.IsSqlAllowed.name, false);
                this.emit(row, saxHandler);
            }
        }
    }

    static class MdschemaActionsRowset
    extends Rowset {
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column Coordinate = new Column("COORDINATE", Type.String, null, true, false, null);
        private static final Column CoordinateType = new Column("COORDINATE_TYPE", Type.String, null, true, false, null);
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_ACTIONS", 11, null, new Column[]{CubeName, Coordinate, CoordinateType}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new MdschemaActionsRowset(restrictions, properties);
            }
        };

        MdschemaActionsRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            throw new UnsupportedOperationException();
        }
    }

    static class DbschemaTablesInfoRowset
    extends Rowset {
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, false, null);
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, false, null);
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, null);
        private static final Column TableType = new Column("TABLE_TYPE", Type.String, null, true, false, null);
        public static final RowsetDefinition definition = new RowsetDefinition("DBSCHEMA_TABLES_INFO", 10, null, new Column[]{TableCatalog, TableSchema, TableName, TableType}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new DbschemaTablesInfoRowset(restrictions, properties);
            }
        };

        DbschemaTablesInfoRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            throw new UnsupportedOperationException();
        }
    }

    static class DbschemaTablesRowset
    extends Rowset {
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, false, null);
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, false, null);
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, null);
        private static final Column TableType = new Column("TABLE_TYPE", Type.String, null, true, false, null);
        public static final RowsetDefinition definition = new RowsetDefinition("DBSCHEMA_TABLES", 9, null, new Column[]{TableCatalog, TableSchema, TableName, TableType}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new DbschemaTablesRowset(restrictions, properties);
            }
        };

        DbschemaTablesRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            throw new UnsupportedOperationException();
        }
    }

    static class DbschemaProviderTypesRowset
    extends Rowset {
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedInteger, null, true, false, null);
        private static final Column BestMatch = new Column("BEST_MATCH", Type.Boolean, null, true, false, null);
        public static final RowsetDefinition definition = new RowsetDefinition("DBSCHEMA_PROVIDER_TYPES", 8, null, new Column[]{DataType, BestMatch}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new DbschemaProviderTypesRowset(restrictions, properties);
            }
        };

        DbschemaProviderTypesRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            throw new UnsupportedOperationException();
        }
    }

    static class DbschemaColumnsRowset
    extends Rowset {
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, false, null);
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, false, null);
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, null);
        private static final Column ColumnName = new Column("COLUMN_NAME", Type.String, null, true, false, null);
        public static final RowsetDefinition definition = new RowsetDefinition("DBSCHEMA_COLUMNS", 7, null, new Column[]{TableCatalog, TableSchema, TableName, ColumnName}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new DbschemaColumnsRowset(restrictions, properties);
            }
        };

        DbschemaColumnsRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            throw new UnsupportedOperationException();
        }
    }

    static class DbschemaCatalogsRowset
    extends Rowset {
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, "Catalog name. Cannot be NULL.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "Human-readable description of the catalog.");
        public static final RowsetDefinition definition = new RowsetDefinition("DBSCHEMA_CATALOGS", 6, "Returns information about literals supported by the provider.", new Column[]{CatalogName, Description}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new DbschemaCatalogsRowset(restrictions, properties);
            }
        };

        DbschemaCatalogsRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            Connection connection = XmlaMediator.getConnection(this.properties);
            if (connection == null) {
                return;
            }
            Rowset.Row row = new Rowset.Row();
            Schema schema = connection.getSchema();
            row.set(DbschemaCatalogsRowset.CatalogName.name, schema.getName());
            this.emit(row, saxHandler);
        }
    }

    static class DiscoverLiteralsRowset
    extends Rowset {
        public static final RowsetDefinition definition = new RowsetDefinition("DISCOVER_LITERALS", 5, "Returns information about literals supported by the provider.", new Column[]{new Column("LiteralName", Type.StringSometimesArray, null, true, false, "The name of the literal described in the row." + RowsetDefinition.access$100() + "Example: DBLITERAL_LIKE_PERCENT"), new Column("LiteralValue", Type.String, null, false, true, "Contains the actual literal value." + RowsetDefinition.access$100() + "Example, if LiteralName is DBLITERAL_LIKE_PERCENT and the percent character (%) is used to match zero or more characters in a LIKE clause, this column's value would be \"%\"."), new Column("LiteralInvalidChars", Type.String, null, false, true, "The characters, in the literal, that are not valid." + RowsetDefinition.access$100() + "For example, if table names can contain anything other than a numeric character, this string would be \"0123456789\"."), new Column("LiteralInvalidStartingChars", Type.String, null, false, true, "The characters that are not valid as the first character of the literal. If the literal can start with any valid character, this is null."), new Column("LiteralMaxLength", Type.Integer, null, false, true, "The maximum number of characters in the literal. If there is no maximum or the maximum is unknown, the value is ?1.")}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new DiscoverLiteralsRowset(restrictions, properties);
            }
        };

        DiscoverLiteralsRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            this.emit(Enumeration.Literal.enumeration, saxHandler);
        }
    }

    static class DiscoverKeywordsRowset
    extends Rowset {
        private static final Column Keyword = new Column("Keyword", Type.StringSometimesArray, null, true, false, "A list of all the keywords reserved by a provider." + RowsetDefinition.access$100() + "Example: AND");
        public static final RowsetDefinition definition = new RowsetDefinition("DISCOVER_KEYWORDS", 4, "Returns an XML list of keywords reserved by the provider.", new Column[]{Keyword}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new DiscoverKeywordsRowset(restrictions, properties);
            }
        };
        private static final String[] keywords = new String[]{"$AdjustedProbability", "$Distance", "$Probability", "$ProbabilityStDev", "$ProbabilityStdDeV", "$ProbabilityVariance", "$StDev", "$StdDeV", "$Support", "$Variance", "AddCalculatedMembers", "Action", "After", "Aggregate", "All", "Alter", "Ancestor", "And", "Append", "As", "ASC", "Axis", "Automatic", "Back_Color", "BASC", "BDESC", "Before", "Before_And_After", "Before_And_Self", "Before_Self_After", "BottomCount", "BottomPercent", "BottomSum", "Break", "Boolean", "Cache", "Calculated", "Call", "Case", "Catalog_Name", "Cell", "Cell_Ordinal", "Cells", "Chapters", "Children", "Children_Cardinality", "ClosingPeriod", "Cluster", "ClusterDistance", "ClusterProbability", "Clusters", "CoalesceEmpty", "Column_Values", "Columns", "Content", "Contingent", "Continuous", "Correlation", "Cousin", "Covariance", "CovarianceN", "Create", "CreatePropertySet", "CrossJoin", "Cube", "Cube_Name", "CurrentMember", "CurrentCube", "Custom", "Cyclical", "DefaultMember", "Default_Member", "DESC", "Descendents", "Description", "Dimension", "Dimension_Unique_Name", "Dimensions", "Discrete", "Discretized", "DrillDownLevel", "DrillDownLevelBottom", "DrillDownLevelTop", "DrillDownMember", "DrillDownMemberBottom", "DrillDownMemberTop", "DrillTrough", "DrillUpLevel", "DrillUpMember", "Drop", "Else", "Empty", "End", "Equal_Areas", "Exclude_Null", "ExcludeEmpty", "Exclusive", "Expression", "Filter", "FirstChild", "FirstRowset", "FirstSibling", "Flattened", "Font_Flags", "Font_Name", "Font_size", "Fore_Color", "Format_String", "Formatted_Value", "Formula", "From", "Generate", "Global", "Head", "Hierarchize", "Hierarchy", "Hierary_Unique_name", "IIF", "IsEmpty", "Include_Null", "Include_Statistics", "Inclusive", "Input_Only", "IsDescendant", "Item", "Lag", "LastChild", "LastPeriods", "LastSibling", "Lead", "Level", "Level_Unique_Name", "Levels", "LinRegIntercept", "LinRegR2", "LinRegPoint", "LinRegSlope", "LinRegVariance", "Long", "MaxRows", "Median", "Member", "Member_Caption", "Member_Guid", "Member_Name", "Member_Ordinal", "Member_Type", "Member_Unique_Name", "Members", "Microsoft_Clustering", "Microsoft_Decision_Trees", "Mining", "Model", "Model_Existence_Only", "Models", "Move", "MTD", "Name", "Nest", "NextMember", "Non", "Normal", "Not", "Ntext", "Nvarchar", "OLAP", "On", "OpeningPeriod", "OpenQuery", "Or", "Ordered", "Ordinal", "Pages", "Pages", "ParallelPeriod", "Parent", "Parent_Level", "Parent_Unique_Name", "PeriodsToDate", "PMML", "Predict", "Predict_Only", "PredictAdjustedProbability", "PredictHistogram", "Prediction", "PredictionScore", "PredictProbability", "PredictProbabilityStDev", "PredictProbabilityVariance", "PredictStDev", "PredictSupport", "PredictVariance", "PrevMember", "Probability", "Probability_StDev", "Probability_StdDev", "Probability_Variance", "Properties", "Property", "QTD", "RangeMax", "RangeMid", "RangeMin", "Rank", "Recursive", "Refresh", "Related", "Rename", "Rollup", "Rows", "Schema_Name", "Sections", "Select", "Self", "Self_And_After", "Sequence_Time", "Server", "Session", "Set", "SetToArray", "SetToStr", "Shape", "Skip", "Solve_Order", "Sort", "StdDev", "Stdev", "StripCalculatedMembers", "StrToSet", "StrToTuple", "SubSet", "Support", "Tail", "Text", "Thresholds", "ToggleDrillState", "TopCount", "TopPercent", "TopSum", "TupleToStr", "Under", "Uniform", "UniqueName", "Use", "Value", "Value", "Var", "Variance", "VarP", "VarianceP", "VisualTotals", "When", "Where", "With", "WTD", "Xor"};

        DiscoverKeywordsRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            for (int i = 0; i < keywords.length; ++i) {
                String keyword = keywords[i];
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverKeywordsRowset.Keyword.name, keyword);
                this.emit(row, saxHandler);
            }
        }
    }

    static class DiscoverEnumeratorsRowset
    extends Rowset {
        private static final Column EnumName = new Column("EnumName", Type.StringArray, null, true, false, "The name of the enumerator that contains a set of values.");
        private static final Column EnumDescription = new Column("EnumDescription", Type.String, null, false, true, "A localizable description of the enumerator.");
        private static final Column EnumType = new Column("EnumType", Type.String, null, false, false, "The data type of the Enum values.");
        private static final Column ElementName = new Column("ElementName", Type.String, null, false, false, "The name of one of the value elements in the enumerator set." + RowsetDefinition.access$100() + "Example: TDP");
        private static final Column ElementDescription = new Column("ElementDescription", Type.String, null, false, true, "A localizable description of the element (optional).");
        private static final Column ElementValue = new Column("ElementValue", Type.String, null, false, true, "The value of the element." + RowsetDefinition.access$100() + "Example: 01");
        public static final RowsetDefinition definition = new RowsetDefinition("DISCOVER_ENUMERATORS", 3, "Returns a list of names, data types, and enumeration values for enumerators supported by the provider of a specific data source.", new Column[]{EnumName, EnumDescription, EnumType, ElementName, ElementDescription, ElementValue}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new DiscoverEnumeratorsRowset(restrictions, properties);
            }
        };

        DiscoverEnumeratorsRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            Enumeration[] enumerators = DiscoverEnumeratorsRowset.getEnumerators();
            for (int i = 0; i < enumerators.length; ++i) {
                Enumeration enumerator = enumerators[i];
                String[] valueNames = enumerator.getNames();
                for (int j = 0; j < valueNames.length; ++j) {
                    String valueName = valueNames[j];
                    EnumeratedValues.Value value = enumerator.getValue(valueName, true);
                    Rowset.Row row = new Rowset.Row();
                    row.set(DiscoverEnumeratorsRowset.EnumName.name, enumerator.name);
                    row.set(DiscoverEnumeratorsRowset.EnumDescription.name, enumerator.description);
                    row.set(DiscoverEnumeratorsRowset.EnumType.name, enumerator.type);
                    row.set(DiscoverEnumeratorsRowset.ElementName.name, value.getName());
                    row.set(DiscoverEnumeratorsRowset.ElementDescription.name, value.getDescription());
                    switch (enumerator.type.ordinal) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            row.set(DiscoverEnumeratorsRowset.ElementValue.name, value.getOrdinal());
                        }
                    }
                    this.emit(row, saxHandler);
                }
            }
        }

        private static Enumeration[] getEnumerators() {
            HashSet<Enumeration> enumeratorSet = new HashSet<Enumeration>();
            String[] rowsetNames = enumeration.getNames();
            for (int i = 0; i < rowsetNames.length; ++i) {
                String rowsetName = rowsetNames[i];
                RowsetDefinition rowsetDefinition = (RowsetDefinition)enumeration.getValue(rowsetName, true);
                for (int j = 0; j < rowsetDefinition.columnDefinitions.length; ++j) {
                    Column column = rowsetDefinition.columnDefinitions[j];
                    if (column.enumeration == null) continue;
                    enumeratorSet.add(column.enumeration);
                }
            }
            Enumeration[] enumerators = enumeratorSet.toArray(new Enumeration[enumeratorSet.size()]);
            Arrays.sort(enumerators, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Enumeration)o1).name.compareTo(((Enumeration)o2).name);
                }
            });
            return enumerators;
        }
    }

    static class DiscoverPropertiesRowset
    extends Rowset {
        private static final Column PropertyName = new Column("PropertyName", Type.StringSometimesArray, null, true, false, "The name of the property.");
        private static final Column PropertyDescription = new Column("PropertyDescription", Type.String, null, false, true, "A localizable text description of the property.");
        private static final Column PropertyType = new Column("PropertyType", Type.String, null, false, true, "The XML data type of the property.");
        private static final Column PropertyAccessType = new Column("PropertyAccessType", Type.EnumString, Enumeration.Access.enumeration, false, false, "Access for the property. The value can be Read, Write, or ReadWrite.");
        private static final Column IsRequired = new Column("IsRequired", Type.Boolean, null, false, true, "True if a property is required, false if it is not required.");
        private static final Column Value = new Column("Value", Type.String, null, false, true, "The current value of the property.");
        public static final RowsetDefinition definition = new RowsetDefinition("DISCOVER_PROPERTIES", 1, "Returns a list of information and values about the requested properties that are supported by the specified data source provider.", new Column[]{PropertyName, PropertyDescription, PropertyType, PropertyAccessType, IsRequired, Value}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new DiscoverPropertiesRowset(restrictions, properties);
            }
        };

        DiscoverPropertiesRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            String[] propertyNames = PropertyDefinition.enumeration.getNames();
            for (int i = 0; i < propertyNames.length; ++i) {
                PropertyDefinition propertyDefinition = PropertyDefinition.getValue(propertyNames[i]);
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverPropertiesRowset.PropertyName.name, propertyDefinition.name);
                row.set(DiscoverPropertiesRowset.PropertyDescription.name, propertyDefinition.description);
                row.set(DiscoverPropertiesRowset.PropertyType.name, propertyDefinition.type);
                row.set(DiscoverPropertiesRowset.PropertyAccessType.name, propertyDefinition.access);
                this.emit(row, saxHandler);
            }
        }
    }

    static class DiscoverSchemaRowsetsRowset
    extends Rowset {
        private static final Column SchemaName = new Column("SchemaName", Type.StringArray, null, true, false, "The name of the schema/request. This returns the values in the RequestTypes enumeration, plus any additional types supported by the provider. The provider defines rowset structures for the additional types");
        private static final Column Restrictions = new Column("Restrictions", Type.Array, null, false, true, "An array of the restrictions suppoted by provider. An example follows this table.");
        private static final Column Description = new Column("Description", Type.String, null, false, true, "A localizable description of the schema");
        private static RowsetDefinition definition = new RowsetDefinition("DISCOVER_SCHEMA_ROWSETS", 2, "Returns the names, values, and other information of all supported RequestType enumeration values.", new Column[]{SchemaName, Restrictions, Description}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new DiscoverSchemaRowsetsRowset(restrictions, properties);
            }
        };

        public DiscoverSchemaRowsetsRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            RowsetDefinition[] rowsetDefinitions = enumeration.getValuesSortedByName().toArray(new RowsetDefinition[0]);
            for (int i = 0; i < rowsetDefinitions.length; ++i) {
                RowsetDefinition rowsetDefinition = rowsetDefinitions[i];
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverSchemaRowsetsRowset.SchemaName.name, rowsetDefinition.name);
                row.set(DiscoverSchemaRowsetsRowset.Restrictions.name, this.getRestrictions(rowsetDefinition));
                row.set(DiscoverSchemaRowsetsRowset.Description.name, rowsetDefinition.description);
                this.emit(row, saxHandler);
            }
        }

        private Rowset.XmlElement[] getRestrictions(RowsetDefinition rowsetDefinition) {
            ArrayList<Rowset.XmlElement> restrictionList = new ArrayList<Rowset.XmlElement>();
            Column[] columns = rowsetDefinition.columnDefinitions;
            for (int j = 0; j < columns.length; ++j) {
                Column column = columns[j];
                if (!column.restriction) continue;
                restrictionList.add((Rowset)this.new Rowset.XmlElement(DiscoverSchemaRowsetsRowset.Restrictions.name, null, new Rowset.XmlElement[]{(Rowset)this.new Rowset.XmlElement("Name", null, column.name), (Rowset)this.new Rowset.XmlElement("Type", null, column.getColumnType())}));
            }
            Rowset.XmlElement[] restrictions = restrictionList.toArray(new Rowset.XmlElement[restrictionList.size()]);
            return restrictions;
        }

        static /* synthetic */ RowsetDefinition access$000() {
            return definition;
        }
    }

    static class DiscoverDatasourcesRowset
    extends Rowset {
        private static final Column DataSourceName = new Column("DataSourceName", Type.String, null, true, false, "The name of the data source, such as FoodMart 2000.");
        private static final Column DataSourceDescription = new Column("DataSourceDescription", Type.String, null, false, true, "A description of the data source, as entered by the publisher.");
        private static final Column URL = new Column("URL", Type.String, null, true, true, "The unique path that shows where to invoke the XML for Analysis methods for that data source.");
        private static final Column DataSourceInfo = new Column("DataSourceInfo", Type.String, null, false, true, "A string containing any additional information required to connect to the data source. This can include the Initial Catalog property or other information for the provider." + RowsetDefinition.access$100() + "Example: \"Provider=MSOLAP;Data Source=Local;\"");
        private static final Column ProviderName = new Column("ProviderName", Type.String, null, true, true, "The name of the provider behind the data source. " + RowsetDefinition.access$100() + "Example: \"MSDASQL\"");
        private static final Column ProviderType = new Column("ProviderType", Type.EnumerationArray, Enumeration.ProviderType.enumeration, true, false, "The types of data supported by the provider. May include one or more of the following types. Example follows this table." + RowsetDefinition.access$100() + "TDP: tabular data provider." + RowsetDefinition.access$100() + "MDP: multidimensional data provider." + RowsetDefinition.access$100() + "DMP: data mining provider. A DMP provider implements the OLE DB for Data Mining specification.");
        private static final Column AuthenticationMode = new Column("AuthenticationMode", Type.EnumString, Enumeration.AuthenticationMode.enumeration, true, false, "Specification of what type of security mode the data source uses. Values can be one of the following:" + RowsetDefinition.access$100() + "Unauthenticated: no user ID or password needs to be sent." + RowsetDefinition.access$100() + "Authenticated: User ID and Password must be included in the information required for the connection." + RowsetDefinition.access$100() + "Integrated: the data source uses the underlying security to determine authorization, such as Integrated Security provided by Microsoft Internet Information Services (IIS).");
        static final RowsetDefinition definition = new RowsetDefinition("DISCOVER_DATASOURCES", 0, "Returns a list of XML for Analysis data sources available on the server or Web Service.", new Column[]{DataSourceName, DataSourceDescription, URL, DataSourceInfo, ProviderName, ProviderType, AuthenticationMode}){

            public Rowset getRowset(HashMap restrictions, Properties properties) {
                return new DiscoverDatasourcesRowset(restrictions, properties);
            }
        };
        private int contentOrdinal = 3;

        public DiscoverDatasourcesRowset(HashMap restrictions, Properties properties) {
            super(definition, restrictions, properties);
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    Enumeration.Content content = Enumeration.Content.getValue(value);
                    if (content == null) {
                        throw Util.newError("Bad Content Property value: " + value);
                    }
                    this.contentOrdinal = content.getOrdinal();
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        protected void unparseImpl(SAXHandler saxHandler) throws SAXException {
            switch (this.contentOrdinal) {
                case 0: {
                    break;
                }
                case 1: {
                    throw new UnsupportedOperationException();
                }
                case 2: {
                    Iterator it = XmlaMediator.dataSourcesMap.values().iterator();
                    while (it.hasNext()) {
                        DataSourcesConfig.DataSource ds = (DataSourcesConfig.DataSource)((Object)it.next());
                        Rowset.Row row = new Rowset.Row();
                        row.set(DiscoverDatasourcesRowset.DataSourceName.name, ds.getDataSourceName());
                        row.set(DiscoverDatasourcesRowset.DataSourceDescription.name, ds.getDataSourceDescription());
                        row.set(DiscoverDatasourcesRowset.URL.name, ds.getURL());
                        row.set(DiscoverDatasourcesRowset.DataSourceInfo.name, ds.getDataSourceName());
                        row.set(DiscoverDatasourcesRowset.ProviderName.name, ds.getProviderName());
                        row.set(DiscoverDatasourcesRowset.ProviderType.name, ds.getProviderType());
                        row.set(DiscoverDatasourcesRowset.AuthenticationMode.name, ds.getAuthenticationMode());
                        this.emit(row, saxHandler);
                    }
                    break;
                }
                case 3: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    static class Column {
        final String name;
        final Type type;
        final Enumeration enumeration;
        final String description;
        final boolean restriction;
        final boolean nullable;

        Column(String name, Type type, Enumeration enumeratedType, boolean restriction, boolean nullable, String description) {
            Util.assertPrecondition(type != null, "Type.instance.isValid(type)");
            Util.assertPrecondition((type == Type.Enumeration || type == Type.EnumerationArray || type == Type.EnumString) == (enumeratedType != null), "(type == Type.Enumeration || type == Type.EnumerationArray || type == Type.EnumString) == (enumeratedType != null)");
            this.name = name;
            this.type = type;
            this.enumeration = enumeratedType;
            this.description = description;
            this.restriction = restriction;
            this.nullable = nullable;
        }

        Object get(Object row) {
            try {
                String javaFieldName = this.name.substring(0, 1).toLowerCase() + this.name.substring(1);
                Field field = row.getClass().getField(javaFieldName);
                return field.get(row);
            }
            catch (NoSuchFieldException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (SecurityException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
        }

        public String getColumnType() {
            if (this.type.isEnum()) {
                return this.enumeration.type.columnType;
            }
            return this.type.columnType;
        }
    }

    static class Type
    extends EnumeratedValues.BasicValue {
        public static final int String_ORDINAL = 0;
        public static final Type String = new Type("string", 0, "string");
        public static final int StringArray_ORDINAL = 1;
        public static final Type StringArray = new Type("StringArray", 1, "string");
        public static final int Array_ORDINAL = 2;
        public static final Type Array = new Type("Array", 2, "string");
        public static final int Enumeration_ORDINAL = 3;
        public static final Type Enumeration = new Type("Enumeration", 3, "string");
        public static final int EnumerationArray_ORDINAL = 4;
        public static final Type EnumerationArray = new Type("EnumerationArray", 4, "string");
        public static final int EnumString_ORDINAL = 5;
        public static final Type EnumString = new Type("EnumString", 5, "string");
        public static final int Boolean_ORDINAL = 6;
        public static final Type Boolean = new Type("Boolean", 6, "boolean");
        public static final int StringSometimesArray_ORDINAL = 7;
        public static final Type StringSometimesArray = new Type("StringSometimesArray", 7, "string");
        public static final int Integer_ORDINAL = 8;
        public static final Type Integer = new Type("Integer", 8, "integer");
        public static final int UnsignedInteger_ORDINAL = 9;
        public static final Type UnsignedInteger = new Type("UnsignedInteger", 9, "unsignedInteger");
        public final String columnType;
        public static final EnumeratedValues enumeration = new EnumeratedValues(new Type[]{String, StringArray, Array, Enumeration, EnumerationArray, EnumString});

        public Type(String name, int ordinal, String columnType) {
            super(name, ordinal, null);
            this.columnType = columnType;
        }

        boolean isEnum() {
            switch (this.ordinal) {
                case 3: 
                case 4: 
                case 5: {
                    return true;
                }
            }
            return false;
        }
    }
}

