/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mondrian.olap.Util;
import mondrian.util.SAXHandler;
import mondrian.util.SAXWriter;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.XmlaMediator;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;
import org.xml.sax.SAXException;

public class XmlaServlet
extends HttpServlet {
    private static int whichfile = 0;
    private static final Logger LOGGER = Logger.getLogger((Class)XmlaServlet.class);
    public static final String DATA_SOURCES_CONFIG = "DataSourcesConfig";
    private static final byte[] BOM_UTF_32_BE = new byte[]{0, 0, -2, -1};
    private static final byte[] BOM_UTF_32_LE = new byte[]{-1, -2, 0, 0};
    private static final byte[] BOM_UTF_16_BE = new byte[]{-2, -1};
    private static final byte[] BOM_UTF_16_LE = new byte[]{-1, -2};
    private static final byte[] BOM_UTF_8 = new byte[]{-17, -69, -65};
    private final XmlaMediator mediator = new XmlaMediator();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String paramValue = config.getInitParameter(DATA_SOURCES_CONFIG);
        if (null == paramValue) {
            Util.newError("No data source has been configured. Please set parameter 'DataSourcesConfig' for this servlet.");
        }
        ServletContext context = config.getServletContext();
        try {
            URL configUrl = null;
            try {
                configUrl = new URL(paramValue);
            }
            catch (MalformedURLException e) {
                configUrl = new File(context.getRealPath("WEB-INF/" + paramValue)).toURL();
            }
            Parser xmlParser = XOMUtil.createDefaultParser();
            DOMWrapper def = xmlParser.parse(configUrl);
            DataSourcesConfig.DataSources dataSources = new DataSourcesConfig.DataSources(def);
            XmlaMediator.initDataSourcesMap(dataSources);
        }
        catch (MalformedURLException e) {
            throw Util.newError(e, "while parsing data sources config '" + paramValue + "'");
        }
        catch (XOMException e) {
            throw Util.newError(e, "while parsing data sources config '" + paramValue + "'");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    public void process(HttpServletRequest request, HttpServletResponse response) {
        String soapRequest = request.getParameter("SOAPRequest");
        if (soapRequest == null) {
            try {
                soapRequest = XmlaServlet.toString((InputStream)request.getInputStream());
            }
            catch (IOException e) {
                return;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Pathinfo=" + request.getPathInfo()));
            Map map = request.getParameterMap();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String att = (String)iterator.next();
                String[] vals = (String[])map.get(att);
                LOGGER.debug((Object)(att + "=" + (vals != null && vals.length > 0 ? vals[0] : "<null>")));
            }
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String header = (String)headerNames.nextElement();
                LOGGER.debug((Object)("Header " + header + "=" + request.getHeader(header)));
            }
            LOGGER.debug((Object)("Request: " + soapRequest));
        }
        StringWriter responseWriter = new StringWriter();
        XmlaMediator.threadServletContext.set(this.getServletContext());
        response.setContentType("text/xml");
        try {
            this.mediator.process(soapRequest, responseWriter);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Response:");
                LOGGER.debug((Object)responseWriter.getBuffer().toString());
            }
        }
        catch (Throwable t) {
            t = XmlaMediator.gotoRootThrowable(t);
            LOGGER.warn((Object)"Error while processing XML/A request", t);
            responseWriter = new StringWriter();
            SAXHandler handler = new SAXHandler(new SAXWriter(responseWriter));
            try {
                handler.startDocument();
                handler.startElement("SOAP-ENV:Envelope", new String[]{"xmlns:SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/"});
                handler.startElement("SOAP-ENV:Body");
                handler.startElement("SOAP-ENV:Fault");
                handler.startElement("faultcode");
                handler.characters(t.getClass().getName());
                handler.endElement();
                handler.startElement("faultstring");
                handler.characters(t.getMessage());
                handler.endElement();
                handler.startElement("faultactor");
                handler.characters("Mondrian");
                handler.endElement();
                handler.startElement("detail");
                handler.endElement();
                handler.endElement();
                handler.endElement();
                handler.endElement();
                handler.endDocument();
            }
            catch (SAXException se) {
                LOGGER.warn((Object)"Error while reporting error to client", (Throwable)se);
            }
        }
        try {
            PrintWriter outWriter = response.getWriter();
            ((Writer)outWriter).write(responseWriter.getBuffer().toString());
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)"Error while writing response to client", (Throwable)ioe);
        }
    }

    private static boolean compareBytes(byte[] bom, byte[] firstBytes) {
        for (int i = 0; i < bom.length; ++i) {
            if (bom[i] == firstBytes[i]) continue;
            return false;
        }
        return true;
    }

    private static String toString(InputStream is) throws IOException {
        int n;
        InputStreamReader reader = new InputStreamReader(is);
        char[] buf = new char[2048];
        StringBuffer sb = new StringBuffer();
        while ((n = reader.read(buf)) > 0) {
            sb.append(buf, 0, n);
        }
        return sb.toString();
    }
}

