/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.HeaderFooter;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfCodePage;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfInfoElement;
import com.lowagie.text.rtf.document.RtfInfoGroup;
import com.lowagie.text.rtf.document.RtfPageSetting;
import com.lowagie.text.rtf.headerfooter.RtfHeaderFooter;
import com.lowagie.text.rtf.headerfooter.RtfHeaderFooterGroup;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.list.RtfListTable;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfColorList;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfFontList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfDocumentHeader
extends RtfElement {
    private static final byte[] TITLE_PAGE = "\\titlepg".getBytes();
    private static final byte[] FACING_PAGES = "\\facingp".getBytes();
    private RtfCodePage codePage = null;
    private RtfColorList colorList = null;
    private RtfFontList fontList = null;
    private RtfListTable listTable = null;
    private RtfInfoGroup infoGroup = null;
    private RtfPageSetting pageSetting = null;
    private RtfHeaderFooterGroup header = null;
    private RtfHeaderFooterGroup footer = null;

    protected RtfDocumentHeader(RtfDocument doc) {
        super(doc);
    }

    protected void init() {
        this.codePage = new RtfCodePage(this.document);
        this.colorList = new RtfColorList(this.document);
        this.fontList = new RtfFontList(this.document);
        this.listTable = new RtfListTable(this.document);
        this.infoGroup = new RtfInfoGroup(this.document);
        this.pageSetting = new RtfPageSetting(this.document);
        this.header = new RtfHeaderFooterGroup(this.document, 1);
        this.footer = new RtfHeaderFooterGroup(this.document, 2);
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(this.codePage.writeDefinition());
            result.write(this.fontList.writeDefinition());
            result.write(this.colorList.writeDefinition());
            result.write(this.listTable.writeDefinition());
            result.write(this.infoGroup.write());
            result.write(this.pageSetting.writeDefinition());
            result.write(this.writeSectionDefinition());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeSectionDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.header.hasTitlePage() || this.footer.hasTitlePage()) {
                result.write(TITLE_PAGE);
                this.header.setHasTitlePage();
                this.footer.setHasTitlePage();
            }
            if (this.header.hasFacingPages() || this.footer.hasFacingPages()) {
                result.write(FACING_PAGES);
                this.header.setHasFacingPages();
                this.footer.setHasFacingPages();
            }
            result.write(this.footer.write());
            result.write(this.header.write());
            result.write(this.pageSetting.writeSectionDefinition());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public int getFontNumber(RtfFont font) {
        return this.fontList.getFontNumber(font);
    }

    public int getColorNumber(RtfColor color) {
        return this.colorList.getColorNumber(color);
    }

    public int getListNumber(RtfList list) {
        return this.listTable.getListNumber(list);
    }

    public void freeListNumber(RtfList list) {
        this.listTable.freeListNumber(list);
    }

    public RtfPageSetting getPageSetting() {
        return this.pageSetting;
    }

    public void addInfoElement(RtfInfoElement rtfInfoElement) {
        this.infoGroup.add(rtfInfoElement);
    }

    public void setHeader(HeaderFooter header) {
        this.header = header != null ? (header instanceof RtfHeaderFooterGroup ? new RtfHeaderFooterGroup(this.document, (RtfHeaderFooterGroup)header, 1) : (header instanceof RtfHeaderFooter ? new RtfHeaderFooterGroup(this.document, (RtfHeaderFooter)header, 1) : new RtfHeaderFooterGroup(this.document, header, 1))) : new RtfHeaderFooterGroup(this.document, 1);
    }

    public void setFooter(HeaderFooter footer) {
        this.footer = footer != null ? (footer instanceof RtfHeaderFooterGroup ? new RtfHeaderFooterGroup(this.document, (RtfHeaderFooterGroup)footer, 2) : (footer instanceof RtfHeaderFooter ? new RtfHeaderFooterGroup(this.document, (RtfHeaderFooter)footer, 1) : new RtfHeaderFooterGroup(this.document, footer, 2))) : new RtfHeaderFooterGroup(this.document, 2);
    }
}

