/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Point;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.defaults.DefaultDockingStrategy;
import org.flexdock.docking.event.DockingEvent;
import org.flexdock.docking.event.DockingListener;
import org.flexdock.docking.floating.frames.DockingFrame;
import org.flexdock.docking.state.DockingPath;
import org.flexdock.docking.state.DockingState;
import org.flexdock.docking.state.FloatManager;
import org.flexdock.docking.state.tree.SplitNode;
import org.flexdock.perspective.Perspective;
import org.flexdock.perspective.PerspectiveManager;
import org.flexdock.util.DockingUtility;
import org.flexdock.util.RootWindow;
import org.flexdock.util.SwingUtility;

public class DockingStateListener
extends DockingListener.Stub {
    private boolean isEnabled = true;

    public synchronized boolean isEnabled() {
        return this.isEnabled;
    }

    public synchronized void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void dockingComplete(final DockingEvent dockingEvent) {
        Component frame;
        if (!this.isEnabled()) {
            return;
        }
        Dockable dockable = dockingEvent.getDockable();
        DockingState info = this.getDockingState(dockable);
        info.setMinimizedConstraint(-1);
        RootWindow window = RootWindow.getRootContainer(dockable.getComponent());
        FloatManager floatManager = DockingManager.getLayoutManager().getFloatManager();
        Component component = frame = window == null ? null : window.getRootContainer();
        if (frame instanceof DockingFrame) {
            String groupId = ((DockingFrame)window.getRootContainer()).getGroupName();
            floatManager.addToGroup(dockable, groupId);
        } else {
            floatManager.removeFromGroup(dockable);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DockingStateListener.this.updateState(dockingEvent);
            }
        });
    }

    public void undockingStarted(DockingEvent evt) {
        if (this.isEnabled()) {
            this.updateState(evt);
        }
    }

    public void updateState(Dockable dockable) {
        if (dockable == null) {
            return;
        }
        if (DockingUtility.isEmbedded(dockable)) {
            this.updateEmbedded(dockable);
        }
    }

    private void updateEmbedded(Dockable dockable) {
        if (!dockable.getComponent().isValid()) {
            return;
        }
        this.updateCenterPoint(dockable);
        this.updateDockingPath(dockable);
        this.updateRelative(dockable);
    }

    private void updateState(DockingEvent evt) {
        this.updateState(evt.getDockable());
    }

    private float getSplitPaneRatio(Dockable dockable, String region) {
        SplitNode lastSplitNode = DockingPath.createNode(dockable);
        if (lastSplitNode != null) {
            return lastSplitNode.getPercentage();
        }
        Float ratioObject = dockable.getDockingProperties().getRegionInset(region);
        if (ratioObject != null) {
            return ratioObject.floatValue();
        }
        return DockingManager.getDefaultSiblingSize();
    }

    private void updateCenterPoint(Dockable dockable) {
        Component comp = dockable.getComponent();
        Point p = new Point(comp.getWidth() / 2, comp.getHeight() / 2);
        RootWindow window = RootWindow.getRootContainer(comp);
        Container contentPane = window.getContentPane();
        p = SwingUtilities.convertPoint(comp, p, contentPane);
        float x = (float)p.x / (float)contentPane.getWidth() * 100.0f;
        float y = (float)p.y / (float)contentPane.getHeight() * 100.0f;
        p.x = Math.round(x);
        p.y = Math.round(y);
        DockingState info = this.getDockingState(dockable);
        info.setCenter(p);
    }

    private void updateDockingPath(Dockable dockable) {
        DockingState info = this.getDockingState(dockable);
        DockingPath path = DockingPath.create(dockable);
        info.setPath(path);
    }

    private void updateRelative(Dockable dockable) {
        Dockable sibling;
        DockingState info = this.getDockingState(dockable);
        DockingPort port = dockable.getDockingPort();
        if (port.getDockedComponent() != dockable.getComponent()) {
            return;
        }
        Container comp = ((Component)((Object)port)).getParent();
        if (!(comp instanceof JSplitPane)) {
            this.setNullRelative(info);
            return;
        }
        JSplitPane splitPane = (JSplitPane)comp;
        Component siblingComp = SwingUtility.getOtherComponent(splitPane, (Component)((Object)port));
        if (!(siblingComp instanceof DockingPort)) {
            this.setNullRelative(info);
            return;
        }
        Component otherDocked = ((DockingPort)((Object)siblingComp)).getDockedComponent();
        Dockable dockable2 = sibling = otherDocked instanceof JSplitPane || otherDocked instanceof JTabbedPane ? null : DockingManager.getDockable(otherDocked);
        if (sibling == null) {
            this.setNullRelative(info);
            return;
        }
        String region = DefaultDockingStrategy.findRegion(dockable.getComponent());
        float ratio = SwingUtility.getDividerProportion(splitPane);
        info.setRelativeParent(sibling);
        info.setRegion(region);
        info.setSplitRatio(ratio);
        info = this.getDockingState(sibling);
        info.setRelativeParent(dockable);
        info.setRegion(DockingUtility.flipRegion(region));
        info.setSplitRatio(ratio);
    }

    private void setNullRelative(DockingState info) {
        info.setRelativeParentId(null);
        info.setSplitRatio(-1.0f);
        info.setRegion("CENTER");
    }

    private DockingState getDockingState(Dockable dockable) {
        return this.getPerspective().getDockingState(dockable, true);
    }

    private Perspective getPerspective() {
        return PerspectiveManager.getInstance().getCurrentPerspective();
    }
}

