/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.StringReader;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JRStyledTextParser {
    private static final String ROOT_START = "<st>";
    private static final String ROOT_END = "</st>";
    private static final String NODE_style = "style";
    private static final String NODE_bold = "b";
    private static final String NODE_italic = "i";
    private static final String NODE_underline = "u";
    private static final String NODE_sup = "sup";
    private static final String NODE_sub = "sub";
    private static final String NODE_font = "font";
    private static final String NODE_br = "br";
    private static final String NODE_li = "li";
    private static final String ATTRIBUTE_fontName = "fontName";
    private static final String ATTRIBUTE_fontFace = "face";
    private static final String ATTRIBUTE_color = "color";
    private static final String ATTRIBUTE_size = "size";
    private static final String ATTRIBUTE_isBold = "isBold";
    private static final String ATTRIBUTE_isItalic = "isItalic";
    private static final String ATTRIBUTE_isUnderline = "isUnderline";
    private static final String ATTRIBUTE_isStrikeThrough = "isStrikeThrough";
    private static final String ATTRIBUTE_forecolor = "forecolor";
    private static final String ATTRIBUTE_backcolor = "backcolor";
    private static final String ATTRIBUTE_pdfFontName = "pdfFontName";
    private static final String ATTRIBUTE_pdfEncoding = "pdfEncoding";
    private static final String ATTRIBUTE_isPdfEmbedded = "isPdfEmbedded";
    private static final String SPACE = " ";
    private static final String EQUAL_QUOTE = "=\"";
    private static final String QUOTE = "\"";
    private static final String SHARP = "#";
    private static final String LESS = "<";
    private static final String LESS_SLASH = "</";
    private static final String GREATER = ">";
    private DocumentBuilder documentBuilder = null;

    public JRStyledTextParser() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new JRRuntimeException(e);
        }
    }

    public JRStyledText parse(Map attributes, String text) throws SAXException {
        JRStyledText styledText = new JRStyledText();
        Document document = null;
        try {
            document = this.documentBuilder.parse(new InputSource(new StringReader(ROOT_START + text + ROOT_END)));
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        this.parseStyle(styledText, document.getDocumentElement());
        styledText.addRun(new JRStyledText.Run(attributes, 0, styledText.length()));
        return styledText;
    }

    public String write(Map parentAttrs, AttributedCharacterIterator iterator, String text) {
        StringBuffer sbuffer = new StringBuffer();
        int runLimit = 0;
        while (runLimit < iterator.getEndIndex() && (runLimit = iterator.getRunLimit()) <= iterator.getEndIndex()) {
            String chunk = text.substring(iterator.getIndex(), runLimit);
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iterator.getAttributes();
            StringBuffer styleBuffer = this.writeStyleAttributes(parentAttrs, attrs);
            if (styleBuffer.length() > 0) {
                sbuffer.append(LESS);
                sbuffer.append(NODE_style);
                sbuffer.append(styleBuffer.toString());
                sbuffer.append(GREATER);
                this.writeChunk(sbuffer, parentAttrs, attrs, chunk);
                sbuffer.append(LESS_SLASH);
                sbuffer.append(NODE_style);
                sbuffer.append(GREATER);
            } else {
                this.writeChunk(sbuffer, parentAttrs, attrs, chunk);
            }
            iterator.setIndex(runLimit);
        }
        return sbuffer.toString();
    }

    public void writeChunk(StringBuffer sbuffer, Map parentAttrs, Map attrs, String chunk) {
        Object value = attrs.get(TextAttribute.SUPERSCRIPT);
        Object oldValue = parentAttrs.get(TextAttribute.SUPERSCRIPT);
        boolean isSuper = false;
        boolean isSub = false;
        if (value != null && !value.equals(oldValue)) {
            isSuper = TextAttribute.SUPERSCRIPT_SUPER.equals(value);
            isSub = TextAttribute.SUPERSCRIPT_SUB.equals(value);
        }
        if (isSuper || isSub) {
            String node = isSuper ? NODE_sup : NODE_sub;
            sbuffer.append(LESS);
            sbuffer.append(node);
            sbuffer.append(GREATER);
            sbuffer.append(JRStringUtil.xmlEncode(chunk));
            sbuffer.append(LESS_SLASH);
            sbuffer.append(node);
            sbuffer.append(GREATER);
        } else {
            sbuffer.append(JRStringUtil.xmlEncode(chunk));
        }
    }

    private void parseStyle(JRStyledText styledText, Node parentNode) throws SAXException {
        NodeList nodeList = parentNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            int startIndex;
            HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                styledText.append(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() == 1 && NODE_style.equals(node.getNodeName())) {
                Color color;
                NamedNodeMap nodeAttrs = node.getAttributes();
                styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                if (nodeAttrs.getNamedItem(ATTRIBUTE_fontName) != null) {
                    styleAttrs.put(TextAttribute.FAMILY, nodeAttrs.getNamedItem(ATTRIBUTE_fontName).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isBold) != null) {
                    styleAttrs.put(TextAttribute.WEIGHT, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isBold).getNodeValue()) != false ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isItalic) != null) {
                    styleAttrs.put(TextAttribute.POSTURE, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isItalic).getNodeValue()) != false ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isUnderline) != null) {
                    styleAttrs.put(TextAttribute.UNDERLINE, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isUnderline).getNodeValue()) != false ? TextAttribute.UNDERLINE_ON : null);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isStrikeThrough) != null) {
                    styleAttrs.put(TextAttribute.STRIKETHROUGH, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isStrikeThrough).getNodeValue()) != false ? TextAttribute.STRIKETHROUGH_ON : null);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_size) != null) {
                    styleAttrs.put(TextAttribute.SIZE, new Float(nodeAttrs.getNamedItem(ATTRIBUTE_size).getNodeValue()));
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_pdfFontName) != null) {
                    styleAttrs.put(JRTextAttribute.PDF_FONT_NAME, nodeAttrs.getNamedItem(ATTRIBUTE_pdfFontName).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_pdfEncoding) != null) {
                    styleAttrs.put(JRTextAttribute.PDF_ENCODING, nodeAttrs.getNamedItem(ATTRIBUTE_pdfEncoding).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isPdfEmbedded) != null) {
                    styleAttrs.put(JRTextAttribute.IS_PDF_EMBEDDED, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isPdfEmbedded).getNodeValue()));
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_forecolor) != null) {
                    color = JRXmlConstants.getColor(nodeAttrs.getNamedItem(ATTRIBUTE_forecolor).getNodeValue(), Color.black);
                    styleAttrs.put(TextAttribute.FOREGROUND, color);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_backcolor) != null) {
                    color = JRXmlConstants.getColor(nodeAttrs.getNamedItem(ATTRIBUTE_backcolor).getNodeValue(), Color.black);
                    styleAttrs.put(TextAttribute.BACKGROUND, color);
                }
                startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_bold.equalsIgnoreCase(node.getNodeName())) {
                HashMap<TextAttribute, Float> styleAttrs2 = new HashMap<TextAttribute, Float>();
                styleAttrs2.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                int startIndex2 = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs2, startIndex2, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_italic.equalsIgnoreCase(node.getNodeName())) {
                HashMap<TextAttribute, Float> styleAttrs3 = new HashMap<TextAttribute, Float>();
                styleAttrs3.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                int startIndex3 = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs3, startIndex3, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_underline.equalsIgnoreCase(node.getNodeName())) {
                HashMap<TextAttribute, Integer> styleAttrs4 = new HashMap<TextAttribute, Integer>();
                styleAttrs4.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                int startIndex4 = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs4, startIndex4, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_sup.equalsIgnoreCase(node.getNodeName())) {
                HashMap<TextAttribute, Integer> styleAttrs5 = new HashMap<TextAttribute, Integer>();
                styleAttrs5.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
                int startIndex5 = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs5, startIndex5, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_sub.equalsIgnoreCase(node.getNodeName())) {
                HashMap<TextAttribute, Integer> styleAttrs6 = new HashMap<TextAttribute, Integer>();
                styleAttrs6.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
                int startIndex6 = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs6, startIndex6, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_font.equalsIgnoreCase(node.getNodeName())) {
                NamedNodeMap nodeAttrs = node.getAttributes();
                styleAttrs = new HashMap();
                if (nodeAttrs.getNamedItem(ATTRIBUTE_fontFace) != null) {
                    styleAttrs.put(JRTextAttribute.HTML_FONT_FACE, nodeAttrs.getNamedItem(ATTRIBUTE_fontFace).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_size) != null) {
                    styleAttrs.put(TextAttribute.SIZE, new Float(nodeAttrs.getNamedItem(ATTRIBUTE_size).getNodeValue()));
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_color) != null) {
                    Color color = JRXmlConstants.getColor(nodeAttrs.getNamedItem(ATTRIBUTE_color).getNodeValue(), Color.black);
                    styleAttrs.put(TextAttribute.FOREGROUND, color);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_fontFace) != null) {
                    String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                    String fontFaces = nodeAttrs.getNamedItem(ATTRIBUTE_fontFace).getNodeValue();
                    StringTokenizer t = new StringTokenizer(fontFaces, ",");
                    block1: while (t.hasMoreTokens()) {
                        String face = t.nextToken().trim();
                        for (int j = 0; j < fontList.length; ++j) {
                            if (!fontList[j].equals(face)) continue;
                            styleAttrs.put(TextAttribute.FAMILY, face);
                            break block1;
                        }
                    }
                }
                startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_br.equalsIgnoreCase(node.getNodeName())) {
                styledText.append("\n");
                int startIndex7 = styledText.length();
                this.resizeRuns(styledText.getRuns(), startIndex7, 1);
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(new HashMap(), startIndex7, styledText.length()));
                if (startIndex7 >= styledText.length()) continue;
                styledText.append("\n");
                this.resizeRuns(styledText.getRuns(), startIndex7, 1);
                continue;
            }
            if (node.getNodeType() == 1 && NODE_li.equalsIgnoreCase(node.getNodeName())) {
                styledText.append("\n \u2022 ");
                int startIndex8 = styledText.length();
                this.resizeRuns(styledText.getRuns(), startIndex8, 1);
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(new HashMap(), startIndex8, styledText.length()));
                styledText.append("\n");
                this.resizeRuns(styledText.getRuns(), startIndex8, 1);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            String nodeName = LESS + node.getNodeName() + GREATER;
            throw new SAXException("Tag " + nodeName + " is not a valid styled text tag.");
        }
    }

    private void resizeRuns(List runs, int startIndex, int count) {
        for (int j = 0; j < runs.size(); ++j) {
            JRStyledText.Run run = (JRStyledText.Run)runs.get(j);
            if (run.startIndex > startIndex || run.endIndex <= startIndex - count) continue;
            run.endIndex += count;
        }
    }

    private StringBuffer writeStyleAttributes(Map parentAttrs, Map attrs) {
        StringBuffer sbuffer = new StringBuffer();
        Object value = attrs.get(TextAttribute.FAMILY);
        Object oldValue = parentAttrs.get(TextAttribute.FAMILY);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_fontName);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.WEIGHT);
        oldValue = parentAttrs.get(TextAttribute.WEIGHT);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isBold);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value.equals(TextAttribute.WEIGHT_BOLD));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.POSTURE);
        oldValue = parentAttrs.get(TextAttribute.POSTURE);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isItalic);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value.equals(TextAttribute.POSTURE_OBLIQUE));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.UNDERLINE);
        oldValue = parentAttrs.get(TextAttribute.UNDERLINE);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isUnderline);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value != null);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.STRIKETHROUGH);
        oldValue = parentAttrs.get(TextAttribute.STRIKETHROUGH);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isStrikeThrough);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value != null);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.SIZE);
        oldValue = parentAttrs.get(TextAttribute.SIZE);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_size);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(((Float)value).intValue());
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.PDF_FONT_NAME);
        oldValue = parentAttrs.get(JRTextAttribute.PDF_FONT_NAME);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_pdfFontName);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.PDF_ENCODING);
        oldValue = parentAttrs.get(JRTextAttribute.PDF_ENCODING);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_pdfEncoding);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.IS_PDF_EMBEDDED);
        oldValue = parentAttrs.get(JRTextAttribute.IS_PDF_EMBEDDED);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isPdfEmbedded);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.FOREGROUND);
        oldValue = parentAttrs.get(TextAttribute.FOREGROUND);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_forecolor);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(SHARP);
            sbuffer.append(JRColorUtil.getColorHexa((Color)value));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.BACKGROUND);
        oldValue = parentAttrs.get(TextAttribute.BACKGROUND);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_backcolor);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(SHARP);
            sbuffer.append(JRColorUtil.getColorHexa((Color)value));
            sbuffer.append(QUOTE);
        }
        return sbuffer;
    }
}

