/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.InputStream;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.view.JRDesignRenderer;

public class JRDesignViewer
extends JPanel {
    private static final int TYPE_FILE_NAME = 1;
    private static final int TYPE_INPUT_STREAM = 2;
    private static final int TYPE_JASPER_DESIGN = 3;
    private static final int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250};
    private int type = 1;
    private boolean isXML = false;
    private String reportFileName = null;
    protected JRDesignRenderer reportRenderer;
    private float zoom = 1.0f;
    private int screenResolution = 72;
    private float realZoom = 0.0f;
    private int downX = 0;
    private int downY = 0;
    protected JPanel tlbToolBar;
    private JPanel pnlInScroll;
    private JPanel jPanel4;
    private JPanel pnlPage;
    private JLabel jLabel1;
    private JScrollPane scrollPane;
    private JPanel pnlMain;
    private JPanel pnlSep02;
    private JButton btnReload;
    private JPanel jPanel5;
    private JButton btnZoomOut;
    private JLabel lblPage;
    private JPanel jPanel8;
    private JButton btnZoomIn;
    private JPanel jPanel7;
    private JPanel pnlSep01;
    private JPanel jPanel6;
    private JComboBox cmbZoom;
    private JPanel jPanel9;

    public JRDesignViewer(String fileName, boolean isXML) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.setScreenDetails();
        this.initComponents();
        this.loadReport(fileName, isXML);
        this.cmbZoom.setSelectedIndex(2);
    }

    public JRDesignViewer(InputStream is, boolean isXML) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.setScreenDetails();
        this.initComponents();
        this.loadReport(is, isXML);
        this.cmbZoom.setSelectedIndex(2);
    }

    public JRDesignViewer(JRReport report) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.setScreenDetails();
        this.initComponents();
        this.loadReport(report);
        this.cmbZoom.setSelectedIndex(2);
    }

    private void setScreenDetails() {
        this.screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        this.setZoom(1.0f);
    }

    private void initComponents() {
        this.tlbToolBar = new JPanel();
        this.btnReload = new JButton();
        this.pnlSep01 = new JPanel();
        this.pnlSep02 = new JPanel();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.cmbZoom = new JComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < zooms.length; ++i) {
            model.addElement("" + zooms[i] + "%");
        }
        this.cmbZoom.setModel(model);
        this.pnlMain = new JPanel();
        this.scrollPane = new JScrollPane();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.pnlInScroll = new JPanel();
        this.pnlPage = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        this.lblPage = new JLabel();
        this.setLayout(new BorderLayout());
        this.tlbToolBar.setLayout(new FlowLayout(0, 0, 2));
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/reload.GIF")));
        this.btnReload.setText("Reload");
        this.btnReload.setToolTipText("Reload Document");
        this.btnReload.setMargin(new Insets(2, 2, 2, 2));
        this.btnReload.setMaximumSize(new Dimension(80, 23));
        this.btnReload.setMinimumSize(new Dimension(80, 23));
        this.btnReload.setPreferredSize(new Dimension(80, 23));
        this.btnReload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.btnReloadActionPerformed();
            }
        });
        this.tlbToolBar.add(this.btnReload);
        this.pnlSep01.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep01);
        this.pnlSep02.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep02);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomin.GIF")));
        this.btnZoomIn.setToolTipText("Zoom In");
        this.btnZoomIn.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomIn.setMaximumSize(new Dimension(23, 23));
        this.btnZoomIn.setMinimumSize(new Dimension(23, 23));
        this.btnZoomIn.setPreferredSize(new Dimension(23, 23));
        this.btnZoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.btnZoomInActionPerformed();
            }
        });
        this.tlbToolBar.add(this.btnZoomIn);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomout.GIF")));
        this.btnZoomOut.setToolTipText("Zoom Out");
        this.btnZoomOut.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomOut.setMaximumSize(new Dimension(23, 23));
        this.btnZoomOut.setMinimumSize(new Dimension(23, 23));
        this.btnZoomOut.setPreferredSize(new Dimension(23, 23));
        this.btnZoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.btnZoomOutActionPerformed();
            }
        });
        this.tlbToolBar.add(this.btnZoomOut);
        this.cmbZoom.setToolTipText("Zoom Ratio");
        this.cmbZoom.setMaximumSize(new Dimension(80, 23));
        this.cmbZoom.setMinimumSize(new Dimension(80, 23));
        this.cmbZoom.setPreferredSize(new Dimension(80, 23));
        this.cmbZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.cmbZoomActionPerformed();
            }
        });
        this.tlbToolBar.add(this.cmbZoom);
        this.add((Component)this.tlbToolBar, "North");
        this.pnlMain.setLayout(new BorderLayout());
        this.pnlInScroll.setLayout(new GridBagLayout());
        this.pnlPage.setLayout(new BorderLayout());
        this.pnlPage.setMinimumSize(new Dimension(100, 100));
        this.pnlPage.setPreferredSize(new Dimension(100, 100));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setMinimumSize(new Dimension(100, 120));
        this.jPanel4.setPreferredSize(new Dimension(100, 120));
        this.jPanel5.setBackground(Color.gray);
        this.jPanel5.setMinimumSize(new Dimension(5, 5));
        this.jPanel5.setPreferredSize(new Dimension(5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setMinimumSize(new Dimension(5, 5));
        this.jPanel6.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setBackground(Color.gray);
        this.jPanel7.setMinimumSize(new Dimension(5, 5));
        this.jPanel7.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setBackground(Color.gray);
        this.jPanel8.setMinimumSize(new Dimension(5, 5));
        this.jPanel8.setPreferredSize(new Dimension(5, 5));
        this.jLabel1.setText("jLabel1");
        this.jPanel8.add(this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setMinimumSize(new Dimension(5, 5));
        this.jPanel9.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.lblPage.setBackground(Color.white);
        this.lblPage.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.lblPage.setOpaque(true);
        this.lblPage.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                JRDesignViewer.this.lblPageMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                JRDesignViewer.this.lblPageMouseReleased();
            }
        });
        this.lblPage.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                JRDesignViewer.this.lblPageMouseDragged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.lblPage, gridBagConstraints);
        this.pnlPage.add((Component)this.jPanel4, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInScroll.add((Component)this.pnlPage, gridBagConstraints);
        this.scrollPane.setViewportView(this.pnlInScroll);
        this.pnlMain.add((Component)this.scrollPane, "Center");
        this.add((Component)this.pnlMain, "Center");
    }

    void btnReloadActionPerformed() {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
                this.refreshDesign();
            }
            catch (JRException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error loading report design. See console for details.");
            }
        }
    }

    void btnZoomInActionPerformed() {
        int index = this.cmbZoom.getSelectedIndex();
        if (index < this.cmbZoom.getModel().getSize() - 1) {
            this.cmbZoom.setSelectedIndex(index + 1);
        }
    }

    void btnZoomOutActionPerformed() {
        int index = this.cmbZoom.getSelectedIndex();
        if (index > 0) {
            this.cmbZoom.setSelectedIndex(index - 1);
        }
    }

    void lblPageMousePressed(MouseEvent evt) {
        this.lblPage.setCursor(new Cursor(13));
        this.downX = evt.getX();
        this.downY = evt.getY();
    }

    void lblPageMouseReleased() {
        this.lblPage.setCursor(new Cursor(0));
    }

    void lblPageMouseDragged(MouseEvent evt) {
        Container container = this.pnlInScroll.getParent();
        if (container instanceof JViewport) {
            JViewport viewport = (JViewport)container;
            Point point = viewport.getViewPosition();
            int newX = point.x - (evt.getX() - this.downX);
            int newY = point.y - (evt.getY() - this.downY);
            int maxX = this.pnlInScroll.getWidth() - viewport.getWidth();
            int maxY = this.pnlInScroll.getHeight() - viewport.getHeight();
            if (newX < 0) {
                newX = 0;
            }
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY < 0) {
                newY = 0;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            viewport.setViewPosition(new Point(newX, newY));
        }
    }

    void cmbZoomActionPerformed() {
        int index = this.cmbZoom.getSelectedIndex();
        this.setZoom((float)zooms[index] / 100.0f);
        this.btnZoomIn.setEnabled(index < this.cmbZoom.getModel().getSize() - 1);
        this.btnZoomOut.setEnabled(index > 0);
        this.refreshDesign();
    }

    private void setZoom(float zoom) {
        this.zoom = zoom;
        this.realZoom = this.zoom * (float)this.screenResolution / 72.0f;
    }

    private void verifyDesign(JasperDesign jasperDesign) throws JRException {
        Collection brokenRules = JasperCompileManager.verifyDesign(jasperDesign);
        if (brokenRules != null && brokenRules.size() > 0) {
            throw new JRValidationException(brokenRules);
        }
    }

    private void loadReport(String fileName, boolean isXmlReport) throws JRException {
        if (isXmlReport) {
            JasperDesign jasperDesign = JRXmlLoader.load(fileName);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(fileName));
        }
        this.type = 1;
        this.isXML = isXmlReport;
        this.reportFileName = fileName;
        this.btnReload.setEnabled(true);
    }

    private void loadReport(InputStream is, boolean isXmlReport) throws JRException {
        if (isXmlReport) {
            JasperDesign jasperDesign = JRXmlLoader.load(is);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(is));
        }
        this.type = 2;
        this.isXML = isXmlReport;
        this.btnReload.setEnabled(false);
    }

    private void loadReport(JRReport rep) throws JRException {
        this.setReport(rep);
        this.type = 3;
        this.isXML = false;
        this.btnReload.setEnabled(false);
    }

    private void setReport(JRReport report) throws JRException {
        if (report instanceof JasperDesign) {
            this.verifyDesign((JasperDesign)report);
        }
        this.reportRenderer = new JRDesignRenderer(report, this);
    }

    private void refreshDesign() {
        Image image = null;
        ImageIcon imageIcon = null;
        JRDesignRenderer.RenderDimesion renderDim = this.reportRenderer.getDimension(this.realZoom);
        Dimension dim = new Dimension(renderDim.width + 7, renderDim.height + 7);
        this.pnlPage.setMaximumSize(dim);
        this.pnlPage.setMinimumSize(dim);
        this.pnlPage.setPreferredSize(dim);
        try {
            image = this.reportRenderer.renderToImage(this.realZoom);
            imageIcon = new ImageIcon(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lblPage.setIcon(imageIcon);
    }
}

